/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.screen.custom.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomButton
extends AbstractButton {
    public static final int SMALL_WIDTH = 120;
    public static final int DEFAULT_WIDTH = 150;
    public static final int DEFAULT_HEIGHT = 20;
    protected static final CreateNarration DEFAULT_NARRATION = p_253298_ -> (MutableComponent)p_253298_.get();
    protected final OnPress onPress;
    protected final CreateNarration createNarration;

    public static Builder builder(Component pMessage, OnPress pOnPress) {
        return new Builder(pMessage, pOnPress);
    }

    protected CustomButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, OnPress pOnPress, CreateNarration pCreateNarration) {
        super(pX, pY, pWidth, pHeight, pMessage);
        this.onPress = pOnPress;
        this.createNarration = pCreateNarration;
    }

    protected CustomButton(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.createNarration);
        this.m_257544_(builder.tooltip);
    }

    public void m_5691_() {
        this.onPress.onPress(this);
    }

    protected MutableComponent m_5646_() {
        return this.createNarration.createNarrationMessage(() -> super.m_5646_());
    }

    public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        this.m_168802_(pNarrationElementOutput);
    }

    private int shouldDoBorder() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        pGuiGraphics.m_280027_(new ResourceLocation("vortexmod", "textures/gui/widgets.png"), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.shouldDoBorder());
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.getFGColor();
        this.m_280139_(pGuiGraphics, minecraft.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component message;
        private final OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private CreateNarration createNarration = DEFAULT_NARRATION;

        public Builder(Component pMessage, OnPress pOnPress) {
            this.message = pMessage;
            this.onPress = pOnPress;
        }

        public Builder pos(int pX, int pY) {
            this.x = pX;
            this.y = pY;
            return this;
        }

        public Builder width(int pWidth) {
            this.width = pWidth;
            return this;
        }

        public Builder size(int pWidth, int pHeight) {
            this.width = pWidth;
            this.height = pHeight;
            return this;
        }

        public Builder bounds(int pX, int pY, int pWidth, int pHeight) {
            return this.pos(pX, pY).size(pWidth, pHeight);
        }

        public Builder tooltip(@Nullable Tooltip pTooltip) {
            this.tooltip = pTooltip;
            return this;
        }

        public Builder createNarration(CreateNarration pCreateNarration) {
            this.createNarration = pCreateNarration;
            return this;
        }

        public CustomButton build() {
            return this.build(CustomButton::new);
        }

        public CustomButton build(Function<Builder, CustomButton> builder) {
            return builder.apply(this);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(CustomButton var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CreateNarration {
        public MutableComponent createNarrationMessage(Supplier<MutableComponent> var1);
    }
}

