/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.screen.custom.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.plaaasma.vortexmod.network.PacketHandler;
import net.plaaasma.vortexmod.network.ServerboundDeleteTargetPacket;
import net.plaaasma.vortexmod.network.ServerboundSaveTargetPacket;
import net.plaaasma.vortexmod.network.ServerboundTargetPacket;
import net.plaaasma.vortexmod.screen.custom.menu.KeypadMenu;
import net.plaaasma.vortexmod.screen.custom.widgets.CustomButton;

public class KeypadScreen
extends AbstractContainerScreen<KeypadMenu> {
    private Boolean targetScreen = true;
    private int selected_dim_index = 0;
    private int selected_location_index = 0;
    private EditBox x;
    private EditBox y;
    private EditBox z;
    private EditBox rotation;
    private EditBox dimension;
    private CustomButton done_button;
    private CustomButton cancel_button;
    private CustomButton toggle_button;
    private EditBox name;
    private CustomButton save_button;
    private CustomButton load_button;
    private CustomButton delete_button;
    private static final ResourceLocation TEXTURE = new ResourceLocation("vortexmod", "textures/gui/keypad_gui.png");
    private static final ResourceLocation TEXTURE_SECONDARY = new ResourceLocation("vortexmod", "textures/gui/keypad_gui_locations.png");

    public KeypadScreen(KeypadMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 10000;
        this.f_97729_ = 10000;
        this.f_97728_ = 10000;
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.x = new EditBox(this.f_96547_, i + 62, j + 19, 46, 10, (Component)Component.m_237115_((String)"keypad.x_coord"));
        this.x.m_94190_(true);
        this.x.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.x.m_94205_(ChatFormatting.BLACK.m_126665_().intValue());
        this.x.m_94199_(8);
        this.x.m_94144_("");
        this.x.m_94182_(false);
        this.m_7787_((GuiEventListener)this.x);
        this.y = new EditBox(this.f_96547_, i + 117, j + 19, 46, 10, (Component)Component.m_237115_((String)"keypad.y_coord"));
        this.y.m_94190_(true);
        this.y.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.y.m_94205_(ChatFormatting.DARK_GRAY.m_126665_().intValue());
        this.y.m_94199_(8);
        this.y.m_94144_("");
        this.y.m_94182_(false);
        this.m_7787_((GuiEventListener)this.y);
        this.z = new EditBox(this.f_96547_, i + 117, j + 46, 46, 12, (Component)Component.m_237115_((String)"keypad.z_coord"));
        this.z.m_94190_(true);
        this.z.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.z.m_94205_(ChatFormatting.DARK_GRAY.m_126665_().intValue());
        this.z.m_94199_(8);
        this.z.m_94144_("");
        this.z.m_94182_(false);
        this.m_7787_((GuiEventListener)this.z);
        this.rotation = new EditBox(this.f_96547_, i + 61, j + 46, 46, 12, (Component)Component.m_237115_((String)"keypad.rotation"));
        this.rotation.m_94190_(true);
        this.rotation.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.rotation.m_94205_(ChatFormatting.DARK_GRAY.m_126665_().intValue());
        this.rotation.m_94199_(3);
        this.rotation.m_94144_("");
        this.rotation.m_94182_(false);
        this.m_7787_((GuiEventListener)this.rotation);
        this.dimension = new EditBox(this.f_96547_, i + 88, j + 73, 102, 12, (Component)Component.m_237115_((String)"keypad.dimension"));
        this.dimension.m_94190_(true);
        this.dimension.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.dimension.m_94205_(ChatFormatting.DARK_GRAY.m_126665_().intValue());
        this.dimension.m_94199_(32);
        this.dimension.m_94144_("");
        this.dimension.m_94182_(false);
        this.m_7787_((GuiEventListener)this.dimension);
        this.done_button = (CustomButton)this.m_142416_((GuiEventListener)CustomButton.builder((Component)Component.m_237113_((String)"Set"), p_97691_ -> this.onDone()).bounds(i + 45, j + 90, 40, 20).build());
        this.cancel_button = (CustomButton)this.m_142416_((GuiEventListener)CustomButton.builder(CommonComponents.f_130656_, p_97691_ -> this.m_7379_()).bounds(i + 91, j + 90, 40, 20).build());
        this.toggle_button = (CustomButton)this.m_142416_((GuiEventListener)CustomButton.builder((Component)Component.m_237113_((String)"<<<<>>>>"), p_97691_ -> {
            this.targetScreen = this.targetScreen == false;
            this.toggle_button.m_93692_(false);
        }).bounds(i + 140, j + 90, 28, 20).build());
        this.toggle_button.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Toggles between the locations gui and the target setting gui.")));
        this.name = new EditBox(this.f_96547_, i + 45, j + 61, 100, 12, (Component)Component.m_237115_((String)"keypad.name"));
        this.name.m_94190_(true);
        this.name.m_94202_(ChatFormatting.WHITE.m_126665_().intValue());
        this.name.m_94205_(ChatFormatting.DARK_GRAY.m_126665_().intValue());
        this.name.m_94199_(32);
        this.name.m_94144_("");
        this.name.m_94182_(false);
        this.m_7787_((GuiEventListener)this.name);
        this.save_button = (CustomButton)this.m_142416_((GuiEventListener)CustomButton.builder((Component)Component.m_237113_((String)"Save"), p_97691_ -> {
            this.onSave();
            this.save_button.m_93692_(false);
        }).bounds(i + 8, j + 90, 42, 20).build());
        this.save_button.f_93624_ = false;
        this.load_button = (CustomButton)this.m_142416_((GuiEventListener)CustomButton.builder((Component)Component.m_237113_((String)"Load"), p_97691_ -> {
            this.onLoad();
            this.load_button.m_93692_(false);
        }).bounds(i + 52, j + 90, 42, 20).build());
        this.load_button.f_93624_ = false;
        this.delete_button = (CustomButton)this.m_142416_((GuiEventListener)CustomButton.builder((Component)Component.m_237113_((String)"Delete"), p_97691_ -> {
            this.onDelete();
            this.delete_button.m_93692_(false);
        }).bounds(i + 96, j + 90, 42, 20).build());
        this.delete_button.f_93624_ = false;
        this.m_264313_((GuiEventListener)this.x);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 1) {
            if (this.dimension.m_274382_() && this.selected_dim_index > 0) {
                ArrayList<String> oldLevels = new ArrayList<String>(((KeypadMenu)this.f_97732_).blockEntity.serverLevels);
                ArrayList<String> levels = new ArrayList<String>();
                for (String levelName : oldLevels) {
                    if (!levelName.contains(this.dimension.m_94155_()) && !this.dimension.m_94155_().equals("")) continue;
                    levels.add(levelName);
                }
                String selectedPath = "";
                int iterationNumber = 1;
                for (String levelName : levels) {
                    if (iterationNumber == this.selected_dim_index) {
                        selectedPath = levelName;
                        break;
                    }
                    ++iterationNumber;
                }
                this.dimension.m_94144_(selectedPath);
                this.selected_dim_index = 1;
            }
            if (this.name.m_274382_() && this.selected_location_index > 0) {
                Set<String> coordKeys = ((KeypadMenu)this.f_97732_).blockEntity.coordData.keySet();
                ArrayList<CallSite> locationStrings = new ArrayList<CallSite>();
                String playerName = this.f_96541_.f_91074_.m_6302_();
                for (String coordKey : coordKeys) {
                    String pointDimension;
                    BlockPos blockPos;
                    String pointCoords;
                    Object pointName;
                    String locString;
                    if (!coordKey.startsWith(playerName) || !(locString = (String)(pointName = coordKey.substring(playerName.length()) + ": ") + (pointCoords = (blockPos = ((KeypadMenu)this.f_97732_).blockEntity.coordData.get(coordKey)).m_123341_() + " " + blockPos.m_123342_() + " " + blockPos.m_123343_() + " | ") + (pointDimension = ((KeypadMenu)this.f_97732_).blockEntity.dimData.get(coordKey))).contains(this.name.m_94155_()) && !this.name.m_94155_().equals("")) continue;
                    locationStrings.add((CallSite)((Object)locString));
                }
                String selectedLocation = "";
                int iterationNumber = 1;
                for (String string : locationStrings) {
                    if (iterationNumber == this.selected_location_index) {
                        selectedLocation = string;
                        break;
                    }
                    ++iterationNumber;
                }
                int spaceIndex = selectedLocation.indexOf(58);
                this.name.m_94144_(selectedLocation.substring(0, spaceIndex));
                this.selected_location_index = 1;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pScrollX) {
        if (this.dimension.m_274382_()) {
            ArrayList<String> oldLevels = new ArrayList<String>(((KeypadMenu)this.f_97732_).blockEntity.serverLevels);
            ArrayList<String> levels = new ArrayList<String>();
            for (String levelName : oldLevels) {
                if (!levelName.contains(this.dimension.m_94155_()) && !this.dimension.m_94155_().equals("")) continue;
                levels.add(levelName);
            }
            this.selected_dim_index -= (int)pScrollX;
            if (this.selected_dim_index > levels.size()) {
                this.selected_dim_index = levels.size();
            } else if (this.selected_dim_index < 0) {
                this.selected_dim_index = 0;
            } else {
                this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.5f, 2.0f);
            }
            if (this.selected_dim_index == 0) {
                this.dimension.m_94144_("");
            }
        }
        if (this.name.m_274382_()) {
            Set<String> coordKeys = ((KeypadMenu)this.f_97732_).blockEntity.coordData.keySet();
            ArrayList<CallSite> locationStrings = new ArrayList<CallSite>();
            String playerName = this.f_96541_.f_91074_.m_6302_();
            for (String coordKey : coordKeys) {
                String pointDimension;
                BlockPos pointPos;
                String pointCoords;
                String pointName;
                String locString;
                if (!coordKey.startsWith(playerName) || !(locString = (pointName = coordKey.substring(playerName.length()) + ": ") + (pointCoords = (pointPos = ((KeypadMenu)this.f_97732_).blockEntity.coordData.get(coordKey)).m_123341_() + " " + pointPos.m_123342_() + " " + pointPos.m_123343_() + " | ") + (pointDimension = ((KeypadMenu)this.f_97732_).blockEntity.dimData.get(coordKey))).contains(this.name.m_94155_()) && !this.name.m_94155_().equals("")) continue;
                locationStrings.add((CallSite)((Object)locString));
            }
            this.selected_location_index -= (int)pScrollX;
            if (this.selected_location_index > locationStrings.size()) {
                this.selected_location_index = locationStrings.size();
            } else if (this.selected_location_index < 0) {
                this.selected_location_index = 0;
            } else {
                this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.5f, 2.0f);
            }
            if (this.selected_location_index == 0) {
                this.name.m_94144_("");
            }
        }
        return super.m_6050_(pMouseX, pMouseY, pScrollX);
    }

    String centerTooltipText(String text, int maxWidth) {
        int diff = maxWidth - text.length();
        int spaces = diff / 2;
        if (maxWidth > 24) {
            spaces = text.length() <= 24 ? diff - (24 - text.length()) / 2 : diff - (maxWidth - text.length()) / 2;
        }
        if (maxWidth % 2 != text.length() % 2 && diff % 2 == 0 || text.length() % 2 != 0) {
            ++spaces;
        }
        return " ".repeat(spaces) + text;
    }

    public void onSave() {
        if (!this.targetScreen.booleanValue()) {
            PacketHandler.sendToServer(new ServerboundSaveTargetPacket(((KeypadMenu)this.f_97732_).blockEntity.m_58899_(), this.name.m_94155_(), true, this.targetScreen));
        }
    }

    public void onLoad() {
        if (!this.targetScreen.booleanValue()) {
            PacketHandler.sendToServer(new ServerboundSaveTargetPacket(((KeypadMenu)this.f_97732_).blockEntity.m_58899_(), this.name.m_94155_(), false, this.targetScreen));
        }
    }

    public void onDelete() {
        if (!this.targetScreen.booleanValue()) {
            PacketHandler.sendToServer(new ServerboundDeleteTargetPacket(((KeypadMenu)this.f_97732_).blockEntity.m_58899_(), this.name.m_94155_(), this.targetScreen));
        }
    }

    public void onDone() {
        if (this.targetScreen.booleanValue()) {
            String to_dimension;
            int x_int = 999999999;
            int y_int = 999999999;
            int z_int = 999999999;
            String x_string = this.x.m_94155_();
            String y_string = this.y.m_94155_();
            String z_string = this.z.m_94155_();
            if (x_string.matches("^-?\\d+$")) {
                x_int = Integer.parseInt(x_string);
            }
            if (y_string.matches("^-?\\d+$")) {
                y_int = Integer.parseInt(y_string);
            }
            if (z_string.matches("^-?\\d+$")) {
                z_int = Integer.parseInt(z_string);
            }
            BlockPos from_pos = ((KeypadMenu)this.f_97732_).blockEntity.m_58899_();
            String from_dimension = ((KeypadMenu)this.f_97732_).blockEntity.m_58904_().m_46472_().m_135782_().m_135815_();
            BlockPos to_pos = new BlockPos(x_int, y_int, z_int);
            int to_rotation = 999999999;
            String rot_String = this.rotation.m_94155_();
            if (rot_String.matches("^-?\\d+$")) {
                to_rotation = Integer.parseInt(rot_String);
            }
            if ((to_dimension = this.dimension.m_94155_()).equals("tardisdim")) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237113_((String)"You cannot set the dimension to the TARDIS dimension.").m_130940_(ChatFormatting.RED), false);
            } else {
                PacketHandler.sendToServer(new ServerboundTargetPacket(from_pos, from_dimension, to_pos, to_rotation, to_dimension, this.targetScreen));
            }
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        return !this.x.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.x.m_94204_() && !this.y.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.y.m_94204_() && !this.z.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.z.m_94204_() && !this.rotation.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.rotation.m_94204_() && !this.dimension.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.dimension.m_94204_() && !this.name.m_7933_(pKeyCode, pScanCode, pModifiers) && !this.name.m_94204_() ? super.m_7933_(pKeyCode, pScanCode, pModifiers) : true;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.targetScreen.booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_SECONDARY);
            int x = (this.f_96543_ - this.f_97726_) / 2;
            int y = (this.f_96544_ - this.f_97727_) / 2;
            guiGraphics.m_280218_(TEXTURE_SECONDARY, x, y, 0, 0, this.f_97726_, this.f_97727_);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doWidgetLogic() {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (this.targetScreen.booleanValue()) {
            void var6_18;
            this.x.f_93623_ = true;
            this.x.f_93624_ = true;
            if (this.x.m_94155_().length() > 0) {
                int xWidth = this.f_96547_.m_92895_(this.x.m_94155_().substring(0, Math.min(6, this.x.m_94155_().length() - 1)));
                this.x.m_252865_(i + 58 - xWidth / 2);
                this.x.m_93674_(Math.min(46, this.f_96547_.m_92895_(this.x.m_94155_()) + 8));
            } else if (this.x.m_94204_()) {
                this.x.m_252865_(i + 58);
                this.x.m_93674_(8);
            } else {
                this.x.m_252865_(i + 38);
                this.x.m_93674_(46);
            }
            this.y.f_93623_ = true;
            this.y.f_93624_ = true;
            if (this.y.m_94155_().length() > 0) {
                int yWidth = this.f_96547_.m_92895_(this.y.m_94155_().substring(0, Math.min(6, this.y.m_94155_().length() - 1)));
                this.y.m_252865_(i + 113 - yWidth / 2);
                this.y.m_93674_(Math.min(46, this.f_96547_.m_92895_(this.y.m_94155_()) + 8));
            } else if (this.y.m_94204_()) {
                this.y.m_252865_(i + 113);
                this.y.m_93674_(8);
            } else {
                this.y.m_252865_(i + 92);
                this.y.m_93674_(46);
            }
            this.z.f_93623_ = true;
            this.z.f_93624_ = true;
            if (this.z.m_94155_().length() > 0) {
                int zWidth = this.f_96547_.m_92895_(this.z.m_94155_().substring(0, Math.min(6, this.z.m_94155_().length() - 1)));
                this.z.m_252865_(i + 113 - zWidth / 2);
                this.z.m_93674_(Math.min(46, this.f_96547_.m_92895_(this.z.m_94155_()) + 8));
            } else if (this.z.m_94204_()) {
                this.z.m_252865_(i + 113);
                this.z.m_93674_(8);
            } else {
                this.z.m_252865_(i + 92);
                this.z.m_93674_(46);
            }
            this.rotation.f_93623_ = true;
            this.rotation.f_93624_ = true;
            if (this.rotation.m_94155_().length() > 0) {
                int rotWidth = this.f_96547_.m_92895_(this.rotation.m_94155_());
                this.rotation.m_252865_(i + 61 - rotWidth / 2);
                this.rotation.m_93674_(Math.min(46, this.f_96547_.m_92895_(this.rotation.m_94155_()) + 8));
            } else if (this.rotation.m_94204_()) {
                this.rotation.m_252865_(i + 61);
                this.rotation.m_93674_(8);
            } else {
                this.rotation.m_252865_(i + 39);
                this.rotation.m_93674_(45);
            }
            this.dimension.f_93623_ = true;
            this.dimension.f_93624_ = true;
            if (this.dimension.m_94155_().length() > 0) {
                int dimWidth = this.f_96547_.m_92895_(this.dimension.m_94155_().substring(0, Math.min(15, this.dimension.m_94155_().length() - 1)));
                this.dimension.m_252865_(i + 83 - dimWidth / 2);
                this.dimension.m_93674_(Math.min(94, this.f_96547_.m_92895_(this.dimension.m_94155_()) + 8));
            } else if (this.dimension.m_94204_()) {
                this.dimension.m_252865_(i + 83);
                this.dimension.m_93674_(8);
            } else {
                this.dimension.m_252865_(i + 38);
                this.dimension.m_93674_(94);
            }
            ArrayList<String> oldLevels = new ArrayList<String>(((KeypadMenu)this.f_97732_).blockEntity.serverLevels);
            ArrayList<String> levels = new ArrayList<String>();
            for (String string : oldLevels) {
                if (!string.contains(this.dimension.m_94155_()) && !this.dimension.m_94155_().equals("")) continue;
                levels.add(string);
            }
            int maxWidth = 24;
            for (String string : levels) {
                if (string.length() <= maxWidth) continue;
                maxWidth = string.length();
            }
            MutableComponent mutableComponent = Component.m_237113_((String)(this.centerTooltipText(" *Type to Filter*", maxWidth) + "\n")).m_130940_(ChatFormatting.GRAY);
            String string = this.centerTooltipText("No Change", maxWidth);
            if (0 >= this.selected_dim_index - 2 && 0 <= this.selected_dim_index + 2) {
                if (0 == this.selected_dim_index) {
                    MutableComponent mutableComponent2 = mutableComponent.m_6881_().m_7220_((Component)Component.m_237113_((String)(string + "\n")).m_130940_(ChatFormatting.AQUA));
                } else {
                    MutableComponent mutableComponent3 = mutableComponent.m_6881_().m_7220_((Component)Component.m_237113_((String)(string + "\n")).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            boolean bl = true;
            for (String string2 : levels) {
                void var8_31;
                if (var8_31 >= this.selected_dim_index - 2 && var8_31 <= this.selected_dim_index + 2 || this.selected_dim_index > levels.size() - 3 && var8_31 > this.selected_dim_index - (5 - (levels.size() - this.selected_dim_index)) || this.selected_dim_index < 3 && var8_31 < this.selected_dim_index + (5 - this.selected_dim_index)) {
                    String centeredPath = this.centerTooltipText(string2, maxWidth);
                    if (var8_31 == this.selected_dim_index) {
                        MutableComponent mutableComponent4 = var6_18.m_6881_().m_7220_((Component)Component.m_237113_((String)(centeredPath + "\n")).m_130940_(ChatFormatting.AQUA));
                    } else {
                        MutableComponent mutableComponent5 = var6_18.m_6881_().m_7220_((Component)Component.m_237113_((String)(centeredPath + "\n")).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                }
                ++var8_31;
            }
            MutableComponent mutableComponent6 = var6_18.m_6881_().m_7220_((Component)Component.m_237113_((String)this.centerTooltipText("*Scroll+R-Click to Pick*", maxWidth)).m_130940_(ChatFormatting.GRAY));
            this.dimension.m_257544_(Tooltip.m_257550_((Component)mutableComponent6));
            this.done_button.f_93623_ = true;
            this.done_button.f_93624_ = true;
            this.cancel_button.f_93623_ = true;
            this.cancel_button.f_93624_ = true;
            this.name.f_93623_ = false;
            this.name.f_93624_ = false;
            this.save_button.f_93623_ = false;
            this.save_button.f_93624_ = false;
            this.load_button.f_93623_ = false;
            this.load_button.f_93624_ = false;
            this.delete_button.f_93623_ = false;
            this.delete_button.f_93624_ = false;
        } else {
            void var8_39;
            int n;
            this.x.f_93623_ = false;
            this.x.f_93624_ = false;
            this.y.f_93623_ = false;
            this.y.f_93624_ = false;
            this.z.f_93623_ = false;
            this.z.f_93624_ = false;
            this.dimension.f_93623_ = false;
            this.dimension.f_93624_ = false;
            this.rotation.f_93623_ = false;
            this.rotation.f_93624_ = false;
            this.done_button.f_93623_ = false;
            this.done_button.f_93624_ = false;
            this.cancel_button.f_93623_ = false;
            this.cancel_button.f_93624_ = false;
            this.name.f_93623_ = true;
            this.name.f_93624_ = true;
            if (this.name.m_94155_().length() > 0) {
                int nameWidth = this.f_96547_.m_92895_(this.name.m_94155_().substring(0, Math.min(15, this.name.m_94155_().length() - 1)));
                this.name.m_252865_(i + 87 - nameWidth / 2);
                this.name.m_93674_(Math.min(85, this.f_96547_.m_92895_(this.name.m_94155_()) + 8));
            } else if (this.name.m_94204_()) {
                this.name.m_252865_(i + 87);
                this.name.m_93674_(8);
            } else {
                this.name.m_252865_(i + 45);
                this.name.m_93674_(85);
            }
            Set<String> coordKeys = ((KeypadMenu)this.f_97732_).blockEntity.coordData.keySet();
            ArrayList<CallSite> locationStrings = new ArrayList<CallSite>();
            String playerName = this.f_96541_.f_91074_.m_6302_();
            for (String string : coordKeys) {
                Object pointDimension;
                BlockPos pointPos;
                String string3;
                String string4;
                String string5;
                if (!string.startsWith(playerName) || !(string5 = (string4 = string.substring(playerName.length()) + ": ") + (string3 = (pointPos = ((KeypadMenu)this.f_97732_).blockEntity.coordData.get(string)).m_123341_() + " " + pointPos.m_123342_() + " " + pointPos.m_123343_() + " | ") + (String)(pointDimension = ((KeypadMenu)this.f_97732_).blockEntity.dimData.get(string))).contains(this.name.m_94155_()) && !this.name.m_94155_().equals("")) continue;
                locationStrings.add((CallSite)((Object)string5));
            }
            int n2 = 24;
            for (String string : locationStrings) {
                if (string.length() <= n) continue;
                n = string.length();
            }
            String string = this.centerTooltipText("*Type to Filter*", n);
            MutableComponent mutableComponent = Component.m_237113_((String)(string + "\n")).m_130940_(ChatFormatting.GRAY);
            String changeString = this.centerTooltipText("None", n);
            if (0 >= this.selected_location_index - 2 && 0 <= this.selected_location_index + 2) {
                if (0 == this.selected_location_index) {
                    MutableComponent mutableComponent7 = mutableComponent.m_6881_().m_7220_((Component)Component.m_237113_((String)(changeString + "\n")).m_130940_(ChatFormatting.AQUA));
                } else {
                    MutableComponent mutableComponent8 = mutableComponent.m_6881_().m_7220_((Component)Component.m_237113_((String)(changeString + "\n")).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            boolean bl = true;
            for (String string6 : locationStrings) {
                void var10_48;
                if (var10_48 >= this.selected_location_index - 2 && var10_48 <= this.selected_location_index + 2 || this.selected_location_index > locationStrings.size() - 3 && var10_48 > this.selected_location_index - (5 - (locationStrings.size() - this.selected_location_index)) || this.selected_location_index < 3 && var10_48 < this.selected_location_index + (5 - this.selected_location_index)) {
                    String centeredPath = this.centerTooltipText(string6, n);
                    if (var10_48 == this.selected_location_index) {
                        MutableComponent mutableComponent9 = var8_39.m_6881_().m_7220_((Component)Component.m_237113_((String)(centeredPath + "\n")).m_130940_(ChatFormatting.AQUA));
                    } else {
                        MutableComponent mutableComponent10 = var8_39.m_6881_().m_7220_((Component)Component.m_237113_((String)(centeredPath + "\n")).m_130940_(ChatFormatting.DARK_GRAY));
                    }
                }
                ++var10_48;
            }
            String centeredTutorialText = this.centerTooltipText("*Scroll+R-Click to Pick*", n);
            MutableComponent mutableComponent11 = var8_39.m_6881_().m_7220_((Component)Component.m_237113_((String)centeredTutorialText).m_130940_(ChatFormatting.GRAY));
            this.name.m_257544_(Tooltip.m_257550_((Component)mutableComponent11));
            this.save_button.f_93623_ = true;
            this.save_button.f_93624_ = true;
            this.load_button.f_93623_ = true;
            this.load_button.f_93624_ = true;
            this.delete_button.f_93623_ = true;
            this.delete_button.f_93624_ = true;
        }
        this.toggle_button.m_93692_(false);
        this.save_button.m_93692_(false);
        this.load_button.m_93692_(false);
        this.delete_button.m_93692_(false);
        this.cancel_button.m_93692_(false);
        this.done_button.m_93692_(false);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.doWidgetLogic();
        if (this.targetScreen.booleanValue()) {
            this.x.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.y.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.z.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.rotation.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.dimension.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.done_button.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.cancel_button.m_88315_(guiGraphics, mouseX, mouseY, delta);
            guiGraphics.m_280137_(this.f_96547_, "X", i + 61, j + 6, ChatFormatting.GRAY.m_126665_().intValue());
            guiGraphics.m_280137_(this.f_96547_, "Y", i + 115, j + 6, ChatFormatting.GRAY.m_126665_().intValue());
            guiGraphics.m_280137_(this.f_96547_, "Z", i + 115, j + 33, ChatFormatting.GRAY.m_126665_().intValue());
            guiGraphics.m_280137_(this.f_96547_, "Rotation", i + 62, j + 33, ChatFormatting.GRAY.m_126665_().intValue());
            guiGraphics.m_280137_(this.f_96547_, "Dimension", i + 88, j + 60, ChatFormatting.GRAY.m_126665_().intValue());
        } else {
            this.name.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.save_button.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.load_button.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.delete_button.m_88315_(guiGraphics, mouseX, mouseY, delta);
            guiGraphics.m_280137_(this.f_96547_, "Locations", i + 88, j + 42, ChatFormatting.GRAY.m_126665_().intValue());
        }
        this.toggle_button.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String x_s = this.x.m_94155_();
        String y_s = this.y.m_94155_();
        String z_s = this.z.m_94155_();
        String rot_s = this.rotation.m_94155_();
        String dim_s = this.dimension.m_94155_();
        String name_s = this.name.m_94155_();
        this.m_6575_(pMinecraft, pWidth, pHeight);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.x.m_94144_(x_s);
        this.y.m_94144_(y_s);
        this.z.m_94144_(z_s);
        this.rotation.m_94144_(rot_s);
        this.dimension.m_94144_(dim_s);
        this.name.m_94144_(name_s);
        this.done_button.m_252865_(i + 46);
        this.done_button.m_253211_(j + 90);
        this.cancel_button.m_252865_(i + 92);
        this.cancel_button.m_253211_(j + 90);
        this.toggle_button.m_252865_(i + 141);
        this.toggle_button.m_253211_(j + 90);
        this.save_button.m_252865_(i + 8);
        this.save_button.m_253211_(j + 90);
        this.load_button.m_252865_(i + 52);
        this.load_button.m_253211_(j + 90);
        this.delete_button.m_252865_(i + 96);
        this.delete_button.m_253211_(j + 90);
    }
}

