/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.network;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.sound.ModSounds;

public class ServerboundTargetPacket {
    private final BlockPos from_pos;
    private final String from_dimension;
    private final BlockPos to_pos;
    private final int to_rotation;
    private final String to_dimension;
    private final Boolean targetScreen;

    public ServerboundTargetPacket(BlockPos from_pos, String from_dimension, BlockPos to_pos, int to_rotation, String to_dimension, Boolean targetScreen) {
        this.from_pos = from_pos;
        this.from_dimension = from_dimension;
        this.to_pos = to_pos;
        this.to_dimension = to_dimension;
        this.to_rotation = to_rotation;
        this.targetScreen = targetScreen;
    }

    public ServerboundTargetPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.m_130277_(), buffer.m_130135_(), buffer.readInt(), buffer.m_130277_(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.from_pos);
        buffer.m_130070_(this.from_dimension);
        buffer.m_130064_(this.to_pos);
        buffer.writeInt(this.to_rotation);
        buffer.m_130070_(this.to_dimension);
        buffer.writeBoolean(this.targetScreen.booleanValue());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context realContext = context.get();
        if (this.targetScreen.booleanValue()) {
            MinecraftServer minecraftServer = realContext.getSender().m_20194_();
            ServerLevel level = null;
            ServerLevel toLevel = null;
            for (ServerLevel cLevel : minecraftServer.m_129785_()) {
                if (cLevel.m_46472_().m_135782_().m_135815_().equals(this.from_dimension)) {
                    level = cLevel;
                }
                if (!cLevel.m_46472_().m_135782_().m_135815_().equals(this.to_dimension)) continue;
                toLevel = cLevel;
            }
            boolean core_found = false;
            BlockPos corePos = this.from_pos;
            VortexInterfaceBlockEntity vortexInterfaceBlockEntity = null;
            for (int _x = -16; _x <= 16 && !core_found; ++_x) {
                for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                    for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                        BlockPos currentPos = this.from_pos.m_7918_(_x, _y, _z);
                        BlockState blockState = level.m_8055_(currentPos);
                        if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                        vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)level.m_7702_(currentPos);
                        core_found = true;
                        corePos = currentPos;
                    }
                }
            }
            boolean has_components = false;
            boolean has_keypad = false;
            boolean has_designator = false;
            CoordinateDesignatorBlockEntity designatorEntity = null;
            for (int _x = -16; _x <= 16 && !has_components; ++_x) {
                for (int _y = -16; _y <= 16 && !has_components; ++_y) {
                    for (int _z = -16; _z <= 16 && !has_components; ++_z) {
                        BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                        BlockState blockState = level.m_8055_(currentPos);
                        if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                            has_keypad = true;
                        } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                            designatorEntity = (CoordinateDesignatorBlockEntity)level.m_7702_(currentPos);
                            has_designator = true;
                        }
                        if (!has_keypad || !has_designator) continue;
                        has_components = true;
                    }
                }
            }
            int x = this.to_pos.m_123341_();
            int y = this.to_pos.m_123342_();
            int z = this.to_pos.m_123343_();
            if (core_found && has_components && designatorEntity != null) {
                level.m_214150_(null, (double)this.from_pos.m_123341_(), (double)this.from_pos.m_123342_(), (double)this.from_pos.m_123343_(), (SoundEvent)ModSounds.COORDINATE_KEYPAD_SET_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                if (x != -6632961) {
                    designatorEntity.data.m_8050_(0, x);
                } else {
                    x = designatorEntity.data.m_6413_(0);
                }
                if (y != -1537) {
                    designatorEntity.data.m_8050_(1, y);
                } else {
                    y = designatorEntity.data.m_6413_(1);
                }
                if (z != -6632961) {
                    designatorEntity.data.m_8050_(2, z);
                } else {
                    z = designatorEntity.data.m_6413_(2);
                }
                int toRotation = vortexInterfaceBlockEntity.data.m_6413_(12);
                if (this.to_rotation < 360 && this.to_rotation > -360) {
                    toRotation = this.to_rotation;
                    vortexInterfaceBlockEntity.data.m_8050_(12, this.to_rotation);
                }
                String toDimension = toLevel != null ? toLevel.m_46472_().m_135782_().m_135815_() : vortexInterfaceBlockEntity.getTargetDimensionJ();
                vortexInterfaceBlockEntity.data.m_8050_(10, toDimension.hashCode());
                realContext.getSender().m_5661_((Component)Component.m_237113_((String)"Updating target coordinates to: ").m_7220_((Component)Component.m_237113_((String)(x + " " + y + " " + z + "\n")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Updating target rotation to: ")).m_7220_((Component)Component.m_237113_((String)(toRotation + "\n")).m_130940_(ChatFormatting.GOLD)).m_7220_((Component)Component.m_237113_((String)"Updating target dimension to: ")).m_7220_((Component)Component.m_237113_((String)toDimension).m_130940_(ChatFormatting.GOLD)), false);
            } else {
                if (!core_found) {
                    realContext.getSender().m_5661_((Component)Component.m_237113_((String)"Core is not in range.").m_130940_(ChatFormatting.RED), false);
                }
                if (!has_components) {
                    realContext.getSender().m_5661_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)").m_130940_(ChatFormatting.RED), false);
                }
            }
        }
        realContext.setPacketHandled(true);
    }
}

