/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.network;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.mapdata.DimensionMapData;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.network.ClientboundTargetMapPacket;
import net.plaaasma.vortexmod.network.PacketHandler;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;

public class ServerboundDeleteTargetPacket {
    private final BlockPos from_pos;
    private final String save_name;
    private final Boolean targetScreen;

    public ServerboundDeleteTargetPacket(BlockPos from_pos, String save_pos, Boolean targetScreen) {
        this.from_pos = from_pos;
        this.save_name = save_pos;
        this.targetScreen = targetScreen;
    }

    public ServerboundDeleteTargetPacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.m_130277_(), buffer.readBoolean());
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.from_pos);
        buffer.m_130070_(this.save_name);
        buffer.writeBoolean(this.targetScreen.booleanValue());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context realContext = context.get();
        if (!this.targetScreen.booleanValue()) {
            MinecraftServer minecraftserver = realContext.getSender().m_20194_();
            ServerLevel tardis_dim = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
            ServerLevel vortex = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
            ServerPlayer player = realContext.getSender();
            LocationMapData coord_data = LocationMapData.get(vortex);
            DimensionMapData dim_data = DimensionMapData.get(tardis_dim);
            ServerLevel level = realContext.getSender().m_284548_();
            boolean core_found = false;
            BlockPos corePos = this.from_pos;
            VortexInterfaceBlockEntity vortexInterfaceBlockEntity = null;
            for (int _x = -16; _x <= 16 && !core_found; ++_x) {
                for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                    for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                        BlockPos currentPos = this.from_pos.m_7918_(_x, _y, _z);
                        BlockState blockState = level.m_8055_(currentPos);
                        if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                        vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)level.m_7702_(currentPos);
                        core_found = true;
                        corePos = currentPos;
                    }
                }
            }
            boolean has_components = false;
            boolean has_keypad = false;
            boolean has_designator = false;
            CoordinateDesignatorBlockEntity designatorEntity = null;
            for (int _x = -16; _x <= 16 && !has_components; ++_x) {
                for (int _y = -16; _y <= 16 && !has_components; ++_y) {
                    for (int _z = -16; _z <= 16 && !has_components; ++_z) {
                        BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                        BlockState blockState = level.m_8055_(currentPos);
                        if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                            has_keypad = true;
                        } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                            designatorEntity = (CoordinateDesignatorBlockEntity)level.m_7702_(currentPos);
                            has_designator = true;
                        }
                        if (!has_keypad || !has_designator) continue;
                        has_components = true;
                    }
                }
            }
            if (core_found && has_components && designatorEntity != null) {
                String dataKey = player.m_6302_() + this.save_name;
                if (coord_data.getDataMap().containsKey(dataKey)) {
                    BlockPos savedPos = coord_data.getDataMap().get(dataKey);
                    String savedDimName = dim_data.getDataMap().get(dataKey);
                    coord_data.getDataMap().remove(dataKey);
                    dim_data.getDataMap().remove(dataKey);
                    realContext.getSender().m_5661_((Component)Component.m_237113_((String)("Deleting " + this.save_name + ". (" + savedPos.m_123341_() + " " + savedPos.m_123342_() + " " + savedPos.m_123343_() + " | " + savedDimName + ")")), false);
                    coord_data.m_77762_();
                    dim_data.m_77762_();
                    PacketHandler.sendToAllClients(new ClientboundTargetMapPacket(level.m_46472_().m_135782_().m_135815_(), this.from_pos, coord_data.getDataMap(), dim_data.getDataMap()));
                } else {
                    realContext.getSender().m_5661_((Component)Component.m_237113_((String)("You do not have a saved destination called " + this.save_name + ", you can list your destinations with /tardis list")), false);
                }
            } else {
                if (!core_found) {
                    realContext.getSender().m_5661_((Component)Component.m_237113_((String)"Core is not in range.").m_130940_(ChatFormatting.RED), false);
                }
                if (!has_components) {
                    realContext.getSender().m_5661_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)").m_130940_(ChatFormatting.RED), false);
                }
            }
        }
        realContext.setPacketHandled(true);
    }
}

