/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.plaaasma.vortexmod.network.ClientboundDimListPacket;
import net.plaaasma.vortexmod.network.ClientboundMonitorDataPacket;
import net.plaaasma.vortexmod.network.ClientboundTargetMapPacket;
import net.plaaasma.vortexmod.network.ServerboundDeleteTargetPacket;
import net.plaaasma.vortexmod.network.ServerboundSaveTargetPacket;
import net.plaaasma.vortexmod.network.ServerboundTargetPacket;

public class PacketHandler {
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("vortexmod", "main")).networkProtocolVersion(() -> "FML3").clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).simpleChannel();

    public static void register() {
        INSTANCE.messageBuilder(ServerboundTargetPacket.class, 0).encoder(ServerboundTargetPacket::encode).decoder(ServerboundTargetPacket::new).consumerMainThread(ServerboundTargetPacket::handle).add();
        INSTANCE.messageBuilder(ServerboundSaveTargetPacket.class, 1).encoder(ServerboundSaveTargetPacket::encode).decoder(ServerboundSaveTargetPacket::new).consumerMainThread(ServerboundSaveTargetPacket::handle).add();
        INSTANCE.messageBuilder(ServerboundDeleteTargetPacket.class, 2).encoder(ServerboundDeleteTargetPacket::encode).decoder(ServerboundDeleteTargetPacket::new).consumerMainThread(ServerboundDeleteTargetPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundTargetMapPacket.class, 3).encoder(ClientboundTargetMapPacket::encode).decoder(ClientboundTargetMapPacket::new).consumerMainThread(ClientboundTargetMapPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundDimListPacket.class, 4).encoder(ClientboundDimListPacket::encode).decoder(ClientboundDimListPacket::new).consumerMainThread(ClientboundDimListPacket::handle).add();
        INSTANCE.messageBuilder(ClientboundMonitorDataPacket.class, 5).encoder(ClientboundMonitorDataPacket::encode).decoder(ClientboundMonitorDataPacket::new).consumerMainThread(ClientboundMonitorDataPacket::handle).add();
    }

    public static void sendToServer(Object msg) {
        INSTANCE.send(PacketDistributor.SERVER.noArg(), msg);
    }

    public static void sendToPlayer(Object msg, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static void sendToAllClients(Object msg) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), msg);
    }
}

