/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SizeDesignator
extends Item {
    public BlockPos alpha_pos = null;
    public BlockPos beta_pos = null;

    public SizeDesignator(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        if (level.m_5776_()) {
            if (player.m_6047_()) {
                if (this.alpha_pos != null && this.beta_pos != null) {
                    SizeDesignator.spawnSizeCuboid(level, this.alpha_pos, this.beta_pos);
                } else {
                    player.m_5661_((Component)Component.m_237113_((String)"You have not set both corners, cannot do visualization"), true);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.CONSUME;
        }
        if (!player.m_6047_()) {
            BlockPos clickedPos = pContext.m_8083_();
            if (this.alpha_pos == null) {
                this.alpha_pos = clickedPos;
                player.m_5661_((Component)Component.m_237113_((String)("Set first position to " + clickedPos.m_123344_())).m_130940_(ChatFormatting.GOLD), true);
            } else if (this.beta_pos == null) {
                this.beta_pos = clickedPos;
                player.m_5661_((Component)Component.m_237113_((String)("Set second position to " + clickedPos.m_123344_())).m_130940_(ChatFormatting.GOLD), true);
            } else {
                this.beta_pos = null;
                this.alpha_pos = null;
                player.m_5661_((Component)Component.m_237113_((String)"Reset positions").m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.m_6047_()) {
            if (!pLevel.m_5776_()) {
                return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
            }
            if (this.alpha_pos != null && this.beta_pos != null) {
                SizeDesignator.spawnSizeCuboid(pLevel, this.alpha_pos, this.beta_pos);
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"You have not set both corners, cannot do visualization"), true);
            }
            return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public static void spawnSizeCuboid(Level pLevel, BlockPos corner1, BlockPos corner2) {
        int xLength = Math.abs(corner1.m_123341_() - corner2.m_123341_());
        int yLength = Math.abs(corner1.m_123342_() - corner2.m_123342_());
        int zLength = Math.abs(corner1.m_123343_() - corner2.m_123343_());
        BlockPos minCorner = new BlockPos(Math.min(corner1.m_123341_(), corner2.m_123341_()), Math.min(corner1.m_123342_(), corner2.m_123342_()), Math.min(corner1.m_123343_(), corner2.m_123343_()));
        SimpleParticleType particle = ParticleTypes.f_123797_;
        for (int x = 0; x <= xLength + 1; ++x) {
            for (int y = 0; y <= yLength + 1; ++y) {
                for (int z = 0; z <= zLength + 1; ++z) {
                    if (x != 0 && x != xLength + 1 && y != 0 && y != yLength + 1 && z != 0 && z != zLength + 1) continue;
                    pLevel.m_7106_((ParticleOptions)particle, (double)(minCorner.m_123341_() + x), (double)(minCorner.m_123342_() + y), (double)(minCorner.m_123343_() + z), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.vortexmod.size_designator.tooltip"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

