/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.entities.custom;

import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.item.ModItems;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.mapdata.SecurityMapData;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;
import net.plaaasma.vortexmod.worldgen.portal.ModTeleporter;

public class TardisEntity
extends Mob {
    private static final EntityDataAccessor<Integer> DATA_OWNERID_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_LOCKED_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_BIO_SECURITY_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IN_FLIGHT_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_DEMAT_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_REMAT_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ANIM_STAGE_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ANIM_DESCENDING_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_ALPHA_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> DATA_LEVEL_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> DATA_TARGET_X_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_TARGET_Y_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_TARGET_Z_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ROTATION_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_SIGN_ID = SynchedEntityData.m_135353_(TardisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public TardisEntity(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Owner", ((Integer)this.f_19804_.m_135370_(DATA_OWNERID_ID)).intValue());
        pCompound.m_128379_("Locked", ((Boolean)this.f_19804_.m_135370_(DATA_LOCKED_ID)).booleanValue());
        pCompound.m_128379_("HasBio", ((Boolean)this.f_19804_.m_135370_(DATA_HAS_BIO_SECURITY_ID)).booleanValue());
        pCompound.m_128379_("InFlight", ((Boolean)this.f_19804_.m_135370_(DATA_IN_FLIGHT_ID)).booleanValue());
        pCompound.m_128379_("Demat", ((Boolean)this.f_19804_.m_135370_(DATA_DEMAT_ID)).booleanValue());
        pCompound.m_128379_("Remat", ((Boolean)this.f_19804_.m_135370_(DATA_REMAT_ID)).booleanValue());
        pCompound.m_128405_("AnimStage", ((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID)).intValue());
        pCompound.m_128379_("AnimDescending", ((Boolean)this.f_19804_.m_135370_(DATA_ANIM_DESCENDING_ID)).booleanValue());
        pCompound.m_128350_("Alpha", ((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue());
        pCompound.m_128359_("Level", (String)this.f_19804_.m_135370_(DATA_LEVEL_ID));
        pCompound.m_128350_("X", ((Float)this.f_19804_.m_135370_(DATA_TARGET_X_ID)).floatValue());
        pCompound.m_128350_("Y", ((Float)this.f_19804_.m_135370_(DATA_TARGET_Y_ID)).floatValue());
        pCompound.m_128350_("Z", ((Float)this.f_19804_.m_135370_(DATA_TARGET_Z_ID)).floatValue());
        pCompound.m_128405_("Rotation", ((Integer)this.f_19804_.m_135370_(DATA_ROTATION_ID)).intValue());
        pCompound.m_128359_("Sign", (String)this.f_19804_.m_135370_(DATA_SIGN_ID));
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(DATA_OWNERID_ID, (Object)pCompound.m_128451_("Owner"));
        this.f_19804_.m_135381_(DATA_LOCKED_ID, (Object)pCompound.m_128471_("Locked"));
        this.f_19804_.m_135381_(DATA_HAS_BIO_SECURITY_ID, (Object)pCompound.m_128471_("HasBio"));
        this.f_19804_.m_135381_(DATA_IN_FLIGHT_ID, (Object)pCompound.m_128471_("InFlight"));
        this.f_19804_.m_135381_(DATA_DEMAT_ID, (Object)pCompound.m_128471_("Demat"));
        this.f_19804_.m_135381_(DATA_REMAT_ID, (Object)pCompound.m_128471_("Remat"));
        this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)pCompound.m_128451_("AnimStage"));
        this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)pCompound.m_128471_("AnimDescending"));
        this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(pCompound.m_128457_("Alpha")));
        this.f_19804_.m_135381_(DATA_LEVEL_ID, (Object)pCompound.m_128461_("Level"));
        this.f_19804_.m_135381_(DATA_TARGET_X_ID, (Object)Float.valueOf(pCompound.m_128457_("X")));
        this.f_19804_.m_135381_(DATA_TARGET_Y_ID, (Object)Float.valueOf(pCompound.m_128457_("Y")));
        this.f_19804_.m_135381_(DATA_TARGET_Z_ID, (Object)Float.valueOf(pCompound.m_128457_("Z")));
        this.f_19804_.m_135381_(DATA_ROTATION_ID, (Object)pCompound.m_128451_("Rotation"));
        this.m_146922_(pCompound.m_128451_("Rotation"));
        if (pCompound.m_128461_("Sign").length() > 0) {
            this.f_19804_.m_135381_(DATA_SIGN_ID, (Object)pCompound.m_128461_("Sign"));
        } else {
            this.f_19804_.m_135381_(DATA_SIGN_ID, (Object)"Police -=- Box");
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNERID_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_LOCKED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_HAS_BIO_SECURITY_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_IN_FLIGHT_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_DEMAT_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_REMAT_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_ANIM_STAGE_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_ANIM_DESCENDING_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_ALPHA_ID, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_LEVEL_ID, (Object)"fartland");
        this.f_19804_.m_135372_(DATA_TARGET_X_ID, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_TARGET_Y_ID, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_TARGET_Z_ID, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ROTATION_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_SIGN_ID, (Object)"Police -=- Box");
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.147483647E9).m_22268_(Attributes.f_22285_, 2.147483647E9).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22278_, 2.147483647E9);
    }

    public void setOwnerID(int ownerID) {
        this.f_19804_.m_135381_(DATA_OWNERID_ID, (Object)ownerID);
    }

    public void setLocked(boolean locked) {
        this.f_19804_.m_135381_(DATA_LOCKED_ID, (Object)locked);
    }

    public void setHasBioSecurity(boolean has_bio_security) {
        this.f_19804_.m_135381_(DATA_HAS_BIO_SECURITY_ID, (Object)has_bio_security);
    }

    public void setInFlight(boolean in_flight) {
        this.f_19804_.m_135381_(DATA_IN_FLIGHT_ID, (Object)in_flight);
    }

    public void setDemat(boolean demat) {
        this.f_19804_.m_135381_(DATA_DEMAT_ID, (Object)demat);
        if (((Boolean)this.f_19804_.m_135370_(DATA_DEMAT_ID)).booleanValue()) {
            this.f_19804_.m_135381_(DATA_REMAT_ID, (Object)false);
        }
    }

    public void setRemat(boolean remat) {
        this.f_19804_.m_135381_(DATA_REMAT_ID, (Object)remat);
        if (((Boolean)this.f_19804_.m_135370_(DATA_REMAT_ID)).booleanValue()) {
            this.f_19804_.m_135381_(DATA_DEMAT_ID, (Object)false);
        }
    }

    public void setAlpha(float alpha) {
        this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(alpha));
    }

    public void setAnimDescending(boolean anim_descending) {
        this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)anim_descending);
    }

    public void setAnimStage(int anim_stage) {
        this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)anim_stage);
    }

    public void setSignText(String signText) {
        this.f_19804_.m_135381_(DATA_SIGN_ID, (Object)signText);
    }

    public int getOwnerID() {
        return (Integer)this.f_19804_.m_135370_(DATA_OWNERID_ID);
    }

    public float getAlpha() {
        return ((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue();
    }

    public String getSign() {
        return (String)this.f_19804_.m_135370_(DATA_SIGN_ID);
    }

    public String getLevel() {
        return (String)this.f_19804_.m_135370_(DATA_LEVEL_ID);
    }

    public boolean isInFlight() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IN_FLIGHT_ID);
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LOCKED_ID);
    }

    public boolean isDemat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DEMAT_ID);
    }

    public boolean isRemat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_REMAT_ID);
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected void m_6138_() {
    }

    public boolean m_5829_() {
        return !this.isInFlight() && !this.isRemat();
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        Level playerLevel = pPlayer.m_9236_();
        if (playerLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)playerLevel;
            MinecraftServer minecraftserver = serverLevel.m_7654_();
            ResourceKey<Level> resourcekey = ModDimensions.tardisDIM_LEVEL_KEY;
            ServerLevel dimension = minecraftserver.m_129880_(resourcekey);
            ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
            SecurityMapData security_data = SecurityMapData.get(overworld);
            LocationMapData data = LocationMapData.get(overworld);
            int ownerCode = (Integer)this.f_19804_.m_135370_(DATA_OWNERID_ID);
            ItemStack heldStack = pPlayer.m_21120_(pHand);
            if (heldStack.m_150930_((Item)ModItems.TARDIS_KEY.get())) {
                if (ownerCode == pPlayer.m_6302_().hashCode()) {
                    if (!((Boolean)this.f_19804_.m_135370_(DATA_LOCKED_ID)).booleanValue()) {
                        this.f_19804_.m_135381_(DATA_LOCKED_ID, (Object)true);
                        pPlayer.m_5661_((Component)Component.m_237113_((String)"Locking TARDIS").m_130940_(ChatFormatting.GREEN), true);
                    } else {
                        this.f_19804_.m_135381_(DATA_LOCKED_ID, (Object)false);
                        pPlayer.m_5661_((Component)Component.m_237113_((String)"Unlocking TARDIS").m_130940_(ChatFormatting.AQUA), true);
                    }
                } else {
                    pPlayer.m_5661_((Component)Component.m_237113_((String)"This TARDIS is not yours").m_130940_(ChatFormatting.RED), true);
                }
            } else if (!((Boolean)this.f_19804_.m_135370_(DATA_LOCKED_ID)).booleanValue() || pPlayer.m_5833_()) {
                if (!((Boolean)this.f_19804_.m_135370_(DATA_DEMAT_ID)).booleanValue() && !((Boolean)this.f_19804_.m_135370_(DATA_REMAT_ID)).booleanValue() || pPlayer.m_5833_()) {
                    if ((Boolean)this.f_19804_.m_135370_(DATA_IN_FLIGHT_ID) == false && ((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() > 0.0f || pPlayer.m_5833_()) {
                        boolean hasBioSecurity = (Boolean)this.f_19804_.m_135370_(DATA_HAS_BIO_SECURITY_ID);
                        ArrayList<String> whitelistedCodes = new ArrayList<String>();
                        Set<String> secSet = security_data.getDataMap().keySet();
                        for (String secKey : secSet) {
                            if (!secKey.startsWith(Integer.toString(pPlayer.m_6302_().hashCode()))) continue;
                            whitelistedCodes.add(security_data.getDataMap().get(secKey));
                        }
                        if (pPlayer.m_6302_().hashCode() == ownerCode || !hasBioSecurity || whitelistedCodes.contains(pPlayer.m_6302_()) || pPlayer.m_5833_()) {
                            BlockPos blockTardisTarget;
                            if (!data.getDataMap().containsKey(this.m_20148_().toString())) {
                                blockTardisTarget = data.getDataMap().get(Integer.toString(ownerCode));
                                data.getDataMap().put(this.m_20148_().toString(), blockTardisTarget);
                            } else {
                                blockTardisTarget = data.getDataMap().get(this.m_20148_().toString());
                            }
                            Vec3 tardisTarget = new Vec3((double)blockTardisTarget.m_123341_() + 1.5, (double)blockTardisTarget.m_123342_(), (double)blockTardisTarget.m_123343_() + 0.5);
                            int playerRotation = 0;
                            boolean found_door = false;
                            for (int x = -64; x <= 64 && !found_door; ++x) {
                                for (int y = -64; y <= 64 && !found_door; ++y) {
                                    for (int z = -64; z <= 64 && !found_door; ++z) {
                                        BlockPos currentPos = blockTardisTarget.m_7918_(x, y, z);
                                        BlockState blockState = dimension.m_8055_(currentPos);
                                        if (blockState.m_60734_() != ModBlocks.DOOR_BLOCK.get()) continue;
                                        for (int direction = 0; direction < 4; ++direction) {
                                            double z_offset;
                                            double x_offset;
                                            BlockPos newPos;
                                            if (direction == 0) {
                                                newPos = currentPos.m_122029_();
                                                x_offset = 1.5;
                                                z_offset = 0.5;
                                                playerRotation = -90;
                                            } else if (direction == 1) {
                                                newPos = currentPos.m_122019_();
                                                x_offset = 0.5;
                                                z_offset = 1.5;
                                                playerRotation = 0;
                                            } else if (direction == 2) {
                                                newPos = currentPos.m_122024_();
                                                x_offset = -0.5;
                                                z_offset = 0.5;
                                                playerRotation = 90;
                                            } else {
                                                newPos = currentPos.m_122012_();
                                                x_offset = 0.5;
                                                z_offset = -0.5;
                                                playerRotation = 180;
                                            }
                                            if (dimension.m_8055_(newPos) != Blocks.f_50016_.m_49966_() || dimension.m_8055_(newPos.m_7494_()) != Blocks.f_50016_.m_49966_()) continue;
                                            tardisTarget = new Vec3((double)currentPos.m_123341_() + x_offset, (double)currentPos.m_123342_(), (double)currentPos.m_123343_() + z_offset);
                                            break;
                                        }
                                        found_door = true;
                                    }
                                }
                            }
                            if (!found_door) {
                                BlockPos doorTarget = new BlockPos((int)(tardisTarget.f_82479_ - 1.5), (int)tardisTarget.f_82480_, (int)(tardisTarget.f_82481_ - 0.5));
                                serverLevel.m_46597_(doorTarget, ((Block)ModBlocks.DOOR_BLOCK.get()).m_49966_());
                            }
                            pPlayer.m_146922_((float)playerRotation);
                            pPlayer.changeDimension(dimension, (ITeleporter)new ModTeleporter(tardisTarget));
                        } else {
                            pPlayer.m_5661_((Component)Component.m_237113_((String)"You are not whitelisted in this TARDIS").m_130940_(ChatFormatting.RED), true);
                        }
                    }
                } else {
                    pPlayer.m_5661_((Component)Component.m_237113_((String)"You cannot enter the TARDIS while it's dematerializing/rematerializing").m_130940_(ChatFormatting.RED), true);
                }
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"This TARDIS is locked").m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResult.CONSUME;
    }

    public final void teleportToWithTicket(ServerLevel level, double pX, double pY, double pZ, float y_rotation, float x_rotation) {
        ChunkPos chunkpos = new ChunkPos(BlockPos.m_274561_((double)pX, (double)pY, (double)pZ));
        level.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 0, (Object)this.m_19879_());
        level.m_6325_(chunkpos.f_45578_, chunkpos.f_45579_);
        this.m_264318_(level, pX, pY, pZ, RelativeMovement.f_263752_, y_rotation, x_rotation);
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float increment = 0.025f;
            float r_increment = 0.02f;
            if (((Boolean)this.f_19804_.m_135370_(DATA_DEMAT_ID)).booleanValue()) {
                if (((Boolean)this.f_19804_.m_135370_(DATA_ANIM_DESCENDING_ID)).booleanValue()) {
                    if ((double)((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() >= 0.4 - (double)((float)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID)).intValue() / 10.0f)) {
                        this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() - increment));
                    } else {
                        this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)false);
                    }
                } else if (((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() <= 1.0f - (float)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID)).intValue() / 10.0f) {
                    this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() + increment));
                } else {
                    this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID) + 1));
                    this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)true);
                }
                if (((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() <= 0.0f) {
                    this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(0.0f));
                    this.f_19804_.m_135381_(DATA_DEMAT_ID, (Object)false);
                    this.f_19804_.m_135381_(DATA_IN_FLIGHT_ID, (Object)true);
                    this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)false);
                    this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)0);
                }
            }
            if (((Boolean)this.f_19804_.m_135370_(DATA_REMAT_ID)).booleanValue()) {
                MinecraftServer minecraftserver = serverLevel.m_7654_();
                int tickSpeed = minecraftserver.m_129900_().m_46215_(GameRules.f_46143_);
                int tickDelay = (tickSpeed *= 8) * 4;
                if ((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID) < tickDelay) {
                    this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID) + 1));
                } else {
                    if (((Boolean)this.f_19804_.m_135370_(DATA_ANIM_DESCENDING_ID)).booleanValue()) {
                        if (((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() >= 0.0f + (float)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID) - tickDelay) / 10.0f) {
                            this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() - r_increment));
                        } else {
                            this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)false);
                        }
                    } else if ((double)((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() <= 0.5 + (double)((float)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID) - tickDelay) / 10.0f)) {
                        this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() + r_increment));
                    } else {
                        this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)((Integer)this.f_19804_.m_135370_(DATA_ANIM_STAGE_ID) + 1));
                        this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)true);
                    }
                    if (((Float)this.f_19804_.m_135370_(DATA_ALPHA_ID)).floatValue() >= 1.0f) {
                        this.f_19804_.m_135381_(DATA_ALPHA_ID, (Object)Float.valueOf(1.0f));
                        this.f_19804_.m_135381_(DATA_REMAT_ID, (Object)false);
                        this.f_19804_.m_135381_(DATA_ANIM_DESCENDING_ID, (Object)false);
                        this.f_19804_.m_135381_(DATA_ANIM_STAGE_ID, (Object)0);
                    }
                }
            }
            this.f_19804_.m_135381_(DATA_LEVEL_ID, (Object)this.m_9236_().m_46472_().toString());
            this.f_19804_.m_135381_(DATA_TARGET_X_ID, (Object)Float.valueOf((float)this.m_20182_().f_82479_));
            this.f_19804_.m_135381_(DATA_TARGET_Y_ID, (Object)Float.valueOf((float)this.m_20182_().f_82480_));
            this.f_19804_.m_135381_(DATA_TARGET_Z_ID, (Object)Float.valueOf((float)this.m_20182_().f_82481_));
            this.f_19804_.m_135381_(DATA_ROTATION_ID, (Object)((int)this.m_146908_()));
            if (this.getAlpha() >= 1.0f) {
                this.f_19804_.m_135381_(DATA_IN_FLIGHT_ID, (Object)false);
            }
        } else {
            Level increment = this.m_9236_();
            if (increment instanceof ClientLevel) {
                ClientLevel clientLevel = (ClientLevel)increment;
                if (Minecraft.m_91087_().m_257720_()) {
                    String targetDimension = (String)this.f_19804_.m_135370_(DATA_LEVEL_ID);
                    Vec3 target = new Vec3((double)((Float)this.f_19804_.m_135370_(DATA_TARGET_X_ID)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_TARGET_Y_ID)).floatValue(), (double)((Float)this.f_19804_.m_135370_(DATA_TARGET_Z_ID)).floatValue());
                    int rotation_yaw = (Integer)this.f_19804_.m_135370_(DATA_ROTATION_ID);
                    if ((this.m_20182_().f_82479_ != target.f_82479_ || this.m_20182_().f_82480_ != target.f_82480_ || this.m_20182_().f_82481_ != target.f_82481_) && !this.m_21255_() && this.m_9236_().m_46472_().toString().equals(targetDimension)) {
                        this.m_7678_(target.f_82479_, target.f_82480_, target.f_82481_, rotation_yaw, 0.0f);
                    }
                }
            }
        }
        super.m_8119_();
    }
}

