/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.entities.custom;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.plaaasma.vortexmod.entities.custom.DalekUtils;
import net.plaaasma.vortexmod.entities.custom.LaserEntity;
import net.plaaasma.vortexmod.sound.ModSounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DalekEntity
extends Animal
implements RangedAttackMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public DalekUtils.DalekType dalekType;
    private int attackCooldown = 0;
    private boolean didShoot;
    @Nullable
    private BlockPos wanderTarget;

    public DalekEntity(EntityType<? extends DalekEntity> type, Level world, DalekUtils.DalekType dalekType) {
        super(type, world);
        this.dalekType = dalekType;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22277_, 18.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22285_, 10.0).m_22268_(Attributes.f_22282_, 0.5).m_22266_(Attributes.f_22287_).m_22268_(Attributes.f_22281_, 10.0);
    }

    public void m_7678_(double pX, double pY, double pZ, float pYRot, float pXRot) {
        super.m_7678_(pX, pY, pZ, pYRot, pXRot);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(!this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
        super.m_8119_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new DalekHurtByTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 18.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 8, true, false, mob -> !(mob instanceof NeutralMob) && !(mob instanceof Animal) && !(mob instanceof DalekEntity) || mob instanceof Player));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new MoveToGoal(this, 2.0, 0.35));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        if (this.wanderTarget != null) {
            compound.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("WanderTarget"));
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.DALEK_EXTERMINATE_SOUND.get();
    }

    public void m_8032_() {
        this.m_5496_((SoundEvent)ModSounds.DALEK_EXTERMINATE_SOUND.get(), 0.15f, 1.0f);
    }

    protected void m_6677_(DamageSource pSource) {
        this.m_5496_(SoundEvents.f_12064_, 0.15f, 1.0f);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)ModSounds.DALEK_MOVE_SOUND.get(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12064_;
    }

    protected SoundEvent m_5592_() {
        this.m_5496_((SoundEvent)ModSounds.DALEK_DEATH_SOUND.get(), 0.15f, 1.0f);
        return (SoundEvent)ModSounds.DALEK_DEATH_SOUND.get();
    }

    public void setWanderTarget(@Nullable BlockPos pos) {
        this.wanderTarget = pos;
    }

    @Nullable
    private BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    protected float m_6515_(@NotNull DamageSource source, float amount) {
        amount = super.m_6515_(source, amount);
        if (source.m_7639_() == this) {
            amount = 0.0f;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            amount = 0.0f;
        }
        return amount;
    }

    public boolean m_6673_(DamageSource pSource) {
        if (pSource.m_7639_() instanceof DalekEntity || pSource.m_7639_() instanceof LaserEntity) {
            return true;
        }
        return super.m_6673_(pSource);
    }

    private void shootLaser(LivingEntity pTarget) {
        LaserEntity laserEntity = new LaserEntity(this.m_9236_(), (LivingEntity)this);
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - laserEntity.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        laserEntity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.DALEK_SHOOT_SOUND.get(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        this.m_9236_().m_7967_((Entity)laserEntity);
        this.didShoot = true;
    }

    void setDidShoot(boolean pDidShoot) {
        this.didShoot = pDidShoot;
    }

    public void m_6504_(@NotNull LivingEntity pTarget, float pDistanceFactor) {
        this.shootLaser(pTarget);
    }

    public static boolean canSpawn(EntityType<DalekEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Mob.m_217057_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    static class DalekHurtByTargetGoal
    extends HurtByTargetGoal {
        public DalekHurtByTargetGoal(DalekEntity pDalek) {
            super((PathfinderMob)pDalek, new Class[0]);
        }

        public boolean m_8045_() {
            Mob mob = this.f_26135_;
            if (mob instanceof DalekEntity) {
                DalekEntity dalek = (DalekEntity)mob;
                if (dalek.didShoot) {
                    dalek.setDidShoot(false);
                    return false;
                }
            }
            return super.m_8045_();
        }
    }

    class MoveToGoal
    extends Goal {
        final DalekEntity trader;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(DalekEntity LostTravelerEntity2, double v, double v1) {
            this.trader = LostTravelerEntity2;
            this.stopDistance = v;
            this.speedModifier = v1 * 2.0;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.trader.setWanderTarget(null);
            DalekEntity.this.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.trader.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void m_8037_() {
            BlockPos blockpos = this.trader.getWanderTarget();
            if (blockpos != null && DalekEntity.this.f_21344_.m_26571_()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.m_123341_() - this.trader.m_20185_(), (double)blockpos.m_123342_() - this.trader.m_20186_(), (double)blockpos.m_123343_() - this.trader.m_20189_()).m_82541_();
                    Vec3 vector3d1 = vector3d.m_82490_(10.0).m_82520_(this.trader.m_20185_(), this.trader.m_20186_(), this.trader.m_20189_());
                    DalekEntity.this.f_21344_.m_26519_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, this.speedModifier);
                } else {
                    DalekEntity.this.f_21344_.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos pos, double v) {
            return !pos.m_203195_((Position)this.trader.m_20182_(), v);
        }
    }
}

