/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.mapdata.DimensionMapData;

public class SetRotationCommand {
    public SetRotationCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"target").then(Commands.m_82127_((String)"rotation").then(Commands.m_82129_((String)"yaw", (ArgumentType)IntegerArgumentType.integer()).executes(command -> this.setRotation((CommandSourceStack)command.getSource(), IntegerArgumentType.getInteger((CommandContext)command, (String)"yaw")))))));
    }

    private int setRotation(CommandSourceStack source, Integer targetRot) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        VortexInterfaceBlockEntity interfaceEntity = null;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    corePos = currentPos;
                    interfaceEntity = (VortexInterfaceBlockEntity)pLevel.m_7702_(corePos);
                }
            }
        }
        boolean has_components = false;
        boolean has_keypad = false;
        boolean has_designator = false;
        CoordinateDesignatorBlockEntity designatorEntity = null;
        for (int _x = -16; _x <= 16; ++_x) {
            for (int _y = -16; _y <= 16; ++_y) {
                for (int _z = -16; _z <= 16; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                        has_keypad = true;
                    } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                        designatorEntity = (CoordinateDesignatorBlockEntity)pLevel.m_7702_(currentPos);
                        has_designator = true;
                    }
                    if (!has_keypad || !has_designator) continue;
                    has_components = true;
                }
            }
        }
        if (core_found && has_components && designatorEntity != null) {
            DimensionMapData dim_data = DimensionMapData.get(overworld);
            interfaceEntity.data.m_8050_(12, targetRot.intValue());
            Direction rotationDirection = targetRot >= 0 && targetRot < 90 ? Direction.NORTH : (targetRot >= 90 && targetRot < 180 ? Direction.EAST : (targetRot >= 180 && targetRot < 270 ? Direction.SOUTH : Direction.WEST));
            source.m_288197_(() -> Component.m_237113_((String)"Updating target rotation to: ").m_7220_((Component)Component.m_237113_((String)rotationDirection.m_122424_().toString()).m_130940_(ChatFormatting.GOLD)), false);
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_components) {
                source.m_81352_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)"));
            }
        }
        return 1;
    }
}

