/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;

public class SetDimensionCommand {
    public SetDimensionCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"target").then(Commands.m_82127_((String)"dim").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(command -> this.setDim((CommandSourceStack)command.getSource(), DimensionArgument.m_88808_((CommandContext)command, (String)"dimension")))))));
    }

    private int setDim(CommandSourceStack source, ServerLevel targetDim) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel tardisDimension = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
        if (targetDim == tardisDimension) {
            return 1;
        }
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        VortexInterfaceBlockEntity interfaceEntity = null;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    corePos = currentPos;
                    interfaceEntity = (VortexInterfaceBlockEntity)pLevel.m_7702_(corePos);
                }
            }
        }
        boolean has_components = false;
        boolean has_keypad = false;
        boolean has_designator = false;
        CoordinateDesignatorBlockEntity designatorEntity = null;
        for (int _x = -16; _x <= 16; ++_x) {
            for (int _y = -16; _y <= 16; ++_y) {
                for (int _z = -16; _z <= 16; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                        has_keypad = true;
                    } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                        designatorEntity = (CoordinateDesignatorBlockEntity)pLevel.m_7702_(currentPos);
                        has_designator = true;
                    }
                    if (!has_keypad || !has_designator) continue;
                    has_components = true;
                }
            }
        }
        if (core_found && has_components && designatorEntity != null) {
            interfaceEntity.data.m_8050_(10, targetDim.m_46472_().m_135782_().m_135815_().hashCode());
            source.m_288197_(() -> Component.m_237113_((String)"Updating target dimension to: ").m_7220_((Component)Component.m_237113_((String)targetDim.m_46472_().m_135782_().m_135815_()).m_130940_(ChatFormatting.GOLD)), false);
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_components) {
                source.m_81352_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)"));
            }
        }
        return 1;
    }
}

