/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;

public class SetCoordinateCommand {
    public SetCoordinateCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"target").then(Commands.m_82127_((String)"coords").then(Commands.m_82129_((String)"target", (ArgumentType)Vec3Argument.m_120841_()).executes(command -> this.setCoords((CommandSourceStack)command.getSource(), Vec3Argument.m_120849_((CommandContext)command, (String)"target")))))));
    }

    private int setCoords(CommandSourceStack source, Coordinates targetCoords) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        BlockPos targetVec = targetCoords.m_119568_(source);
        ServerLevel pLevel = source.m_230896_().m_284548_();
        int x = targetVec.m_123341_();
        int y = targetVec.m_123342_();
        int z = targetVec.m_123343_();
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    corePos = currentPos;
                }
            }
        }
        boolean has_components = false;
        boolean has_keypad = false;
        boolean has_designator = false;
        CoordinateDesignatorBlockEntity designatorEntity = null;
        for (int _x = -16; _x <= 16 && !has_components; ++_x) {
            for (int _y = -16; _y <= 16 && !has_components; ++_y) {
                for (int _z = -16; _z <= 16 && !has_components; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                        has_keypad = true;
                    } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                        designatorEntity = (CoordinateDesignatorBlockEntity)pLevel.m_7702_(currentPos);
                        has_designator = true;
                    }
                    if (!has_keypad || !has_designator) continue;
                    has_components = true;
                }
            }
        }
        if (core_found && has_components && designatorEntity != null) {
            designatorEntity.data.m_8050_(0, x);
            designatorEntity.data.m_8050_(1, y);
            designatorEntity.data.m_8050_(2, z);
            source.m_288197_(() -> Component.m_237113_((String)"Updating designator coordinates to: ").m_7220_((Component)Component.m_237113_((String)(x + " " + y + " " + z)).m_130940_(ChatFormatting.GOLD)), false);
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_components) {
                source.m_81352_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)"));
            }
        }
        return 1;
    }
}

