/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.mapdata.SecurityMapData;
import net.plaaasma.vortexmod.sound.ModSounds;

public class SecurityCommand {
    public SecurityCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"security").then(Commands.m_82127_((String)"blacklist").then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).executes(command -> this.blacklistPlayer((CommandSourceStack)command.getSource(), GameProfileArgument.m_94590_((CommandContext)command, (String)"target")))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"security").then(Commands.m_82127_((String)"whitelist").then(Commands.m_82129_((String)"target", (ArgumentType)GameProfileArgument.m_94584_()).executes(command -> this.whitelistPlayer((CommandSourceStack)command.getSource(), GameProfileArgument.m_94590_((CommandContext)command, (String)"target")))))));
    }

    private int blacklistPlayer(CommandSourceStack source, Collection<GameProfile> profileCollection) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
        SecurityMapData security_data = SecurityMapData.get(overworld);
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    corePos = currentPos;
                }
            }
        }
        boolean has_bio_module = false;
        BlockPos bio_pos = null;
        for (int _x = -16; _x <= 16 && !has_bio_module; ++_x) {
            for (int _y = -16; _y <= 16 && !has_bio_module; ++_y) {
                for (int _z = -16; _z <= 16 && !has_bio_module; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.BIOMETRIC_BLOCK.get()) continue;
                    has_bio_module = true;
                    bio_pos = currentPos;
                }
            }
        }
        if (core_found && has_bio_module) {
            for (GameProfile profile : profileCollection) {
                String profile_name = profile.getName();
                if (player.m_6302_().equals(profile_name)) {
                    source.m_81352_((Component)Component.m_237113_((String)"You cannot blacklist yourself"));
                    continue;
                }
                if (security_data.getDataMap().containsKey(profile_name.hashCode() + " " + player.m_6302_())) {
                    pLevel.m_214150_(null, (double)bio_pos.m_123341_(), (double)bio_pos.m_123342_(), (double)bio_pos.m_123343_(), (SoundEvent)ModSounds.BIOSEC_PLAYER_REMOVED_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                    security_data.getDataMap().remove(profile_name.hashCode() + " " + player.m_6302_());
                    security_data.m_77762_();
                    source.m_288197_(() -> Component.m_237113_((String)("Removing " + profile_name + " from the whitelist.")), false);
                    continue;
                }
                source.m_81352_((Component)Component.m_237113_((String)(profile_name + " is already blacklisted.")));
            }
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_bio_module) {
                source.m_81352_((Component)Component.m_237113_((String)"Bio security module not in range."));
            }
        }
        return 1;
    }

    private int whitelistPlayer(CommandSourceStack source, Collection<GameProfile> profileCollection) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
        SecurityMapData security_data = SecurityMapData.get(overworld);
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    corePos = currentPos;
                }
            }
        }
        boolean has_bio_module = false;
        BlockPos bio_pos = null;
        for (int _x = -16; _x <= 16 && !has_bio_module; ++_x) {
            for (int _y = -16; _y <= 16 && !has_bio_module; ++_y) {
                for (int _z = -16; _z <= 16 && !has_bio_module; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.BIOMETRIC_BLOCK.get()) continue;
                    has_bio_module = true;
                    bio_pos = currentPos;
                }
            }
        }
        if (core_found && has_bio_module) {
            for (GameProfile profile : profileCollection) {
                String profile_name = profile.getName();
                if (security_data.getDataMap().containsKey(profile_name.hashCode() + " " + player.m_6302_())) {
                    source.m_288197_(() -> Component.m_237113_((String)(profile_name + " is already whitelisted.")), false);
                    continue;
                }
                pLevel.m_214150_(null, (double)bio_pos.m_123341_(), (double)bio_pos.m_123342_(), (double)bio_pos.m_123343_(), (SoundEvent)ModSounds.BIOSEC_PLAYER_ADDED_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                security_data.getDataMap().put(profile_name.hashCode() + " " + player.m_6302_(), profile_name);
                security_data.m_77762_();
                source.m_288197_(() -> Component.m_237113_((String)("Adding " + profile_name + " to the whitelist.")), false);
            }
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_bio_module) {
                source.m_81352_((Component)Component.m_237113_((String)"Bio security module not in range."));
            }
        }
        return 1;
    }
}

