/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.mapdata.DimensionMapData;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.network.ClientboundTargetMapPacket;
import net.plaaasma.vortexmod.network.PacketHandler;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;

public class SaveCoordinateCommand {
    public SaveCoordinateCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"locations").then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"name", (ArgumentType)MessageArgument.m_96832_()).executes(command -> this.setCoords((CommandSourceStack)command.getSource(), MessageArgument.m_96835_((CommandContext)command, (String)"name")))))));
    }

    private int setCoords(CommandSourceStack source, Component locName) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel tardis_dim = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
        ServerLevel vortex = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
        LocationMapData coord_data = LocationMapData.get(vortex);
        DimensionMapData dim_data = DimensionMapData.get(tardis_dim);
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        VortexInterfaceBlockEntity vortexInterfaceBlockEntity = null;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)pLevel.m_7702_(currentPos);
                    corePos = currentPos;
                }
            }
        }
        boolean has_components = false;
        boolean has_keypad = false;
        boolean has_designator = false;
        BlockPos keypadPos = null;
        CoordinateDesignatorBlockEntity designatorEntity = null;
        for (int _x = -16; _x <= 16 && !has_components; ++_x) {
            for (int _y = -16; _y <= 16 && !has_components; ++_y) {
                for (int _z = -16; _z <= 16 && !has_components; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                        has_keypad = true;
                        keypadPos = currentPos;
                    } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                        designatorEntity = (CoordinateDesignatorBlockEntity)pLevel.m_7702_(currentPos);
                        has_designator = true;
                    }
                    if (!has_keypad || !has_designator) continue;
                    has_components = true;
                }
            }
        }
        if (core_found && has_components && designatorEntity != null) {
            int dim_hash = vortexInterfaceBlockEntity.data.m_6413_(10);
            Iterable serverLevels = minecraftserver.m_129785_();
            ServerLevel currentLevel = pLevel;
            for (ServerLevel cLevel : serverLevels) {
                if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != dim_hash) continue;
                currentLevel = cLevel;
            }
            BlockPos targetVec = new BlockPos(vortexInterfaceBlockEntity.data.m_6413_(3), vortexInterfaceBlockEntity.data.m_6413_(4), vortexInterfaceBlockEntity.data.m_6413_(5));
            coord_data.getDataMap().put(player.m_6302_() + locName.getString(), targetVec);
            dim_data.getDataMap().put(player.m_6302_() + locName.getString(), currentLevel.m_46472_().m_135782_().m_135815_());
            ServerLevel finalCurrentLevel = currentLevel;
            source.m_288197_(() -> Component.m_237113_((String)("Adding the current target coordinates (" + targetVec.m_123341_() + " " + targetVec.m_123342_() + " " + targetVec.m_123343_() + " | " + finalCurrentLevel.m_46472_().m_135782_().m_135815_() + ") as " + locName.getString())), false);
            PacketHandler.sendToAllClients(new ClientboundTargetMapPacket(pLevel.m_46472_().m_135782_().m_135815_(), keypadPos, coord_data.getDataMap(), dim_data.getDataMap()));
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_components) {
                source.m_81352_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)"));
            }
        }
        dim_data.m_77762_();
        coord_data.m_77762_();
        return 1;
    }
}

