/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.mapdata.DimensionMapData;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;

public class LoadCoordinateCommand {
    public LoadCoordinateCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"locations").then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"name", (ArgumentType)MessageArgument.m_96832_()).executes(command -> this.loadCoords((CommandSourceStack)command.getSource(), MessageArgument.m_96835_((CommandContext)command, (String)"name")))))));
    }

    private int loadCoords(CommandSourceStack source, Component locName) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos ePlayerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel tardis_dim = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
        ServerLevel vortex = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
        LocationMapData coord_data = LocationMapData.get(vortex);
        DimensionMapData dim_data = DimensionMapData.get(tardis_dim);
        boolean core_found = false;
        BlockPos corePos = ePlayerPos;
        VortexInterfaceBlockEntity vortexInterfaceBlockEntity = null;
        for (int _x = -16; _x <= 16 && !core_found; ++_x) {
            for (int _y = -16; _y <= 16 && !core_found; ++_y) {
                for (int _z = -16; _z <= 16 && !core_found; ++_z) {
                    BlockPos currentPos = ePlayerPos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                    core_found = true;
                    vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)pLevel.m_7702_(currentPos);
                    corePos = currentPos;
                }
            }
        }
        boolean has_components = false;
        boolean has_keypad = false;
        boolean has_designator = false;
        CoordinateDesignatorBlockEntity designatorEntity = null;
        for (int _x = -16; _x <= 16 && !has_components; ++_x) {
            for (int _y = -16; _y <= 16 && !has_components; ++_y) {
                for (int _z = -16; _z <= 16 && !has_components; ++_z) {
                    BlockPos currentPos = corePos.m_7918_(_x, _y, _z);
                    BlockState blockState = pLevel.m_8055_(currentPos);
                    if (blockState.m_60734_() == ModBlocks.KEYPAD_BLOCK.get()) {
                        has_keypad = true;
                    } else if (blockState.m_60734_() == ModBlocks.COORDINATE_BLOCK.get()) {
                        designatorEntity = (CoordinateDesignatorBlockEntity)pLevel.m_7702_(currentPos);
                        has_designator = true;
                    }
                    if (!has_keypad || !has_designator) continue;
                    has_components = true;
                }
            }
        }
        if (core_found && has_components && designatorEntity != null) {
            if (coord_data.getDataMap().containsKey(player.m_6302_() + locName.getString())) {
                BlockPos savedPos = coord_data.getDataMap().get(player.m_6302_() + locName.getString());
                String savedDimName = dim_data.getDataMap().get(player.m_6302_() + locName.getString());
                int savedDimHash = 0;
                Iterable serverLevels = minecraftserver.m_129785_();
                for (ServerLevel cLevel : serverLevels) {
                    if (!cLevel.m_46472_().m_135782_().m_135815_().equals(savedDimName)) continue;
                    savedDimHash = cLevel.m_46472_().m_135782_().m_135815_().hashCode();
                }
                vortexInterfaceBlockEntity.data.m_8050_(14, 1);
                vortexInterfaceBlockEntity.data.m_8050_(15, savedPos.m_123341_());
                vortexInterfaceBlockEntity.data.m_8050_(16, savedPos.m_123342_());
                vortexInterfaceBlockEntity.data.m_8050_(17, savedPos.m_123343_());
                vortexInterfaceBlockEntity.data.m_8050_(18, savedDimHash);
                source.m_288197_(() -> Component.m_237113_((String)("Loading " + locName.getString() + " to the designator. (" + savedPos.m_123341_() + " " + savedPos.m_123342_() + " " + savedPos.m_123343_() + " | " + savedDimName + ")")), false);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)("You do not have a saved destination called " + locName.getString() + ", you can list your destinations with /tardis list")));
            }
        } else {
            if (!core_found) {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
            if (!has_components) {
                source.m_81352_((Component)Component.m_237113_((String)"Coordinate components not in range. (Keypad and Designator)"));
            }
        }
        dim_data.m_77762_();
        coord_data.m_77762_();
        return 1;
    }
}

