/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.plaaasma.vortexmod.mapdata.DimensionMapData;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;

public class ListCoordinateCommand {
    public ListCoordinateCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"locations").then(Commands.m_82127_((String)"list").executes(command -> this.listCoords((CommandSourceStack)command.getSource())))));
    }

    private int listCoords(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        String playerName = player.m_6302_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        MinecraftServer minecraftserver = pLevel.m_7654_();
        ServerLevel tardis_dim = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
        ServerLevel vortex = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
        LocationMapData coord_data = LocationMapData.get(vortex);
        DimensionMapData dim_data = DimensionMapData.get(tardis_dim);
        ArrayList<MutableComponent> locationStrings = new ArrayList<MutableComponent>();
        Set<String> coordKeys = coord_data.getDataMap().keySet();
        for (String string : coordKeys) {
            if (!string.startsWith(playerName)) continue;
            String pointName = string.substring(playerName.length()) + ": ";
            BlockPos pointPos = coord_data.getDataMap().get(string);
            String pointCoords = pointPos.m_123341_() + " " + pointPos.m_123342_() + " " + pointPos.m_123343_() + " | ";
            String pointDimension = dim_data.getDataMap().get(string);
            MutableComponent pointComponent = Component.m_237113_((String)pointName).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(pointCoords + pointDimension)).m_130940_(ChatFormatting.GOLD));
            locationStrings.add(pointComponent);
        }
        for (Component component : locationStrings) {
            source.m_288197_(() -> locComp, false);
        }
        return 1;
    }
}

