/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.state.BlockState;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;

public class ExteriorCommand {
    public ExteriorCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tardis").then(Commands.m_82127_((String)"exterior").then(Commands.m_82127_((String)"text").then(Commands.m_82129_((String)"target", (ArgumentType)MessageArgument.m_96832_()).executes(command -> this.setSign((CommandSourceStack)command.getSource(), MessageArgument.m_96835_((CommandContext)command, (String)"target")))))));
    }

    private int setSign(CommandSourceStack source, Component signComponent) throws CommandSyntaxException {
        ServerPlayer player = source.m_230896_();
        BlockPos playerPos = player.m_20183_();
        ServerLevel pLevel = source.m_230896_().m_284548_();
        if (signComponent.getString().length() > 16) {
            source.m_81352_((Component)Component.m_237113_((String)"Sign text cannot be more than 16 characters"));
        } else {
            VortexInterfaceBlockEntity interfaceEntity = null;
            boolean core_found = false;
            for (int x = -16; x <= 16 && !core_found; ++x) {
                for (int y = -16; y <= 16 && !core_found; ++y) {
                    for (int z = -16; z <= 16 && !core_found; ++z) {
                        BlockPos currentPos = playerPos.m_7918_(x, y, z);
                        BlockState blockState = pLevel.m_8055_(currentPos);
                        if (blockState.m_60734_() != ModBlocks.INTERFACE_BLOCK.get()) continue;
                        core_found = true;
                        interfaceEntity = (VortexInterfaceBlockEntity)pLevel.m_7702_(currentPos);
                    }
                }
            }
            if (interfaceEntity != null) {
                if (interfaceEntity.data.m_6413_(2) == player.m_6302_().hashCode()) {
                    interfaceEntity.setSignJ(signComponent.getString());
                    source.m_288197_(() -> Component.m_237113_((String)("Set sign text to: " + signComponent.getString())).m_130940_(ChatFormatting.AQUA), false);
                } else {
                    source.m_81352_((Component)Component.m_237113_((String)"You do not own this TARDIS."));
                }
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"Core is not in range."));
            }
        }
        return 1;
    }
}

