/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.entity;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.custom.ThrottleBlock;
import net.plaaasma.vortexmod.block.entity.BiometricBlockEntity;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.block.entity.MonitorBlockEntity;
import net.plaaasma.vortexmod.block.entity.SizeManipulatorBlockEntity;
import net.plaaasma.vortexmod.entities.custom.TardisEntity;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.sound.ModSounds;
import net.plaaasma.vortexmod.util.ModEnergyStorage;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;
import net.plaaasma.vortexmod.worldgen.portal.ModTeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VortexInterfaceBlockEntity
extends BlockEntity {
    private int ticks = 0;
    private int last_tick = 0;
    private int owner = 0;
    private int target_x = 0;
    private int target_y = 0;
    private int target_z = 0;
    private int pos_x = 0;
    private int pos_y = 0;
    private int pos_z = 0;
    private int current_dim = 0;
    private int target_dim = 0;
    private int did_r_sound = 0;
    private int facing_dir = 0;
    private int cc_throttle_on = 0;
    private int cc_set_coords = 0;
    private int cc_set_x = 0;
    private int cc_set_y = 0;
    private int cc_set_z = 0;
    private int cc_set_dim = 0;
    private int is_flying = 0;
    private int flight_time = 0;
    private int redstone_signal = 0;
    private int sound_time = 0;
    private int has_landed = 0;
    private int ready_to_land = 0;
    private UUID exterior_uuid = UUID.randomUUID();
    public final ContainerData data;
    private final ModEnergyStorage energy = new ModEnergyStorage(24000, 1024, 0, 2000);
    private final LazyOptional<ModEnergyStorage> energyOptional = LazyOptional.of(() -> this.energy);

    public VortexInterfaceBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.VORTEX_INTERFACE_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> VortexInterfaceBlockEntity.this.ticks;
                    case 1 -> VortexInterfaceBlockEntity.this.last_tick;
                    case 2 -> VortexInterfaceBlockEntity.this.owner;
                    case 3 -> VortexInterfaceBlockEntity.this.target_x;
                    case 4 -> VortexInterfaceBlockEntity.this.target_y;
                    case 5 -> VortexInterfaceBlockEntity.this.target_z;
                    case 6 -> VortexInterfaceBlockEntity.this.pos_x;
                    case 7 -> VortexInterfaceBlockEntity.this.pos_y;
                    case 8 -> VortexInterfaceBlockEntity.this.pos_z;
                    case 9 -> VortexInterfaceBlockEntity.this.current_dim;
                    case 10 -> VortexInterfaceBlockEntity.this.target_dim;
                    case 11 -> VortexInterfaceBlockEntity.this.did_r_sound;
                    case 12 -> VortexInterfaceBlockEntity.this.facing_dir;
                    case 13 -> VortexInterfaceBlockEntity.this.cc_throttle_on;
                    case 14 -> VortexInterfaceBlockEntity.this.cc_set_coords;
                    case 15 -> VortexInterfaceBlockEntity.this.cc_set_x;
                    case 16 -> VortexInterfaceBlockEntity.this.cc_set_y;
                    case 17 -> VortexInterfaceBlockEntity.this.cc_set_z;
                    case 18 -> VortexInterfaceBlockEntity.this.cc_set_dim;
                    case 19 -> VortexInterfaceBlockEntity.this.is_flying;
                    case 20 -> VortexInterfaceBlockEntity.this.flight_time;
                    case 21 -> VortexInterfaceBlockEntity.this.redstone_signal;
                    case 22 -> VortexInterfaceBlockEntity.this.sound_time;
                    case 23 -> VortexInterfaceBlockEntity.this.has_landed;
                    case 24 -> VortexInterfaceBlockEntity.this.ready_to_land;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        VortexInterfaceBlockEntity.this.ticks = pValue;
                        break;
                    }
                    case 1: {
                        VortexInterfaceBlockEntity.this.last_tick = pValue;
                        break;
                    }
                    case 2: {
                        VortexInterfaceBlockEntity.this.owner = pValue;
                        break;
                    }
                    case 3: {
                        VortexInterfaceBlockEntity.this.target_x = pValue;
                        break;
                    }
                    case 4: {
                        VortexInterfaceBlockEntity.this.target_y = pValue;
                        break;
                    }
                    case 5: {
                        VortexInterfaceBlockEntity.this.target_z = pValue;
                        break;
                    }
                    case 6: {
                        VortexInterfaceBlockEntity.this.pos_x = pValue;
                        break;
                    }
                    case 7: {
                        VortexInterfaceBlockEntity.this.pos_y = pValue;
                        break;
                    }
                    case 8: {
                        VortexInterfaceBlockEntity.this.pos_z = pValue;
                        break;
                    }
                    case 9: {
                        VortexInterfaceBlockEntity.this.current_dim = pValue;
                        break;
                    }
                    case 10: {
                        VortexInterfaceBlockEntity.this.target_dim = pValue;
                        break;
                    }
                    case 11: {
                        VortexInterfaceBlockEntity.this.did_r_sound = pValue;
                        break;
                    }
                    case 12: {
                        VortexInterfaceBlockEntity.this.facing_dir = pValue;
                        break;
                    }
                    case 13: {
                        VortexInterfaceBlockEntity.this.cc_throttle_on = pValue;
                        break;
                    }
                    case 14: {
                        VortexInterfaceBlockEntity.this.cc_set_coords = pValue;
                        break;
                    }
                    case 15: {
                        VortexInterfaceBlockEntity.this.cc_set_x = pValue;
                        break;
                    }
                    case 16: {
                        VortexInterfaceBlockEntity.this.cc_set_y = pValue;
                        break;
                    }
                    case 17: {
                        VortexInterfaceBlockEntity.this.cc_set_z = pValue;
                        break;
                    }
                    case 18: {
                        VortexInterfaceBlockEntity.this.cc_set_dim = pValue;
                        break;
                    }
                    case 19: {
                        VortexInterfaceBlockEntity.this.is_flying = pValue;
                        break;
                    }
                    case 20: {
                        VortexInterfaceBlockEntity.this.flight_time = pValue;
                        break;
                    }
                    case 21: {
                        VortexInterfaceBlockEntity.this.redstone_signal = pValue;
                        break;
                    }
                    case 22: {
                        VortexInterfaceBlockEntity.this.sound_time = pValue;
                        break;
                    }
                    case 23: {
                        VortexInterfaceBlockEntity.this.has_landed = pValue;
                        break;
                    }
                    case 24: {
                        VortexInterfaceBlockEntity.this.ready_to_land = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 25;
            }
        };
    }

    public void setExtUUID(UUID uuidToSet) {
        this.exterior_uuid = uuidToSet;
    }

    public UUID getExtUUID() {
        return this.exterior_uuid;
    }

    public void onLoad() {
        super.onLoad();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    public void m_142466_(CompoundTag pTag) {
        CompoundTag vortexModData = pTag.m_128469_("vortexmod");
        this.ticks = vortexModData.m_128451_("ticks");
        this.last_tick = vortexModData.m_128451_("last_tick");
        this.owner = vortexModData.m_128451_("owner");
        this.target_x = vortexModData.m_128451_("target_x");
        this.target_y = vortexModData.m_128451_("target_y");
        this.target_z = vortexModData.m_128451_("target_z");
        this.pos_x = vortexModData.m_128451_("pos_x");
        this.pos_y = vortexModData.m_128451_("pos_y");
        this.pos_z = vortexModData.m_128451_("pos_z");
        this.current_dim = vortexModData.m_128451_("current_dim");
        this.target_dim = vortexModData.m_128451_("target_dim");
        this.did_r_sound = vortexModData.m_128451_("did_r_sound");
        this.facing_dir = vortexModData.m_128451_("facing_dir");
        this.cc_throttle_on = vortexModData.m_128451_("cc_throttle_on");
        this.cc_set_coords = vortexModData.m_128451_("cc_set_coords");
        this.cc_set_x = vortexModData.m_128451_("cc_set_x");
        this.cc_set_y = vortexModData.m_128451_("cc_set_y");
        this.cc_set_z = vortexModData.m_128451_("cc_set_z");
        this.cc_set_dim = vortexModData.m_128451_("cc_set_dim");
        this.is_flying = vortexModData.m_128451_("is_flying");
        this.flight_time = vortexModData.m_128451_("flight_time");
        this.sound_time = vortexModData.m_128451_("sound_time");
        this.ready_to_land = vortexModData.m_128451_("ready_to_land");
        if (vortexModData.m_128441_("exterior_uuid")) {
            this.exterior_uuid = vortexModData.m_128342_("exterior_uuid");
        }
        if (vortexModData.m_128441_("energy")) {
            this.energy.deserializeNBT(vortexModData.m_128423_("energy"));
        }
        super.m_142466_(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        CompoundTag vortexModData = new CompoundTag();
        vortexModData.m_128405_("ticks", this.ticks);
        vortexModData.m_128405_("last_tick", this.last_tick);
        vortexModData.m_128405_("owner", this.owner);
        vortexModData.m_128405_("target_x", this.target_x);
        vortexModData.m_128405_("target_y", this.target_y);
        vortexModData.m_128405_("target_z", this.target_z);
        vortexModData.m_128405_("pos_x", this.pos_x);
        vortexModData.m_128405_("pos_y", this.pos_y);
        vortexModData.m_128405_("pos_z", this.pos_z);
        vortexModData.m_128405_("current_dim", this.current_dim);
        vortexModData.m_128405_("target_dim", this.target_dim);
        vortexModData.m_128405_("did_r_sound", this.did_r_sound);
        vortexModData.m_128405_("facing_dir", this.facing_dir);
        vortexModData.m_128405_("cc_throttle_on", this.cc_throttle_on);
        vortexModData.m_128405_("cc_set_coords", this.cc_set_coords);
        vortexModData.m_128405_("cc_set_x", this.cc_set_x);
        vortexModData.m_128405_("cc_set_y", this.cc_set_y);
        vortexModData.m_128405_("cc_set_z", this.cc_set_z);
        vortexModData.m_128405_("cc_set_dim", this.cc_set_dim);
        vortexModData.m_128405_("is_flying", this.is_flying);
        vortexModData.m_128405_("flight_time", this.flight_time);
        vortexModData.m_128362_("exterior_uuid", this.exterior_uuid);
        vortexModData.m_128405_("sound_time", this.sound_time);
        vortexModData.m_128405_("ready_to_land", this.ready_to_land);
        vortexModData.m_128365_("energy", this.energy.serializeNBT());
        pTag.m_128365_("vortexmod", (Tag)vortexModData);
        super.m_183515_(pTag);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return super.getCapability(cap);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<ModEnergyStorage> getEnergyOptional() {
        return this.energyOptional;
    }

    public ModEnergyStorage getEnergy() {
        return this.energy;
    }

    public void sendUpdate() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public final void setSignJ(String signText) {
        MinecraftServer minecraftserver = this.f_58857_.m_7654_();
        Iterable serverLevels = minecraftserver.m_129785_();
        TardisEntity tardisEntity = null;
        for (ServerLevel cLevel : serverLevels) {
            TardisEntity newTardisEntity = (TardisEntity)cLevel.m_8791_(this.exterior_uuid);
            if (newTardisEntity == null) continue;
            tardisEntity = newTardisEntity;
        }
        if (tardisEntity != null) {
            tardisEntity.setSignText(signText);
        }
    }

    public final String getTargetDimensionJ() {
        MinecraftServer minecraftserver = this.m_58904_().m_7654_();
        Iterable serverLevels = minecraftserver.m_129785_();
        String targetDim = "";
        for (ServerLevel cLevel : serverLevels) {
            if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != this.data.m_6413_(10)) continue;
            targetDim = cLevel.m_46472_().m_135782_().m_135815_();
            break;
        }
        return targetDim;
    }

    public final void setDimensionJ(String param) {
        this.data.m_8050_(18, param.hashCode());
    }

    @LuaFunction
    public final void setCoordsJ(BlockPos targetPos) {
        this.data.m_8050_(14, 1);
        this.data.m_8050_(15, targetPos.m_123341_());
        this.data.m_8050_(16, targetPos.m_123342_());
        this.data.m_8050_(17, targetPos.m_123343_());
    }

    @LuaFunction
    public final boolean setSign(String signText) throws LuaException {
        if (signText.length() <= 16) {
            MinecraftServer minecraftserver = this.f_58857_.m_7654_();
            Iterable serverLevels = minecraftserver.m_129785_();
            TardisEntity tardisEntity = null;
            for (ServerLevel cLevel : serverLevels) {
                TardisEntity newTardisEntity = (TardisEntity)cLevel.m_8791_(this.exterior_uuid);
                if (newTardisEntity == null) continue;
                tardisEntity = newTardisEntity;
            }
            if (tardisEntity != null) {
                tardisEntity.setSignText(signText);
            }
            return true;
        }
        return false;
    }

    @LuaFunction
    public final Integer getPower() throws LuaException {
        return this.energy.getEnergyStored();
    }

    @LuaFunction
    public final Boolean enableThrottle() throws LuaException {
        this.data.m_8050_(13, 1);
        return true;
    }

    @LuaFunction
    public final Boolean disableThrottle() throws LuaException {
        this.data.m_8050_(13, 2);
        return true;
    }

    @LuaFunction
    public final Boolean readyToLand() throws LuaException {
        return this.data.m_6413_(24) == 1;
    }

    @LuaFunction
    public final Boolean isFlying() throws LuaException {
        return this.data.m_6413_(19) == 1;
    }

    @LuaFunction
    public final Boolean setCoords(String param) throws LuaException {
        String[] numbers = param.split(" ");
        if (numbers.length == 3) {
            for (int index = 0; index < 3; ++index) {
                int num = (int)Double.parseDouble(numbers[index]);
                this.data.m_8050_(14, 1);
                if (index == 0) {
                    this.data.m_8050_(15, num);
                }
                if (index == 1) {
                    this.data.m_8050_(16, num);
                }
                if (index != 2) continue;
                this.data.m_8050_(17, num);
            }
            return true;
        }
        return false;
    }

    @LuaFunction
    public final Boolean setDimension(String param) throws LuaException {
        this.data.m_8050_(18, param.hashCode());
        return true;
    }

    @LuaFunction
    public final Map<String, Integer> getTargetLocation() throws LuaException {
        HashMap<String, Integer> coordMap = new HashMap<String, Integer>();
        coordMap.put("x", this.data.m_6413_(3));
        coordMap.put("y", this.data.m_6413_(4));
        coordMap.put("z", this.data.m_6413_(5));
        return coordMap;
    }

    @LuaFunction
    public final Map<String, Integer> getExtLocation() throws LuaException {
        HashMap<String, Integer> coordMap = new HashMap<String, Integer>();
        coordMap.put("x", this.data.m_6413_(6));
        coordMap.put("y", this.data.m_6413_(7));
        coordMap.put("z", this.data.m_6413_(8));
        return coordMap;
    }

    @LuaFunction
    public final String getTargetDimension() throws LuaException {
        MinecraftServer minecraftserver = this.m_58904_().m_7654_();
        Iterable serverLevels = minecraftserver.m_129785_();
        String targetDim = "";
        for (ServerLevel cLevel : serverLevels) {
            if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != this.data.m_6413_(10)) continue;
            targetDim = cLevel.m_46472_().m_135782_().m_135815_();
            break;
        }
        return targetDim;
    }

    @LuaFunction
    public final String getExtDimension() throws LuaException {
        MinecraftServer minecraftserver = this.m_58904_().m_7654_();
        Iterable serverLevels = minecraftserver.m_129785_();
        String currentDim = "";
        for (ServerLevel cLevel : serverLevels) {
            if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != this.data.m_6413_(9)) continue;
            currentDim = cLevel.m_46472_().m_135782_().m_135815_();
            break;
        }
        return currentDim;
    }

    @LuaFunction
    public final String getTargetRotation() throws LuaException {
        int rotation_yaw = this.data.m_6413_(12);
        Direction rotationDirection = rotation_yaw >= 0 && rotation_yaw < 90 ? Direction.NORTH : (rotation_yaw >= 90 && rotation_yaw < 180 ? Direction.EAST : (rotation_yaw >= 180 && rotation_yaw < 270 ? Direction.SOUTH : Direction.WEST));
        return rotationDirection.toString();
    }

    @LuaFunction
    public final String getTargetBlock() throws LuaException {
        MinecraftServer minecraftserver = this.m_58904_().m_7654_();
        ServerLevel overworldDimension = minecraftserver.m_129880_(Level.f_46428_);
        Iterable serverLevels = minecraftserver.m_129785_();
        ServerLevel targetDimension = overworldDimension;
        for (ServerLevel cLevel : serverLevels) {
            if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != this.data.m_6413_(10)) continue;
            targetDimension = cLevel;
            break;
        }
        BlockState targetState = targetDimension.m_8055_(new BlockPos(this.data.m_6413_(3), this.data.m_6413_(4), this.data.m_6413_(5)));
        return targetState.m_60734_().m_49954_().getString();
    }

    @LuaFunction
    public final Integer getFlightTime() throws LuaException {
        return this.data.m_6413_(20);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.m_5776_()) {
            BlockPos new_target;
            MinecraftServer minecraftserver = pLevel.m_7654_();
            int tickSpeed = minecraftserver.m_129900_().m_46215_(GameRules.f_46143_);
            tickSpeed *= 8;
            ServerLevel vortexDimension = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
            ServerLevel tardisDimension = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
            ServerLevel overworldDimension = minecraftserver.m_129880_(Level.f_46428_);
            this.data.m_8050_(0, this.data.m_6413_(0) + 1);
            if (pLevel.m_46472_() != vortexDimension.m_46472_() && pLevel.m_46472_() != tardisDimension.m_46472_()) {
                int dimId = pLevel.m_46472_().m_135782_().m_135815_().hashCode();
                this.data.m_8050_(9, dimId);
                if (this.data.m_6413_(10) == 0) {
                    this.data.m_8050_(10, dimId);
                }
            } else if (this.data.m_6413_(10) == 0) {
                this.data.m_8050_(10, overworldDimension.m_46472_().m_135782_().m_135815_().hashCode());
            }
            Iterable serverLevels = minecraftserver.m_129785_();
            ServerLevel currentDimension = overworldDimension;
            ServerLevel targetDimension = overworldDimension;
            TardisEntity tardisEntity = null;
            for (ServerLevel cLevel : serverLevels) {
                TardisEntity newTardisEntity;
                if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() == this.data.m_6413_(9)) {
                    currentDimension = cLevel;
                }
                if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() == this.data.m_6413_(10) && this.data.m_6413_(18) == 0) {
                    targetDimension = cLevel;
                }
                if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() == this.data.m_6413_(18)) {
                    targetDimension = cLevel;
                    this.data.m_8050_(10, this.data.m_6413_(18));
                    this.data.m_8050_(18, 0);
                }
                if ((newTardisEntity = (TardisEntity)cLevel.m_8791_(this.exterior_uuid)) == null) continue;
                tardisEntity = newTardisEntity;
            }
            if (tardisEntity == null) {
                tardisEntity = (TardisEntity)currentDimension.m_8791_(this.exterior_uuid);
            } else {
                currentDimension = (ServerLevel)tardisEntity.m_9236_();
            }
            if (tardisEntity == null) {
                AABB searchBB = AABB.m_165882_((Vec3)new Vec3((double)this.data.m_6413_(6), (double)this.data.m_6413_(7), (double)this.data.m_6413_(8)), (double)8.0, (double)8.0, (double)8.0);
                List nearbyEntities = currentDimension.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                ArrayList<TardisEntity> nearbyTardisEntities = new ArrayList<TardisEntity>();
                for (Entity entity2 : nearbyEntities) {
                    if (!(entity2 instanceof TardisEntity)) continue;
                    TardisEntity newTardisEntity = (TardisEntity)entity2;
                    nearbyTardisEntities.add(newTardisEntity);
                }
                if (nearbyTardisEntities.size() > 0) {
                    tardisEntity = (TardisEntity)((Object)nearbyTardisEntities.get(0));
                }
            }
            if (pLevel == targetDimension) {
                this.data.m_8050_(6, pPos.m_123341_());
                this.data.m_8050_(7, pPos.m_123342_());
                this.data.m_8050_(8, pPos.m_123343_());
            }
            int size = 1;
            int targetX = this.data.m_6413_(3);
            int targetY = this.data.m_6413_(4);
            int targetZ = this.data.m_6413_(5);
            int throttle_on = 0;
            boolean autoLand = false;
            boolean has_equalizer = false;
            boolean has_bio_sec = false;
            boolean auto_ground = false;
            boolean proto = true;
            if (pLevel == tardisDimension) {
                proto = false;
                if (tardisEntity != null) {
                    tardisEntity.setOwnerID(this.data.m_6413_(2));
                }
            }
            AABB overrideAABB = null;
            for (int x = -size; x <= size; ++x) {
                for (int y = -1; y <= size; ++y) {
                    for (int z = -size; z <= size; ++z) {
                        BlockEntity blockEntity;
                        BlockPos currentPos = pPos.m_7918_(x, y, z);
                        if (currentPos == pPos || !((blockEntity = pLevel.m_7702_(currentPos)) instanceof SizeManipulatorBlockEntity)) continue;
                        SizeManipulatorBlockEntity sizeManipulatorBlockEntity = (SizeManipulatorBlockEntity)blockEntity;
                        size += sizeManipulatorBlockEntity.data.m_6413_(0);
                        if (sizeManipulatorBlockEntity.getAlphaPos() == null || sizeManipulatorBlockEntity.getBetaPos() == null || (overrideAABB = new AABB(sizeManipulatorBlockEntity.getAlphaPos(), sizeManipulatorBlockEntity.getBetaPos())).m_82309_() != 0.0) continue;
                        overrideAABB = null;
                    }
                }
            }
            if (overrideAABB != null) {
                int xDif = (int)(overrideAABB.f_82291_ - overrideAABB.f_82288_);
                int yDif = (int)(overrideAABB.f_82292_ - overrideAABB.f_82289_);
                int zDif = (int)(overrideAABB.f_82293_ - overrideAABB.f_82290_);
                int biggestDifference = xDif > yDif && xDif > zDif ? xDif : (yDif > xDif && yDif > zDif ? yDif : zDif);
                size = biggestDifference;
            }
            if (size <= 0) {
                size = 1;
            }
            int y_size = 5;
            if (size < 5) {
                y_size = size;
            }
            if (!proto) {
                size = 16;
                y_size = 16;
            }
            MonitorBlockEntity monitorBlockEntity = null;
            if (overrideAABB == null || !proto) {
                for (x = -size; x <= size; ++x) {
                    for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                        for (int z = -size; z <= size; ++z) {
                            currentPos = pPos.m_7918_(x, y, z);
                            if (currentPos == pPos) continue;
                            blockState = pLevel.m_8055_(currentPos);
                            block = blockState.m_60734_();
                            if (block == ModBlocks.GROUNDING_BLOCK.get()) {
                                auto_ground = true;
                            } else if (block == ModBlocks.EQUALIZER_BLOCK.get()) {
                                has_equalizer = true;
                            } else if (block == ModBlocks.THROTTLE_BLOCK.get()) {
                                if (((Boolean)blockState.m_61143_((Property)ThrottleBlock.POWERED)).booleanValue()) {
                                    throttle_on = 1;
                                }
                                if (((Boolean)blockState.m_61143_((Property)ThrottleBlock.AUTO)).booleanValue()) {
                                    autoLand = true;
                                }
                                if (this.data.m_6413_(13) == 1) {
                                    throttle_on = 1;
                                    if (!((Boolean)blockState.m_61143_((Property)ThrottleBlock.POWERED)).booleanValue()) {
                                        ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                                    }
                                    this.data.m_8050_(13, 0);
                                } else if (this.data.m_6413_(13) == 2) {
                                    throttle_on = 0;
                                    if (((Boolean)blockState.m_61143_((Property)ThrottleBlock.POWERED)).booleanValue()) {
                                        ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                                    }
                                    this.data.m_8050_(13, 0);
                                }
                            }
                            blockEntity = pLevel.m_7702_(currentPos);
                            if (blockEntity == null) continue;
                            if (blockEntity instanceof CoordinateDesignatorBlockEntity) {
                                designatorBlockEntity = (CoordinateDesignatorBlockEntity)blockEntity;
                                if (tardisEntity != null) {
                                    if (!tardisEntity.isRemat()) {
                                        targetX = designatorBlockEntity.data.m_6413_(0);
                                        targetY = designatorBlockEntity.data.m_6413_(1);
                                        targetZ = designatorBlockEntity.data.m_6413_(2);
                                    }
                                } else {
                                    targetX = designatorBlockEntity.data.m_6413_(0);
                                    targetY = designatorBlockEntity.data.m_6413_(1);
                                    targetZ = designatorBlockEntity.data.m_6413_(2);
                                }
                                if (this.data.m_6413_(14) == 1) {
                                    targetX = this.data.m_6413_(15);
                                    targetY = this.data.m_6413_(16);
                                    targetZ = this.data.m_6413_(17);
                                    designatorBlockEntity.data.m_8050_(0, targetX);
                                    designatorBlockEntity.data.m_8050_(1, targetY);
                                    designatorBlockEntity.data.m_8050_(2, targetZ);
                                    this.data.m_8050_(14, 0);
                                }
                            }
                            if (blockEntity instanceof BiometricBlockEntity) {
                                has_bio_sec = true;
                            }
                            if (!(blockEntity instanceof MonitorBlockEntity)) continue;
                            monitorBlockEntity = monitorBlockEntity1 = (MonitorBlockEntity)blockEntity;
                        }
                    }
                }
            } else {
                for (x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                    for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                        for (int z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                            currentPos = pPos.m_7918_(x, y, z);
                            if (currentPos == pPos) continue;
                            blockState = pLevel.m_8055_(currentPos);
                            block = blockState.m_60734_();
                            if (block == ModBlocks.GROUNDING_BLOCK.get()) {
                                auto_ground = true;
                            } else if (block == ModBlocks.EQUALIZER_BLOCK.get()) {
                                has_equalizer = true;
                            } else if (block == ModBlocks.THROTTLE_BLOCK.get()) {
                                throttle_on = (Boolean)blockState.m_61143_((Property)ThrottleBlock.POWERED) != false ? 1 : 0;
                                if (((Boolean)blockState.m_61143_((Property)ThrottleBlock.AUTO)).booleanValue()) {
                                    autoLand = true;
                                }
                                if (this.data.m_6413_(13) == 1) {
                                    throttle_on = 1;
                                    if (!((Boolean)blockState.m_61143_((Property)ThrottleBlock.POWERED)).booleanValue()) {
                                        ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                                    }
                                    this.data.m_8050_(13, 0);
                                } else if (this.data.m_6413_(13) == 2) {
                                    throttle_on = 0;
                                    if (((Boolean)blockState.m_61143_((Property)ThrottleBlock.POWERED)).booleanValue()) {
                                        ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                                    }
                                    this.data.m_8050_(13, 0);
                                }
                            }
                            blockEntity = pLevel.m_7702_(currentPos);
                            if (blockEntity == null) continue;
                            if (blockEntity instanceof CoordinateDesignatorBlockEntity) {
                                designatorBlockEntity = (CoordinateDesignatorBlockEntity)blockEntity;
                                targetX = designatorBlockEntity.data.m_6413_(0);
                                targetY = designatorBlockEntity.data.m_6413_(1);
                                targetZ = designatorBlockEntity.data.m_6413_(2);
                                if (this.data.m_6413_(14) == 1) {
                                    targetX = this.data.m_6413_(15);
                                    targetY = this.data.m_6413_(16);
                                    targetZ = this.data.m_6413_(17);
                                    designatorBlockEntity.data.m_8050_(0, targetX);
                                    designatorBlockEntity.data.m_8050_(1, targetY);
                                    designatorBlockEntity.data.m_8050_(2, targetZ);
                                    this.data.m_8050_(14, 0);
                                }
                            }
                            if (blockEntity instanceof BiometricBlockEntity) {
                                has_bio_sec = true;
                            }
                            if (!(blockEntity instanceof MonitorBlockEntity)) continue;
                            monitorBlockEntity = monitorBlockEntity1 = (MonitorBlockEntity)blockEntity;
                        }
                    }
                }
            }
            if (tardisEntity != null) {
                tardisEntity.setHasBioSecurity(has_bio_sec);
            }
            this.data.m_8050_(3, targetX);
            this.data.m_8050_(4, targetY);
            this.data.m_8050_(5, targetZ);
            if (throttle_on == 0 && proto) {
                this.data.m_8050_(1, this.data.m_6413_(0));
            }
            this.data.m_8050_(19, throttle_on);
            BlockPos temp_target = new BlockPos(targetX, targetY, targetZ);
            if (auto_ground && targetDimension.m_8055_(new_target = temp_target.m_7495_()).m_60734_() == Blocks.f_50016_) {
                boolean is_air = true;
                boolean going_down = true;
                boolean exhausted_search = false;
                while (is_air) {
                    if (new_target.m_123342_() <= targetDimension.m_6042_().f_156647_()) {
                        going_down = false;
                    }
                    if (new_target.m_123342_() >= targetDimension.m_6042_().f_156648_() && !going_down) {
                        exhausted_search = true;
                        break;
                    }
                    new_target = going_down ? new_target.m_7495_() : new_target.m_7494_();
                    if (targetDimension.m_8055_(new_target).m_60734_() == Blocks.f_50016_) continue;
                    is_air = false;
                }
                if (!exhausted_search) {
                    temp_target = going_down ? new_target.m_7494_() : new_target.m_7495_();
                }
                if (exhausted_search) {
                    temp_target = new BlockPos(targetX, targetY, targetZ);
                }
            }
            targetX = temp_target.m_123341_();
            targetY = temp_target.m_123342_();
            targetZ = temp_target.m_123343_();
            if (overrideAABB != null) {
                if ((double)targetY >= (double)(targetDimension.m_6042_().f_156647_() + targetDimension.m_6042_().f_156648_()) - (overrideAABB.f_82292_ + 16.0)) {
                    targetY = (int)((double)(targetDimension.m_6042_().f_156647_() + targetDimension.m_6042_().f_156648_()) - (overrideAABB.f_82292_ + 16.0));
                }
            } else if (targetY >= targetDimension.m_6042_().f_156647_() + targetDimension.m_6042_().f_156648_() - (y_size + (y_size - 1))) {
                targetY = targetDimension.m_6042_().f_156647_() + targetDimension.m_6042_().f_156648_() - (y_size + (y_size - 1)) - 1;
            }
            if (targetY <= targetDimension.m_6042_().f_156647_() + 1) {
                targetY = targetDimension.m_6042_().f_156647_() + 2;
            }
            if (targetX >= 31999800) {
                targetX = 31999800;
            }
            if (targetX <= -31999800) {
                targetX = -31999800;
            }
            if (targetZ >= 31999800) {
                targetZ = 31999800;
            }
            if (targetZ <= -31999800) {
                targetZ = -31999800;
            }
            if (monitorBlockEntity != null) {
                monitorBlockEntity.data.m_8050_(0, targetX);
                monitorBlockEntity.data.m_8050_(1, targetY);
                monitorBlockEntity.data.m_8050_(2, targetZ);
                monitorBlockEntity.target_dimension = targetDimension.m_46472_().m_135782_().m_135815_();
                monitorBlockEntity.data.m_8050_(3, this.data.m_6413_(12));
                if (tardisEntity != null) {
                    if (!tardisEntity.isInFlight() || tardisEntity.isRemat()) {
                        monitorBlockEntity.current_dimension = tardisEntity.m_9236_().m_46472_().m_135782_().m_135815_();
                        monitorBlockEntity.data.m_8050_(6, tardisEntity.m_146903_());
                        monitorBlockEntity.data.m_8050_(7, tardisEntity.m_146904_());
                        monitorBlockEntity.data.m_8050_(8, tardisEntity.m_146907_());
                        monitorBlockEntity.data.m_8050_(9, (int)tardisEntity.m_146908_());
                    }
                } else {
                    monitorBlockEntity.current_dimension = currentDimension.m_46472_().m_135782_().m_135815_();
                    monitorBlockEntity.data.m_8050_(6, this.data.m_6413_(6));
                    monitorBlockEntity.data.m_8050_(7, this.data.m_6413_(7));
                    monitorBlockEntity.data.m_8050_(8, this.data.m_6413_(8));
                    monitorBlockEntity.data.m_8050_(9, 0);
                }
                monitorBlockEntity.data.m_8050_(11, this.energy.getEnergyStored());
            }
            if (this.energy.getEnergyStored() <= 0) {
                BlockPos currentPos;
                int x;
                boolean disabled_throttle = false;
                for (x = -size; x <= size; ++x) {
                    for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                        for (int z = -size; z <= size; ++z) {
                            currentPos = pPos.m_7918_(x, y, z);
                            BlockState blockState = pLevel.m_8055_(currentPos);
                            if (!(blockState.m_60734_() instanceof ThrottleBlock) || !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
                            disabled_throttle = true;
                            ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                            throttle_on = 0;
                        }
                    }
                }
                if (disabled_throttle) {
                    for (x = -size; x <= size; ++x) {
                        for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                            for (int z = -size; z <= size; ++z) {
                                currentPos = pPos.m_7918_(x, y, z);
                                Player player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                                if (player == null) continue;
                                player.m_5661_((Component)Component.m_237113_((String)"Out of energy, throttle has been disabled! Charge your TARDIS using FE or simply by waiting. Use the monitor to watch your energy levels.").m_130940_(ChatFormatting.RED), false);
                            }
                        }
                    }
                }
            }
            if (proto) {
                BlockPos exteriorPos = new BlockPos(this.data.m_6413_(6), this.data.m_6413_(7), this.data.m_6413_(8));
                BlockPos realTargetPos = new BlockPos(targetX, targetY, targetZ);
                double dematSeconds = 10.0;
                double minFlightSeconds = 15.0;
                BlockPos estimatePos = exteriorPos;
                int numEstJumps = 0;
                while (Math.sqrt(estimatePos.m_203198_((double)realTargetPos.m_123341_(), (double)estimatePos.m_123342_(), (double)realTargetPos.m_123343_())) > 250.0) {
                    ++numEstJumps;
                    estimatePos = this.findNewVortexPosition(estimatePos, realTargetPos);
                }
                int estTime = 5 * numEstJumps + 20;
                BlockPos remainingPos = pPos;
                int numRemJumps = 0;
                while (Math.sqrt(remainingPos.m_203198_((double)realTargetPos.m_123341_(), (double)remainingPos.m_123342_(), (double)realTargetPos.m_123343_())) > 250.0) {
                    ++numRemJumps;
                    remainingPos = this.findNewVortexPosition(remainingPos, realTargetPos);
                }
                int remTime = 5 * numRemJumps;
                if ((double)this.data.m_6413_(0) < (double)tickSpeed * minFlightSeconds + (double)this.data.m_6413_(1)) {
                    remTime = (int)((double)remTime + minFlightSeconds);
                }
                if (monitorBlockEntity != null) {
                    monitorBlockEntity.data.m_8050_(4, estTime);
                    monitorBlockEntity.data.m_8050_(10, estTime * tickSpeed);
                }
                this.data.m_8050_(20, remTime);
                if (throttle_on == 1) {
                    ChunkPos chunkPos;
                    this.energy.removeEnergy(1);
                    if (monitorBlockEntity != null) {
                        monitorBlockEntity.data.m_8050_(5, remTime);
                    }
                    this.data.m_8050_(21, 15);
                    if ((double)this.data.m_6413_(0) > (double)this.data.m_6413_(1) + dematSeconds * (double)tickSpeed && pLevel != vortexDimension) {
                        BlockPos vortexTargetPos = this.findNewVortexPosition(pPos, realTargetPos);
                        vortexTargetPos = new BlockPos(vortexTargetPos.m_123341_(), -100, vortexTargetPos.m_123343_());
                        this.data.m_8050_(1, this.data.m_6413_(0));
                        chunkPos = vortexDimension.m_46745_(vortexTargetPos).m_7697_();
                        ForgeChunkManager.forceChunk((ServerLevel)vortexDimension, (String)"vortexmod", (BlockPos)vortexTargetPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
                        this.handleVortexTeleports(size, overrideAABB, pLevel, pPos, vortexTargetPos);
                        chunkPos = currentDimension.m_46745_(pPos).m_7697_();
                        ForgeChunkManager.forceChunk((ServerLevel)vortexDimension, (String)"vortexmod", (BlockPos)pPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)false, (boolean)true);
                        vortexDimension.m_214150_(null, (double)vortexTargetPos.m_123341_(), (double)vortexTargetPos.m_123342_(), (double)vortexTargetPos.m_123343_(), (SoundEvent)ModSounds.FLIGHT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                    } else if (pLevel == vortexDimension && Math.sqrt(pPos.m_203198_((double)targetX, (double)pPos.m_123342_(), (double)targetZ)) <= 250.0 && (double)this.data.m_6413_(0) >= (double)tickSpeed * minFlightSeconds + (double)this.data.m_6413_(1)) {
                        BlockPos flight_target = new BlockPos(targetX, targetY, targetZ);
                        this.data.m_8050_(1, this.data.m_6413_(0));
                        this.data.m_8050_(11, 0);
                        chunkPos = targetDimension.m_46745_(flight_target).m_7697_();
                        ForgeChunkManager.forceChunk((ServerLevel)targetDimension, (String)"vortexmod", (BlockPos)flight_target, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
                        this.handleTeleports(size, overrideAABB, (Level)vortexDimension, targetDimension, pPos, flight_target);
                        chunkPos = currentDimension.m_46745_(pPos).m_7697_();
                        ForgeChunkManager.forceChunk((ServerLevel)currentDimension, (String)"vortexmod", (BlockPos)pPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)false, (boolean)true);
                        this.data.m_8050_(6, targetX);
                        this.data.m_8050_(7, targetY);
                        this.data.m_8050_(8, targetZ);
                        this.data.m_8050_(0, 0);
                    }
                    if (pLevel != vortexDimension) {
                        if (this.data.m_6413_(0) == this.data.m_6413_(1) + 1) {
                            pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DEMAT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                        }
                        this.handleDematParticles(size, overrideAABB, pLevel, pPos);
                    }
                    if (pLevel == vortexDimension && this.data.m_6413_(0) > 0) {
                        BlockPos newTarget;
                        if ((Math.sqrt(pPos.m_203198_((double)targetX, (double)pPos.m_123342_(), (double)targetZ)) <= 0.3 * Math.sqrt(exteriorPos.m_203198_((double)targetX, (double)exteriorPos.m_123342_(), (double)targetZ)) || Math.sqrt(pPos.m_203198_((double)targetX, (double)pPos.m_123342_(), (double)targetZ)) <= 250.0) && this.data.m_6413_(11) == 0) {
                            targetDimension.m_214150_(null, (double)targetX, (double)targetY, (double)targetZ, (SoundEvent)ModSounds.REMAT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                            this.data.m_8050_(11, 1);
                        }
                        if (this.data.m_6413_(0) % (4 * tickSpeed) == 0 && this.data.m_6413_(0) > this.data.m_6413_(1) + 4 * tickSpeed && Math.sqrt((newTarget = this.findNewVortexPosition(pPos, new BlockPos(targetX, targetY, targetZ))).m_203198_((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_())) > (double)size * 1.25) {
                            chunkPos = vortexDimension.m_46745_(newTarget).m_7697_();
                            ForgeChunkManager.forceChunk((ServerLevel)vortexDimension, (String)"vortexmod", (BlockPos)newTarget, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
                            this.handleVortex2VortexTeleports(size, overrideAABB, pLevel, pPos, newTarget);
                            ChunkPos newChunkPos = vortexDimension.m_46745_(pPos).m_7697_();
                            if (newChunkPos != chunkPos) {
                                ForgeChunkManager.forceChunk((ServerLevel)vortexDimension, (String)"vortexmod", (BlockPos)pPos, (int)newChunkPos.f_45578_, (int)newChunkPos.f_45579_, (boolean)false, (boolean)true);
                                vortexDimension.m_214150_(null, (double)newTarget.m_123341_(), (double)newTarget.m_123342_(), (double)newTarget.m_123343_(), (SoundEvent)ModSounds.FLIGHT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                            }
                        }
                        if (Math.sqrt(pPos.m_203198_((double)targetX, (double)pPos.m_123342_(), (double)targetZ)) <= 0.3 * Math.sqrt(exteriorPos.m_203198_((double)targetX, (double)exteriorPos.m_123342_(), (double)targetZ)) || Math.sqrt(pPos.m_203198_((double)targetX, (double)pPos.m_123342_(), (double)targetZ)) <= 250.0) {
                            this.handleRematParticles(size, overrideAABB, (Level)targetDimension, new BlockPos(targetX, targetY, targetZ));
                            if (this.data.m_6413_(0) % (4 * tickSpeed) == 0 && !has_equalizer) {
                                this.handleLightningStrikes((Level)targetDimension, new BlockPos(targetX, targetY, targetZ));
                            }
                        }
                        this.handleVortexParticles(size, (Level)vortexDimension, pPos, new BlockPos(targetX, targetY, targetZ));
                    }
                } else {
                    this.data.m_8050_(21, 0);
                    if (monitorBlockEntity != null) {
                        monitorBlockEntity.data.m_8050_(5, 0);
                    }
                    if (currentDimension.m_46472_().m_135782_().m_135815_().equals(vortexDimension.m_46472_().m_135782_().m_135815_())) {
                        if (this.data.m_6413_(0) % 2 == 0) {
                            this.energy.addEnergy(2);
                        }
                    } else if (this.data.m_6413_(0) % 2 == 0) {
                        this.energy.addEnergy(1);
                    }
                }
            } else if (tardisEntity != null) {
                double time_remaining;
                this.data.m_8050_(6, tardisEntity.m_146903_());
                this.data.m_8050_(7, tardisEntity.m_146904_());
                this.data.m_8050_(8, tardisEntity.m_146907_());
                if (throttle_on == 0) {
                    if (tardisEntity.isDemat()) {
                        tardisEntity.setDemat(false);
                        tardisEntity.setAlpha(1.0f);
                        tardisEntity.setAnimDescending(false);
                        tardisEntity.setAnimStage(0);
                    }
                    if (monitorBlockEntity != null) {
                        monitorBlockEntity.data.m_8050_(5, 0);
                    }
                }
                int rotation_yaw = this.data.m_6413_(12);
                BlockPos target = new BlockPos(targetX, targetY, targetZ);
                BlockPos exteriorPos = new BlockPos(this.data.m_6413_(6), this.data.m_6413_(7), this.data.m_6413_(8));
                int tick_step = 150;
                double intermediate_seconds = 1.8;
                if ((intermediate_seconds += Math.sqrt(exteriorPos.m_203198_((double)target.m_123341_(), (double)exteriorPos.m_123342_(), (double)target.m_123343_())) / (double)tick_step / (double)tickSpeed) > 180.0) {
                    intermediate_seconds = 180.0;
                }
                double demat_seconds = 10.0;
                double demat_time = (double)tickSpeed * demat_seconds;
                double ticks_to_travel = (intermediate_seconds + demat_seconds) * (double)tickSpeed;
                if (ticks_to_travel < 0.0) {
                    ticks_to_travel = 0.0;
                }
                if ((time_remaining = ((double)this.data.m_6413_(1) + ticks_to_travel - (double)this.data.m_6413_(0)) / (double)tickSpeed) < 0.0) {
                    time_remaining = 0.0;
                }
                if (monitorBlockEntity != null) {
                    monitorBlockEntity.data.m_8050_(4, (int)(ticks_to_travel / (double)tickSpeed));
                    monitorBlockEntity.data.m_8050_(10, (int)ticks_to_travel);
                }
                if (throttle_on == 1 && monitorBlockEntity != null) {
                    monitorBlockEntity.data.m_8050_(5, (int)time_remaining);
                }
                this.data.m_8050_(20, (int)time_remaining);
                if (throttle_on == 1) {
                    if ((double)this.data.m_6413_(0) >= (double)this.data.m_6413_(1) + ticks_to_travel) {
                        this.data.m_8050_(24, 1);
                    } else {
                        this.data.m_8050_(24, 0);
                    }
                    this.data.m_8050_(23, 0);
                    if (tardisEntity.isDemat()) {
                        this.data.m_8050_(21, 15);
                        this.energy.removeEnergy(1);
                        tardisEntity.setInFlight(false);
                        this.handleDematCenterParticles((Level)tardisDimension, pPos);
                        for (int x = -size; x <= size; ++x) {
                            for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                for (int z = -size; z <= size; ++z) {
                                    BlockPos currentPos = pPos.m_7918_(x, y, z);
                                    Player player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                                    if (player == null) continue;
                                    player.m_5661_((Component)Component.m_237113_((String)"Dematerializing").m_130940_(ChatFormatting.RED), true);
                                }
                            }
                        }
                    } else if (tardisEntity.isInFlight()) {
                        this.data.m_8050_(21, 15);
                        if ((double)this.data.m_6413_(0) >= (double)this.data.m_6413_(1) + ticks_to_travel) {
                            if (autoLand) {
                                for (int x = -size; x <= size; ++x) {
                                    for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                        for (int z = -size; z <= size; ++z) {
                                            BlockPos currentPos = pPos.m_7918_(x, y, z);
                                            BlockState blockState = pLevel.m_8055_(currentPos);
                                            if (!(blockState.m_60734_() instanceof ThrottleBlock) || !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
                                            ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                                        }
                                    }
                                }
                            }
                            if (this.data.m_6413_(0) % 2 == 0) {
                                this.energy.addEnergy(2);
                            }
                        } else {
                            this.energy.removeEnergy(1);
                        }
                        tardisEntity.m_20242_(true);
                        ChunkPos chunkPos = currentDimension.m_46745_(exteriorPos).m_7697_();
                        ForgeChunkManager.forceChunk((ServerLevel)currentDimension, (String)"vortexmod", (BlockPos)exteriorPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)false, (boolean)true);
                        tardisEntity.m_20324_(exteriorPos.m_123341_(), -128.0, exteriorPos.m_123343_());
                        if ((double)this.data.m_6413_(0) >= (double)this.data.m_6413_(1) + demat_time + 1.0 && (double)this.data.m_6413_(0) - ((double)this.data.m_6413_(1) + demat_time) > 0.0 && (double)this.data.m_6413_(0) >= (double)this.data.m_6413_(22) + (double)tickSpeed * 1.35) {
                            pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.EUC_FLIGHT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                            this.data.m_8050_(22, this.data.m_6413_(0));
                        }
                        for (int x = -size; x <= size; ++x) {
                            for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                for (int z = -size; z <= size; ++z) {
                                    BlockPos currentPos = pPos.m_7918_(x, y, z);
                                    Player player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                                    if (player == null) continue;
                                    if ((double)this.data.m_6413_(0) >= (double)this.data.m_6413_(1) + ticks_to_travel) {
                                        player.m_5661_((Component)Component.m_237113_((String)"Pull the throttle to land.").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)" (Shift click the throttle to toggle auto land)").m_130940_(ChatFormatting.GRAY)), true);
                                        continue;
                                    }
                                    player.m_5661_((Component)Component.m_237113_((String)"Flight time remaining: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%.2f", time_remaining)).m_130940_(ChatFormatting.GOLD)), true);
                                }
                            }
                        }
                        this.handleFlightCenterParticles((Level)tardisDimension, pPos);
                    } else if (!tardisEntity.isRemat()) {
                        this.data.m_8050_(1, this.data.m_6413_(0));
                        tardisEntity.setDemat(true);
                        currentDimension.m_214150_(null, (double)exteriorPos.m_123341_(), (double)exteriorPos.m_123342_(), (double)exteriorPos.m_123343_(), (SoundEvent)ModSounds.DEMAT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                        pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DEMAT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                    } else {
                        this.data.m_8050_(21, 15);
                        tardisEntity.setInFlight(false);
                        if (!has_equalizer && this.data.m_6413_(0) % 100 == 0) {
                            this.handleLightningStrikes((Level)targetDimension, new BlockPos(targetX, targetY, targetZ));
                        }
                        this.handleRematCenterParticles((Level)tardisDimension, pPos);
                        for (int x = -size; x <= size; ++x) {
                            for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                for (int z = -size; z <= size; ++z) {
                                    BlockPos currentPos = pPos.m_7918_(x, y, z);
                                    Player player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                                    if (player == null) continue;
                                    player.m_5661_((Component)Component.m_237113_((String)"Rematerializing").m_130940_(ChatFormatting.AQUA), true);
                                }
                            }
                        }
                    }
                } else {
                    if (currentDimension.m_46472_().m_135782_().m_135815_().equals(vortexDimension.m_46472_().m_135782_().m_135815_())) {
                        if (this.data.m_6413_(0) % 2 == 0) {
                            this.energy.addEnergy(2);
                        }
                    } else if (this.data.m_6413_(0) % 2 == 0) {
                        this.energy.addEnergy(1);
                    }
                    this.data.m_8050_(24, 0);
                    if (tardisEntity.isRemat() || tardisEntity.isInFlight()) {
                        this.data.m_8050_(21, 15);
                        tardisEntity.setInFlight(false);
                        if (!has_equalizer && this.data.m_6413_(0) % 100 == 0) {
                            this.handleLightningStrikes((Level)targetDimension, new BlockPos(targetX, targetY, targetZ));
                        }
                        this.handleRematCenterParticles((Level)tardisDimension, pPos);
                        for (int x = -size; x <= size; ++x) {
                            for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                for (int z = -size; z <= size; ++z) {
                                    BlockPos currentPos = pPos.m_7918_(x, y, z);
                                    Player player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                                    if (player == null) continue;
                                    player.m_5661_((Component)Component.m_237113_((String)"Rematerializing").m_130940_(ChatFormatting.AQUA), true);
                                }
                            }
                        }
                        if (this.data.m_6413_(11) == 0) {
                            this.data.m_8050_(11, 1);
                            tardisEntity.setRemat(true);
                            targetDimension.m_214150_(null, (double)targetX, (double)targetY, (double)targetZ, (SoundEvent)ModSounds.REMAT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                            pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.REMAT_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                            BlockPos flight_target = new BlockPos(targetX, targetY, targetZ);
                            if ((double)this.data.m_6413_(0) < (double)this.data.m_6413_(1) + ticks_to_travel) {
                                double dirX = target.m_123341_() - exteriorPos.m_123341_();
                                double dirZ = target.m_123343_() - exteriorPos.m_123343_();
                                double magnitude = Math.sqrt(dirX * dirX + dirZ * dirZ);
                                int x_distance = Math.abs(exteriorPos.m_123341_() - targetX);
                                int z_distance = Math.abs(exteriorPos.m_123343_() - targetZ);
                                double percentage_travelled = (double)(this.data.m_6413_(0) - this.data.m_6413_(1)) / ticks_to_travel;
                                int newX = exteriorPos.m_123341_() + (int)((dirX /= magnitude) * ((double)x_distance * percentage_travelled));
                                int newZ = exteriorPos.m_123343_() + (int)((dirZ /= magnitude) * ((double)z_distance * percentage_travelled));
                                flight_target = new BlockPos(newX, targetY, newZ);
                            }
                            tardisEntity.m_146922_(rotation_yaw);
                            tardisEntity.m_20242_(false);
                            tardisEntity.teleportToWithTicket(targetDimension, flight_target.m_123341_(), flight_target.m_123342_(), flight_target.m_123343_(), rotation_yaw, 0.0f);
                            if (!targetDimension.m_46472_().m_135782_().m_135815_().equals(currentDimension.m_46472_().m_135782_().m_135815_())) {
                                targetDimension.m_7967_((Entity)tardisEntity);
                            }
                            tardisEntity.m_8119_();
                            ChunkPos chunkPos = targetDimension.m_46745_(flight_target).m_7697_();
                            ForgeChunkManager.forceChunk((ServerLevel)targetDimension, (String)"vortexmod", (BlockPos)flight_target, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
                            for (int x = -size; x <= size; ++x) {
                                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                    for (int z = -size; z <= size; ++z) {
                                        BlockPos currentPos = pPos.m_7918_(x, y, z);
                                        BlockState blockState = pLevel.m_8055_(currentPos);
                                        if (!(blockState.m_60734_() instanceof ThrottleBlock) || !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
                                        ((ThrottleBlock)blockState.m_60734_()).pull(blockState, pLevel, currentPos);
                                    }
                                }
                            }
                        }
                    } else {
                        this.data.m_8050_(21, 0);
                        if (this.data.m_6413_(23) == 0) {
                            BlockPos flight_target = new BlockPos(targetX, targetY, targetZ);
                            VortexInterfaceBlockEntity.handleLandingEntities(targetDimension, tardisDimension, flight_target, this.getExtUUID());
                            this.data.m_8050_(6, targetX);
                            this.data.m_8050_(7, targetY);
                            this.data.m_8050_(8, targetZ);
                            this.data.m_8050_(9, targetDimension.m_46472_().m_135782_().m_135815_().hashCode());
                            this.data.m_8050_(0, 0);
                            this.data.m_8050_(22, 0);
                            this.data.m_8050_(11, 0);
                            this.data.m_8050_(23, 1);
                            for (int x = -size; x <= size; ++x) {
                                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                                    for (int z = -size; z <= size; ++z) {
                                        BlockPos currentPos = pPos.m_7918_(x, y, z);
                                        ServerPlayer player = (ServerPlayer)pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                                        if (player == null) continue;
                                        player.m_5661_((Component)Component.m_237113_((String)"TARDIS Landed at: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(exteriorPos.m_123341_() + " " + exteriorPos.m_123342_() + " " + exteriorPos.m_123343_()))), true);
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                this.data.m_8050_(0, this.data.m_6413_(0) - 1);
                BlockPos exteriorPos = new BlockPos(this.data.m_6413_(6), this.data.m_6413_(7), this.data.m_6413_(8));
                ChunkPos chunkPos = currentDimension.m_46745_(exteriorPos).m_7697_();
                ForgeChunkManager.forceChunk((ServerLevel)currentDimension, (String)"vortexmod", (BlockPos)exteriorPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
            }
            pLevel.m_6289_(pPos, this.m_58900_().m_60734_());
            VortexInterfaceBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void handleLandingEntities(ServerLevel serverLevel, ServerLevel pLevel, BlockPos target, UUID uuid) {
        Player player = serverLevel.m_45924_((double)target.m_123341_(), (double)target.m_123342_(), (double)target.m_123343_(), 1.0, false);
        if (player != null) {
            MinecraftServer minecraftserver = pLevel.m_7654_();
            ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
            LocationMapData data = LocationMapData.get(overworld);
            BlockPos blockTardisTarget = data.getDataMap().get(uuid.toString());
            Vec3 tardisTarget = new Vec3((double)blockTardisTarget.m_123341_() + 1.5, (double)blockTardisTarget.m_123342_(), (double)blockTardisTarget.m_123343_() + 0.5);
            boolean found_door = false;
            for (int x = -100; x <= 100 && !found_door; ++x) {
                for (int y = -1; y <= 100 && !found_door; ++y) {
                    for (int z = -100; z <= 100 && !found_door; ++z) {
                        BlockPos currentPos = blockTardisTarget.m_7918_(x, y, z);
                        BlockState blockState = pLevel.m_8055_(currentPos);
                        if (blockState.m_60734_() != ModBlocks.DOOR_BLOCK.get()) continue;
                        for (int direction = 0; direction < 4; ++direction) {
                            double z_offset;
                            double x_offset;
                            BlockPos newPos;
                            if (direction == 0) {
                                newPos = currentPos.m_122029_();
                                x_offset = 1.5;
                                z_offset = 0.5;
                            } else if (direction == 1) {
                                newPos = currentPos.m_122019_();
                                x_offset = 0.5;
                                z_offset = 1.5;
                            } else if (direction == 2) {
                                newPos = currentPos.m_122024_();
                                x_offset = -0.5;
                                z_offset = 0.5;
                            } else {
                                newPos = currentPos.m_122012_();
                                x_offset = 0.5;
                                z_offset = -0.5;
                            }
                            if (pLevel.m_8055_(newPos) != Blocks.f_50016_.m_49966_() || pLevel.m_8055_(newPos.m_7494_()) != Blocks.f_50016_.m_49966_()) continue;
                            tardisTarget = new Vec3((double)currentPos.m_123341_() + x_offset, (double)currentPos.m_123342_(), (double)currentPos.m_123343_() + z_offset);
                            break;
                        }
                        found_door = true;
                    }
                }
            }
            if (!found_door) {
                BlockPos doorTarget = new BlockPos((int)(tardisTarget.f_82479_ - 1.5), (int)tardisTarget.f_82480_, (int)(tardisTarget.f_82481_ - 0.5));
                serverLevel.m_46597_(doorTarget, ((Block)ModBlocks.DOOR_BLOCK.get()).m_49966_());
            }
            player.changeDimension(pLevel, (ITeleporter)new ModTeleporter(tardisTarget));
        }
        AABB searchBB = new AABB((double)(target.m_123341_() - 1), (double)(target.m_123342_() - 1), (double)(target.m_123343_() - 1), (double)(target.m_123341_() + 1), (double)(target.m_123342_() + 1), (double)(target.m_123343_() + 1));
        List nearbyEntities = serverLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
        for (Entity nearbyEntity : nearbyEntities) {
            if (nearbyEntity instanceof TardisEntity) continue;
            MinecraftServer minecraftserver = pLevel.m_7654_();
            ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
            LocationMapData data = LocationMapData.get(overworld);
            BlockPos blockTardisTarget = data.getDataMap().get(uuid.toString());
            Vec3 tardisTarget = new Vec3((double)blockTardisTarget.m_123341_() + 1.5, (double)blockTardisTarget.m_123342_(), (double)blockTardisTarget.m_123343_() + 0.5);
            boolean found_door = false;
            for (int x = -100; x <= 100 && !found_door; ++x) {
                for (int y = -1; y <= 100 && !found_door; ++y) {
                    for (int z = -100; z <= 100 && !found_door; ++z) {
                        BlockPos currentPos = blockTardisTarget.m_7918_(x, y, z);
                        BlockState blockState = pLevel.m_8055_(currentPos);
                        if (blockState.m_60734_() != ModBlocks.DOOR_BLOCK.get()) continue;
                        for (int direction = 0; direction < 4; ++direction) {
                            double z_offset;
                            double x_offset;
                            BlockPos newPos;
                            if (direction == 0) {
                                newPos = currentPos.m_122029_();
                                x_offset = 1.5;
                                z_offset = 0.5;
                            } else if (direction == 1) {
                                newPos = currentPos.m_122019_();
                                x_offset = 0.5;
                                z_offset = 1.5;
                            } else if (direction == 2) {
                                newPos = currentPos.m_122024_();
                                x_offset = -0.5;
                                z_offset = 0.5;
                            } else {
                                newPos = currentPos.m_122012_();
                                x_offset = 0.5;
                                z_offset = -0.5;
                            }
                            if (pLevel.m_8055_(newPos) != Blocks.f_50016_.m_49966_() || pLevel.m_8055_(newPos.m_7494_()) != Blocks.f_50016_.m_49966_()) continue;
                            tardisTarget = new Vec3((double)currentPos.m_123341_() + x_offset, (double)currentPos.m_123342_(), (double)currentPos.m_123343_() + z_offset);
                            break;
                        }
                        found_door = true;
                    }
                }
            }
            if (!found_door) {
                BlockPos doorTarget = new BlockPos((int)(tardisTarget.f_82479_ - 1.5), (int)tardisTarget.f_82480_, (int)(tardisTarget.f_82481_ - 0.5));
                serverLevel.m_46597_(doorTarget, ((Block)ModBlocks.DOOR_BLOCK.get()).m_49966_());
            }
            nearbyEntity.changeDimension(pLevel, (ITeleporter)new ModTeleporter(tardisTarget));
        }
    }

    public static void handleTardisPlacement(ServerLevel pLevel, BlockPos target, Integer rotationYaw) {
        Direction rotationDirection = rotationYaw >= 0 && rotationYaw < 90 ? Direction.NORTH : (rotationYaw >= 90 && rotationYaw < 180 ? Direction.EAST : (rotationYaw >= 180 && rotationYaw < 270 ? Direction.SOUTH : Direction.WEST));
        pLevel.m_46597_(target, (BlockState)((Block)ModBlocks.TARDIS_BLOCK.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotationDirection));
    }

    public static void handleTardisDeletion(ServerLevel pLevel, BlockPos target) {
        pLevel.m_46747_(target);
        pLevel.m_7471_(target, false);
    }

    public static void spawnFlightCenterCylinder(Connection pConnection, BlockPos center) {
        double radius = 0.25;
        int length = 6;
        int particleCount = (int)(5.0 * (radius + (double)length));
        Random random = new Random();
        double dx = 0.0;
        double dy = 1.0;
        double dz = 0.0;
        double rightX = 1.0;
        double rightY = 0.0;
        double rightZ = 0.0;
        double upX = 0.0;
        double upY = 0.0;
        double upZ = 1.0;
        for (int i = 0; i < particleCount; ++i) {
            double angleAroundRadius = random.nextDouble() * 2.0 * Math.PI;
            double normalizedLength = random.nextDouble() - 0.5;
            double x = radius * Math.cos(angleAroundRadius);
            double y = radius * Math.sin(angleAroundRadius);
            double z = (double)length * normalizedLength;
            double rotatedX = rightX * x + upX * y + dx * z;
            double rotatedY = rightY * x + upY * y + dy * z;
            double rotatedZ = rightZ * x + upZ * y + dz * z;
            rotatedX += (double)center.m_123341_() + 0.5;
            rotatedY += (double)center.m_123342_();
            rotatedZ += (double)center.m_123343_() + 0.5;
            float randomFloat = random.nextFloat();
            SimpleParticleType particle = ParticleTypes.f_175827_;
            if ((double)randomFloat > 0.33 && (double)randomFloat <= 0.95) {
                particle = ParticleTypes.f_123796_;
            } else if ((double)randomFloat > 0.95) {
                particle = ParticleTypes.f_123756_;
            }
            float xVel = 0.0f;
            float yVel = -1.0f;
            float zVel = 0.0f;
            ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, rotatedX, rotatedY + (double)((float)length / 2.0f), rotatedZ, xVel, yVel, zVel, 0.025f, 1);
            if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
            pConnection.m_129512_((Packet)particlesPacket);
        }
    }

    public static void spawnRematCenterCylinder(Connection pConnection, BlockPos center) {
        double radius = 0.25;
        int length = 6;
        int particleCount = (int)(5.0 * (radius + (double)length));
        Random random = new Random();
        double dx = 0.0;
        double dy = 1.0;
        double dz = 0.0;
        double rightX = 1.0;
        double rightY = 0.0;
        double rightZ = 0.0;
        double upX = 0.0;
        double upY = 0.0;
        double upZ = 1.0;
        for (int i = 0; i < particleCount; ++i) {
            double angleAroundRadius = random.nextDouble() * 2.0 * Math.PI;
            double normalizedLength = random.nextDouble() - 0.5;
            double x = radius * Math.cos(angleAroundRadius);
            double y = radius * Math.sin(angleAroundRadius);
            double z = (double)length * normalizedLength;
            double rotatedX = rightX * x + upX * y + dx * z;
            double rotatedY = rightY * x + upY * y + dy * z;
            double rotatedZ = rightZ * x + upZ * y + dz * z;
            rotatedX += (double)center.m_123341_() + 0.5;
            rotatedY += (double)center.m_123342_();
            rotatedZ += (double)center.m_123343_() + 0.5;
            float randomFloat = random.nextFloat();
            SimpleParticleType particle = ParticleTypes.f_175830_;
            if ((double)randomFloat > 0.33 && (double)randomFloat <= 0.66) {
                particle = ParticleTypes.f_123796_;
            } else if ((double)randomFloat > 0.66) {
                particle = ParticleTypes.f_123799_;
            }
            float xVel = 0.0f;
            float yVel = -1.0f;
            float zVel = 0.0f;
            ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, rotatedX, rotatedY + (double)((float)length / 2.0f), rotatedZ, xVel, yVel, zVel, 0.025f, 1);
            if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
            pConnection.m_129512_((Packet)particlesPacket);
        }
    }

    public static void spawnDematCenterCylinder(Connection pConnection, BlockPos center) {
        double radius = 0.25;
        int length = 6;
        int particleCount = (int)(5.0 * (radius + (double)length));
        Random random = new Random();
        double dx = 0.0;
        double dy = 1.0;
        double dz = 0.0;
        double rightX = 1.0;
        double rightY = 0.0;
        double rightZ = 0.0;
        double upX = 0.0;
        double upY = 0.0;
        double upZ = 1.0;
        for (int i = 0; i < particleCount; ++i) {
            double angleAroundRadius = random.nextDouble() * 2.0 * Math.PI;
            double normalizedLength = random.nextDouble() - 0.5;
            double x = radius * Math.cos(angleAroundRadius);
            double y = radius * Math.sin(angleAroundRadius);
            double z = (double)length * normalizedLength;
            double rotatedX = rightX * x + upX * y + dx * z;
            double rotatedY = rightY * x + upY * y + dy * z;
            double rotatedZ = rightZ * x + upZ * y + dz * z;
            rotatedX += (double)center.m_123341_() + 0.5;
            rotatedY += (double)center.m_123342_();
            rotatedZ += (double)center.m_123343_() + 0.5;
            float randomFloat = random.nextFloat();
            SimpleParticleType particle = ParticleTypes.f_175830_;
            if ((double)randomFloat > 0.33 && (double)randomFloat <= 0.66) {
                particle = ParticleTypes.f_123796_;
            } else if ((double)randomFloat > 0.66) {
                particle = ParticleTypes.f_123799_;
            }
            float xVel = 0.0f;
            float yVel = -1.0f;
            float zVel = 0.0f;
            ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, rotatedX, rotatedY + (double)((float)length / 2.0f), rotatedZ, xVel, yVel, zVel, 0.025f, 1);
            if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
            pConnection.m_129512_((Packet)particlesPacket);
        }
    }

    public static void spawnDematSquare(Connection pConnection, BlockPos center, double radius, AABB overrideAABB) {
        radius += 1.0;
        double y_radius = 10.0;
        if (radius < 10.0) {
            y_radius = radius;
        }
        int particleCount = (int)(100.0 * radius);
        Random random = new Random();
        if (overrideAABB == null) {
            int particlesPerEdge = (int)Math.pow(particleCount, 0.5);
            for (int face = 0; face < 6; ++face) {
                for (int i = 0; i < particlesPerEdge; ++i) {
                    for (int j = 0; j < particlesPerEdge; ++j) {
                        double normalizedI = (double)i / (double)(particlesPerEdge - 1);
                        double normalizedJ = (double)j / (double)(particlesPerEdge - 1);
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        switch (face) {
                            case 0: {
                                x = normalizedI * 2.0 - 1.0;
                                y = 1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 1: {
                                x = normalizedI * 2.0 - 1.0;
                                y = -1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 2: {
                                x = 1.0;
                                y = normalizedI * 2.0 - 1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 3: {
                                x = -1.0;
                                y = normalizedI * 2.0 - 1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 4: {
                                x = normalizedI * 2.0 - 1.0;
                                y = normalizedJ * 2.0 - 1.0;
                                z = 1.0;
                                break;
                            }
                            case 5: {
                                x = normalizedI * 2.0 - 1.0;
                                y = normalizedJ * 2.0 - 1.0;
                                z = -1.0;
                            }
                        }
                        float randomFloat = random.nextFloat();
                        SimpleParticleType particle = ParticleTypes.f_123809_;
                        if ((double)randomFloat > 0.33 && (double)randomFloat < 0.66) {
                            particle = ParticleTypes.f_123799_;
                        } else if ((double)randomFloat > 0.66) {
                            particle = ParticleTypes.f_175827_;
                        }
                        int xVel = 0;
                        int yVel = 0;
                        int zVel = 0;
                        switch (face) {
                            case 0: 
                            case 1: {
                                xVel = random.nextInt(3) - 1;
                                zVel = random.nextInt(3) - 1;
                                yVel = 0;
                                break;
                            }
                            case 2: 
                            case 3: {
                                yVel = random.nextInt(3) - 1;
                                zVel = random.nextInt(3) - 1;
                                xVel = 0;
                                break;
                            }
                            case 4: 
                            case 5: {
                                yVel = random.nextInt(3) - 1;
                                xVel = random.nextInt(3) - 1;
                                zVel = 0;
                            }
                        }
                        double newX = (double)center.m_123341_() + radius * x;
                        double newY = (double)(center.m_123342_() - 1) + (y_radius + 2.0) * y;
                        double newZ = (double)center.m_123343_() + radius * z;
                        if (newY < (double)(center.m_123342_() - 1)) {
                            newY = center.m_123342_() - 1;
                        }
                        ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, newX + 0.5, newY, newZ + 0.5, (float)xVel, (float)yVel, (float)zVel, 0.0f, 1);
                        if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
                        pConnection.m_129512_((Packet)particlesPacket);
                    }
                }
            }
        } else {
            BlockPos corner1 = new BlockPos(center.m_123341_() + (int)overrideAABB.f_82288_, center.m_123342_() + (int)overrideAABB.f_82289_, center.m_123343_() + (int)overrideAABB.f_82290_);
            BlockPos corner2 = new BlockPos(center.m_123341_() + (int)overrideAABB.f_82291_, center.m_123342_() + (int)overrideAABB.f_82292_, center.m_123343_() + (int)overrideAABB.f_82293_);
            int xLength = Math.abs(corner1.m_123341_() - corner2.m_123341_());
            int yLength = Math.abs(corner1.m_123342_() - corner2.m_123342_());
            int zLength = Math.abs(corner1.m_123343_() - corner2.m_123343_());
            BlockPos minCorner = new BlockPos(Math.min(corner1.m_123341_(), corner2.m_123341_()), Math.min(corner1.m_123342_(), corner2.m_123342_()), Math.min(corner1.m_123343_(), corner2.m_123343_()));
            for (int x = 0; x <= xLength + 1; ++x) {
                for (int y = 0; y <= yLength + 1; ++y) {
                    for (int z = 0; z <= zLength + 1; ++z) {
                        if (x != 0 && x != xLength + 1 && y != 0 && y != yLength + 1 && z != 0 && z != zLength + 1) continue;
                        float randomFloat = random.nextFloat();
                        SimpleParticleType particle = ParticleTypes.f_123809_;
                        if ((double)randomFloat > 0.33 && (double)randomFloat < 0.66) {
                            particle = ParticleTypes.f_123799_;
                        } else if ((double)randomFloat > 0.66) {
                            particle = ParticleTypes.f_175827_;
                        }
                        int xVel = 0;
                        int yVel = 0;
                        int zVel = 0;
                        if (y == yLength) {
                            xVel = random.nextInt(3) - 1;
                            zVel = random.nextInt(3) - 1;
                            yVel = 0;
                        } else if (y != 0 && x != 0) {
                            if (x == xLength) {
                                yVel = random.nextInt(3) - 1;
                                zVel = random.nextInt(3) - 1;
                                xVel = 0;
                            } else if (z == 0) {
                                yVel = random.nextInt(3) - 1;
                                xVel = random.nextInt(3) - 1;
                                zVel = 0;
                            } else if (z == zLength) {
                                // empty if block
                            }
                        }
                        ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, (double)(minCorner.m_123341_() + x), (double)(minCorner.m_123342_() + y), (double)(minCorner.m_123343_() + z), (float)xVel, (float)yVel, (float)zVel, 0.0f, 1);
                        if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
                        pConnection.m_129512_((Packet)particlesPacket);
                    }
                }
            }
        }
    }

    public static void spawnRematSquare(Connection pConnection, BlockPos center, double radius, AABB overrideAABB) {
        radius += 1.0;
        double y_radius = 10.0;
        if (radius < 10.0) {
            y_radius = radius;
        }
        y_radius += y_radius - 1.0;
        int particleCount = (int)(100.0 * radius);
        Random random = new Random();
        if (overrideAABB == null) {
            int particlesPerEdge = (int)Math.pow(particleCount, 0.5);
            for (int face = 0; face < 6; ++face) {
                for (int i = 0; i < particlesPerEdge; ++i) {
                    for (int j = 0; j < particlesPerEdge; ++j) {
                        double normalizedI = (double)i / (double)(particlesPerEdge - 1);
                        double normalizedJ = (double)j / (double)(particlesPerEdge - 1);
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        switch (face) {
                            case 0: {
                                x = normalizedI * 2.0 - 1.0;
                                y = 1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 1: {
                                x = normalizedI * 2.0 - 1.0;
                                y = -1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 2: {
                                x = 1.0;
                                y = normalizedI * 2.0 - 1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 3: {
                                x = -1.0;
                                y = normalizedI * 2.0 - 1.0;
                                z = normalizedJ * 2.0 - 1.0;
                                break;
                            }
                            case 4: {
                                x = normalizedI * 2.0 - 1.0;
                                y = normalizedJ * 2.0 - 1.0;
                                z = 1.0;
                                break;
                            }
                            case 5: {
                                x = normalizedI * 2.0 - 1.0;
                                y = normalizedJ * 2.0 - 1.0;
                                z = -1.0;
                            }
                        }
                        float randomFloat = random.nextFloat();
                        SimpleParticleType particle = ParticleTypes.f_123809_;
                        if ((double)randomFloat > 0.5) {
                            particle = ParticleTypes.f_276452_;
                        }
                        int xVel = 0;
                        int yVel = 0;
                        int zVel = 0;
                        switch (face) {
                            case 0: 
                            case 1: {
                                xVel = random.nextInt(3) - 1;
                                zVel = random.nextInt(3) - 1;
                                break;
                            }
                            case 2: 
                            case 3: {
                                yVel = random.nextInt(3) - 1;
                                zVel = random.nextInt(3) - 1;
                                break;
                            }
                            case 4: 
                            case 5: {
                                yVel = random.nextInt(3) - 1;
                                xVel = random.nextInt(3) - 1;
                            }
                        }
                        double newX = (double)center.m_123341_() + radius * x;
                        double newY = (double)(center.m_123342_() - 1) + (y_radius + 2.0) * y;
                        double newZ = (double)center.m_123343_() + radius * z;
                        if (newY < (double)(center.m_123342_() - 1)) {
                            newY = center.m_123342_() - 1;
                        }
                        ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, newX + 0.5, newY, newZ + 0.5, (float)xVel, (float)yVel, (float)zVel, 0.0f, 1);
                        if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
                        pConnection.m_129512_((Packet)particlesPacket);
                    }
                }
            }
        } else {
            BlockPos corner1 = new BlockPos(center.m_123341_() + (int)overrideAABB.f_82288_, center.m_123342_() + (int)overrideAABB.f_82289_, center.m_123343_() + (int)overrideAABB.f_82290_);
            BlockPos corner2 = new BlockPos(center.m_123341_() + (int)overrideAABB.f_82291_, center.m_123342_() + (int)overrideAABB.f_82292_, center.m_123343_() + (int)overrideAABB.f_82293_);
            int xLength = Math.abs(corner1.m_123341_() - corner2.m_123341_());
            int yLength = Math.abs(corner1.m_123342_() - corner2.m_123342_());
            int zLength = Math.abs(corner1.m_123343_() - corner2.m_123343_());
            BlockPos minCorner = new BlockPos(Math.min(corner1.m_123341_(), corner2.m_123341_()), Math.min(corner1.m_123342_(), corner2.m_123342_()), Math.min(corner1.m_123343_(), corner2.m_123343_()));
            for (int x = 0; x <= xLength + 1; ++x) {
                for (int y = 0; y <= yLength + 1; ++y) {
                    for (int z = 0; z <= zLength + 1; ++z) {
                        if (x != 0 && x != xLength + 1 && y != 0 && y != yLength + 1 && z != 0 && z != zLength + 1) continue;
                        float randomFloat = random.nextFloat();
                        SimpleParticleType particle = ParticleTypes.f_123809_;
                        if ((double)randomFloat > 0.5) {
                            particle = ParticleTypes.f_276452_;
                        }
                        int xVel = 0;
                        int yVel = 0;
                        int zVel = 0;
                        if (y == yLength) {
                            xVel = random.nextInt(3) - 1;
                            zVel = random.nextInt(3) - 1;
                            yVel = 0;
                        } else if (y == 0) {
                            xVel = random.nextInt(3) - 1;
                            zVel = random.nextInt(3) - 1;
                            yVel = 0;
                        } else if (x == 0) {
                            yVel = random.nextInt(3) - 1;
                            zVel = random.nextInt(3) - 1;
                            xVel = 0;
                        } else if (x == xLength) {
                            yVel = random.nextInt(3) - 1;
                            zVel = random.nextInt(3) - 1;
                            xVel = 0;
                        } else if (z == 0) {
                            yVel = random.nextInt(3) - 1;
                            xVel = random.nextInt(3) - 1;
                            zVel = 0;
                        } else if (z == zLength) {
                            yVel = random.nextInt(3) - 1;
                            xVel = random.nextInt(3) - 1;
                            zVel = 0;
                        }
                        ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, (double)(minCorner.m_123341_() + x), (double)(minCorner.m_123342_() + y), (double)(minCorner.m_123343_() + z), (float)xVel, (float)yVel, (float)zVel, 0.0f, 1);
                        if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
                        pConnection.m_129512_((Packet)particlesPacket);
                    }
                }
            }
        }
    }

    public static void spawnVortexCylinder(Connection pConnection, BlockPos center, BlockPos targetPosition, double radius, double length) {
        int particleCount = (int)(25.0 * ((radius += 6.0) + length));
        Random random = new Random();
        double dx = targetPosition.m_123341_() - center.m_123341_();
        double dy = targetPosition.m_123342_() - center.m_123342_();
        double dz = targetPosition.m_123343_() - center.m_123343_();
        double magnitude = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double upX = 0.0;
        double upY = 1.0;
        double upZ = 0.0;
        double rightX = (dy /= magnitude) * upZ - (dz /= magnitude) * upY;
        double rightY = dz * upX - (dx /= magnitude) * upZ;
        double rightZ = dx * upY - dy * upX;
        upX = rightY * dz - rightZ * dy;
        upY = rightZ * dx - rightX * dz;
        upZ = rightX * dy - rightY * dx;
        for (int i = 0; i < particleCount; ++i) {
            double angleAroundRadius = random.nextDouble() * 2.0 * Math.PI;
            double normalizedLength = random.nextDouble() - 0.5;
            double x = radius * Math.cos(angleAroundRadius);
            double y = radius * Math.sin(angleAroundRadius);
            double z = length * normalizedLength;
            double rotatedX = rightX * x + upX * y + dx * z;
            double rotatedY = rightY * x + upY * y + dy * z;
            double rotatedZ = rightZ * x + upZ * y + dz * z;
            rotatedX += (double)center.m_123341_();
            rotatedY += (double)center.m_123342_();
            rotatedZ += (double)center.m_123343_();
            float randomFloat = random.nextFloat();
            SimpleParticleType particle = ParticleTypes.f_175826_;
            if ((double)randomFloat > 0.1 && (double)randomFloat <= 0.4) {
                particle = ParticleTypes.f_123776_;
            } else if ((double)randomFloat > 0.4) {
                particle = ParticleTypes.f_123799_;
            }
            double spiralSpeed = 1.0;
            float xVel = (float)(-spiralSpeed * Math.sin(angleAroundRadius));
            float yVel = (float)(spiralSpeed * Math.cos(angleAroundRadius));
            float zVel = -1.0f;
            ClientboundLevelParticlesPacket particlesPacket = new ClientboundLevelParticlesPacket((ParticleOptions)particle, false, rotatedX, rotatedY, rotatedZ, xVel, yVel, zVel, 0.025f, 1);
            if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
            pConnection.m_129512_((Packet)particlesPacket);
        }
    }

    private BlockPos findNewVortexPosition(BlockPos pPos, BlockPos currentTarget) {
        double dirX = currentTarget.m_123341_() - pPos.m_123341_();
        double dirZ = currentTarget.m_123343_() - pPos.m_123343_();
        double magnitude = Math.sqrt(dirX * dirX + dirZ * dirZ);
        double total_distance = Math.sqrt(pPos.m_203198_((double)currentTarget.m_123341_(), (double)pPos.m_123342_(), (double)currentTarget.m_123343_()));
        double distance = 0.5 * total_distance;
        int newX = pPos.m_123341_() + (int)((dirX /= magnitude) * distance);
        int newZ = pPos.m_123343_() + (int)((dirZ /= magnitude) * distance);
        if (dirX > 0.0 && newX > currentTarget.m_123341_() || dirX < 0.0 && newX < currentTarget.m_123341_()) {
            newX = currentTarget.m_123341_();
        }
        if (dirZ > 0.0 && newZ > currentTarget.m_123343_() || dirZ < 0.0 && newZ < currentTarget.m_123343_()) {
            newZ = currentTarget.m_123343_();
        }
        return new BlockPos(newX, pPos.m_123342_(), newZ);
    }

    private void handleLightningStrikes(Level pLevel, BlockPos targetPosition) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            ClientboundAddEntityPacket entityPacket = new ClientboundAddEntityPacket((Entity)new LightningBolt(EntityType.f_20465_, pLevel), 0, targetPosition);
            if (!pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
            pConnection.m_129512_((Packet)entityPacket);
        }
    }

    private void handleFlightCenterParticles(Level pLevel, BlockPos pPos) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            VortexInterfaceBlockEntity.spawnFlightCenterCylinder(pConnection, pPos);
        }
    }

    private void handleRematCenterParticles(Level pLevel, BlockPos pPos) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            VortexInterfaceBlockEntity.spawnRematCenterCylinder(pConnection, pPos);
        }
    }

    private void handleDematCenterParticles(Level pLevel, BlockPos pPos) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            VortexInterfaceBlockEntity.spawnDematCenterCylinder(pConnection, pPos);
        }
    }

    private void handleVortexParticles(int size, Level pLevel, BlockPos pPos, BlockPos targetPosition) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            VortexInterfaceBlockEntity.spawnVortexCylinder(pConnection, pPos, targetPosition, size, 100.0);
        }
    }

    private void handleDematParticles(int size, AABB overrideAABB, Level pLevel, BlockPos pPos) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            VortexInterfaceBlockEntity.spawnDematSquare(pConnection, pPos, size, overrideAABB);
        }
    }

    private void handleRematParticles(int size, AABB overrideAABB, Level pLevel, BlockPos pPos) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            if (!pConnection.m_129536_()) continue;
            VortexInterfaceBlockEntity.spawnRematSquare(pConnection, pPos, size, overrideAABB);
        }
    }

    private void handleVortex2VortexTeleports(int size, AABB overrideAABB, Level pLevel, BlockPos pPos, BlockPos vortexTargetPos) {
        int y_size = 5;
        if (size < 5) {
            y_size = size;
        }
        ArrayList<TeleportationDetails> toBeTeleported = new ArrayList<TeleportationDetails>();
        ArrayList<BlockPos> toBeRemoved = new ArrayList<BlockPos>();
        if (overrideAABB == null) {
            for (int x = -size; x <= size; ++x) {
                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                    for (z = -size; z <= size; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (currentPos == pPos) {
                            this.handleBlockTeleportVortex2Vortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                            continue;
                        }
                        player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                        if (player != null) {
                            details = new TeleportationDetails((Entity)player, vortexTargetPos, player.m_20182_().m_7096_() - (double)pPos.m_123341_(), player.m_20182_().m_7098_() - (double)pPos.m_123342_(), player.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        searchBB = new AABB((double)(currentPos.m_123341_() - 1), (double)(currentPos.m_123342_() - 1), (double)(currentPos.m_123343_() - 1), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1));
                        nearbyEntities = pLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                        for (Entity nearbyEntity : nearbyEntities) {
                            details = new TeleportationDetails(nearbyEntity, vortexTargetPos, nearbyEntity.m_20182_().m_7096_() - (double)pPos.m_123341_(), nearbyEntity.m_20182_().m_7098_() - (double)pPos.m_123342_(), nearbyEntity.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        this.handleBlockTeleportVortex2Vortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                    }
                }
            }
            for (TeleportationDetails tpDetails : toBeTeleported) {
                this.handlePlayerTeleportVortex2Vortex(tpDetails.player, tpDetails.targetPos, tpDetails.x, tpDetails.y, tpDetails.z);
            }
            for (x = -size; x <= size; ++x) {
                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                    for (z = -size; z <= size; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                            this.handleBlockRemoval(pLevel, currentPos);
                            continue;
                        }
                        if (currentPos == pPos) continue;
                        toBeRemoved.add(currentPos);
                    }
                }
            }
        } else {
            for (int x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                    for (z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (currentPos == pPos) {
                            this.handleBlockTeleportVortex2Vortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                            continue;
                        }
                        player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                        if (player != null) {
                            details = new TeleportationDetails((Entity)player, vortexTargetPos, player.m_20182_().m_7096_() - (double)pPos.m_123341_(), player.m_20182_().m_7098_() - (double)pPos.m_123342_(), player.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        searchBB = new AABB((double)(currentPos.m_123341_() - 1), (double)(currentPos.m_123342_() - 1), (double)(currentPos.m_123343_() - 1), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1));
                        nearbyEntities = pLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                        for (Entity nearbyEntity : nearbyEntities) {
                            details = new TeleportationDetails(nearbyEntity, vortexTargetPos, nearbyEntity.m_20182_().m_7096_() - (double)pPos.m_123341_(), nearbyEntity.m_20182_().m_7098_() - (double)pPos.m_123342_(), nearbyEntity.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        this.handleBlockTeleportVortex2Vortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                    }
                }
            }
            for (TeleportationDetails tpDetails : toBeTeleported) {
                this.handlePlayerTeleportVortex2Vortex(tpDetails.player, tpDetails.targetPos, tpDetails.x, tpDetails.y, tpDetails.z);
            }
            for (x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                    for (z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                            this.handleBlockRemoval(pLevel, currentPos);
                            continue;
                        }
                        if (currentPos == pPos) continue;
                        toBeRemoved.add(currentPos);
                    }
                }
            }
        }
        for (BlockPos positionToBeRemoved : toBeRemoved) {
            this.handleBlockRemoval(pLevel, positionToBeRemoved);
        }
        this.handleBlockRemoval(pLevel, pPos);
    }

    private void handleVortexTeleports(int size, AABB overrideAABB, Level pLevel, BlockPos pPos, BlockPos vortexTargetPos) {
        int y_size = 5;
        if (size < 5) {
            y_size = size;
        }
        ArrayList<TeleportationDetails> toBeTeleported = new ArrayList<TeleportationDetails>();
        ArrayList<BlockPos> toBeRemoved = new ArrayList<BlockPos>();
        if (overrideAABB == null) {
            for (int x = -size; x <= size; ++x) {
                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                    for (z = -size; z <= size; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (currentPos == pPos) {
                            this.handleBlockTeleportVortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                            continue;
                        }
                        player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                        if (player != null) {
                            details = new TeleportationDetails((Entity)player, vortexTargetPos, player.m_20182_().m_7096_() - (double)pPos.m_123341_(), player.m_20182_().m_7098_() - (double)pPos.m_123342_(), player.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        searchBB = new AABB((double)(currentPos.m_123341_() - 1), (double)(currentPos.m_123342_() - 1), (double)(currentPos.m_123343_() - 1), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1));
                        nearbyEntities = pLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                        for (Entity nearbyEntity : nearbyEntities) {
                            details = new TeleportationDetails(nearbyEntity, vortexTargetPos, nearbyEntity.m_20182_().m_7096_() - (double)pPos.m_123341_(), nearbyEntity.m_20182_().m_7098_() - (double)pPos.m_123342_(), nearbyEntity.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        this.handleBlockTeleportVortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                    }
                }
            }
            for (TeleportationDetails tpDetails : toBeTeleported) {
                this.handlePlayerTeleportVortex(tpDetails.player, tpDetails.targetPos, tpDetails.x, tpDetails.y, tpDetails.z);
            }
            for (x = -size; x <= size; ++x) {
                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                    for (z = -size; z <= size; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                            this.handleBlockRemoval(pLevel, currentPos);
                            continue;
                        }
                        if (currentPos == pPos) continue;
                        toBeRemoved.add(currentPos);
                    }
                }
            }
        } else {
            for (int x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                    for (z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (currentPos == pPos) {
                            this.handleBlockTeleportVortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                            continue;
                        }
                        player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                        if (player != null) {
                            details = new TeleportationDetails((Entity)player, vortexTargetPos, player.m_20182_().m_7096_() - (double)pPos.m_123341_(), player.m_20182_().m_7098_() - (double)pPos.m_123342_(), player.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        searchBB = new AABB((double)(currentPos.m_123341_() - 1), (double)(currentPos.m_123342_() - 1), (double)(currentPos.m_123343_() - 1), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1));
                        nearbyEntities = pLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                        for (Entity nearbyEntity : nearbyEntities) {
                            details = new TeleportationDetails(nearbyEntity, vortexTargetPos, nearbyEntity.m_20182_().m_7096_() - (double)pPos.m_123341_(), nearbyEntity.m_20182_().m_7098_() - (double)pPos.m_123342_(), nearbyEntity.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        this.handleBlockTeleportVortex(pLevel, currentPos, vortexTargetPos, x, y, z);
                    }
                }
            }
            for (TeleportationDetails tpDetails : toBeTeleported) {
                this.handlePlayerTeleportVortex(tpDetails.player, tpDetails.targetPos, tpDetails.x, tpDetails.y, tpDetails.z);
            }
            for (x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                    for (z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                            this.handleBlockRemoval(pLevel, currentPos);
                            continue;
                        }
                        if (currentPos == pPos) continue;
                        toBeRemoved.add(currentPos);
                    }
                }
            }
        }
        for (BlockPos positionToBeRemoved : toBeRemoved) {
            this.handleBlockRemoval(pLevel, positionToBeRemoved);
        }
        this.handleBlockRemoval(pLevel, pPos);
    }

    private void handleTeleports(int size, AABB overrideAABB, Level pLevel, ServerLevel targetDimension, BlockPos pPos, BlockPos targetPos) {
        int y_size = 5;
        if (size < 5) {
            y_size = size;
        }
        ArrayList<TeleportationDetails> toBeTeleported = new ArrayList<TeleportationDetails>();
        ArrayList<BlockPos> toBeRemoved = new ArrayList<BlockPos>();
        if (overrideAABB == null) {
            for (int x = -size; x <= size; ++x) {
                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                    for (z = -size; z <= size; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                        if (player != null) {
                            details = new TeleportationDetails((Entity)player, targetPos, player.m_20182_().m_7096_() - (double)pPos.m_123341_(), player.m_20182_().m_7098_() - (double)pPos.m_123342_(), player.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        searchBB = new AABB((double)(currentPos.m_123341_() - 1), (double)(currentPos.m_123342_() - 1), (double)(currentPos.m_123343_() - 1), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1));
                        nearbyEntities = pLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                        for (Entity nearbyEntity : nearbyEntities) {
                            details = new TeleportationDetails(nearbyEntity, targetPos, nearbyEntity.m_20182_().m_7096_() - (double)pPos.m_123341_(), nearbyEntity.m_20182_().m_7098_() - (double)pPos.m_123342_(), nearbyEntity.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        this.handleBlockTeleport(pLevel, currentPos, targetPos, x, y, z, targetDimension);
                    }
                }
            }
            for (TeleportationDetails tpDetails : toBeTeleported) {
                this.handlePlayerTeleport(tpDetails.player, tpDetails.targetPos, tpDetails.x, tpDetails.y, tpDetails.z, targetDimension);
            }
            for (x = -size; x <= size; ++x) {
                for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                    for (z = -size; z <= size; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                            this.handleBlockRemoval(pLevel, currentPos);
                            continue;
                        }
                        if (currentPos == pPos) continue;
                        toBeRemoved.add(currentPos);
                    }
                }
            }
        } else {
            for (int x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                    for (z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        player = pLevel.m_45924_((double)currentPos.m_123341_(), (double)currentPos.m_123342_(), (double)currentPos.m_123343_(), 1.0, false);
                        if (player != null) {
                            details = new TeleportationDetails((Entity)player, targetPos, player.m_20182_().m_7096_() - (double)pPos.m_123341_(), player.m_20182_().m_7098_() - (double)pPos.m_123342_(), player.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        searchBB = new AABB((double)(currentPos.m_123341_() - 1), (double)(currentPos.m_123342_() - 1), (double)(currentPos.m_123343_() - 1), (double)(currentPos.m_123341_() + 1), (double)(currentPos.m_123342_() + 1), (double)(currentPos.m_123343_() + 1));
                        nearbyEntities = pLevel.m_6443_(Entity.class, searchBB, entity -> !(entity instanceof Player));
                        for (Entity nearbyEntity : nearbyEntities) {
                            details = new TeleportationDetails(nearbyEntity, targetPos, nearbyEntity.m_20182_().m_7096_() - (double)pPos.m_123341_(), nearbyEntity.m_20182_().m_7098_() - (double)pPos.m_123342_(), nearbyEntity.m_20182_().m_7094_() - (double)pPos.m_123343_());
                            toBeTeleported.add(details);
                        }
                        this.handleBlockTeleport(pLevel, currentPos, targetPos, x, y, z, targetDimension);
                    }
                }
            }
            for (TeleportationDetails tpDetails : toBeTeleported) {
                this.handlePlayerTeleport(tpDetails.player, tpDetails.targetPos, tpDetails.x, tpDetails.y, tpDetails.z, targetDimension);
            }
            for (x = (int)overrideAABB.f_82288_; x <= (int)overrideAABB.f_82291_; ++x) {
                for (int y = (int)overrideAABB.f_82289_; y <= (int)overrideAABB.f_82292_; ++y) {
                    for (z = (int)overrideAABB.f_82290_; z <= (int)overrideAABB.f_82293_; ++z) {
                        currentPos = pPos.m_7918_(x, y, z);
                        if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                            this.handleBlockRemoval(pLevel, currentPos);
                            continue;
                        }
                        if (currentPos == pPos) continue;
                        toBeRemoved.add(currentPos);
                    }
                }
            }
        }
        for (BlockPos positionToBeRemoved : toBeRemoved) {
            this.handleBlockRemoval(pLevel, positionToBeRemoved);
        }
        if (overrideAABB == null) {
            for (int __x = -size; __x <= size; ++__x) {
                for (int __y = -1; __y <= y_size + (y_size - 1); ++__y) {
                    for (__z = -size; __z <= size; ++__z) {
                        updatedCurrentPos = targetPos.m_7918_(__x, __y, __z);
                        updatedBlockState = pLevel.m_8055_(updatedCurrentPos);
                        if (!(updatedBlockState.m_60734_() instanceof ThrottleBlock) || !((Boolean)updatedBlockState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
                        ((ThrottleBlock)updatedBlockState.m_60734_()).pull(updatedBlockState, pLevel, updatedCurrentPos);
                    }
                }
            }
        } else {
            for (int __x = (int)overrideAABB.f_82288_; __x <= (int)overrideAABB.f_82291_; ++__x) {
                for (int __y = (int)overrideAABB.f_82289_; __y <= (int)overrideAABB.f_82292_; ++__y) {
                    for (__z = (int)overrideAABB.f_82290_; __z <= (int)overrideAABB.f_82293_; ++__z) {
                        updatedCurrentPos = targetPos.m_7918_(__x, __y, __z);
                        updatedBlockState = pLevel.m_8055_(updatedCurrentPos);
                        if (!(updatedBlockState.m_60734_() instanceof ThrottleBlock) || !((Boolean)updatedBlockState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) continue;
                        ((ThrottleBlock)updatedBlockState.m_60734_()).pull(updatedBlockState, pLevel, updatedCurrentPos);
                    }
                }
            }
        }
        this.handleBlockRemoval(pLevel, pPos);
    }

    private void handleBlockTeleportVortex2Vortex(Level pLevel, BlockPos currentPos, BlockPos targetPos, int x, int y, int z) {
        if (pLevel instanceof ServerLevel) {
            BlockEntity newBlockEntity;
            ServerLevel serverlevel = (ServerLevel)pLevel;
            if (serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50752_ || serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50257_ || serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50258_) {
                return;
            }
            BlockPos augmentedPos = targetPos.m_7918_(x, y, z);
            BlockEntity blockEntity = serverlevel.m_7702_(currentPos);
            CompoundTag nbtData = null;
            if (blockEntity != null) {
                nbtData = blockEntity.m_187480_();
                if (blockEntity instanceof SizeManipulatorBlockEntity) {
                    SizeManipulatorBlockEntity sizeManipulatorBlockEntity = (SizeManipulatorBlockEntity)blockEntity;
                    sizeManipulatorBlockEntity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_41852_, 0));
                }
            }
            serverlevel.m_46597_(augmentedPos, serverlevel.m_8055_(currentPos));
            if (nbtData != null && (newBlockEntity = serverlevel.m_7702_(augmentedPos)) != null) {
                newBlockEntity.m_142466_(nbtData);
            }
        }
    }

    private void handleBlockTeleportVortex(Level pLevel, BlockPos currentPos, BlockPos targetPos, int x, int y, int z) {
        if (pLevel instanceof ServerLevel) {
            ResourceKey<Level> resourcekey;
            ServerLevel serverlevel = (ServerLevel)pLevel;
            if (serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50752_ || serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50257_ || serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50258_) {
                return;
            }
            MinecraftServer minecraftserver = serverlevel.m_7654_();
            ServerLevel dimension = minecraftserver.m_129880_(resourcekey = ModDimensions.vortexDIM_LEVEL_KEY);
            if (dimension != null) {
                BlockState blockState;
                BlockPos augmentedPos = targetPos.m_7918_(x, y, z);
                BlockEntity blockEntity = pLevel.m_7702_(currentPos);
                CompoundTag nbtData = null;
                if (blockEntity != null) {
                    nbtData = blockEntity.m_187480_();
                    blockEntity.m_142466_(new CompoundTag());
                    if (blockEntity instanceof SizeManipulatorBlockEntity) {
                        SizeManipulatorBlockEntity sizeManipulatorBlockEntity = (SizeManipulatorBlockEntity)blockEntity;
                        sizeManipulatorBlockEntity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_41852_, 0));
                    }
                }
                if ((blockState = pLevel.m_8055_(currentPos)) != null) {
                    BlockEntity newBlockEntity;
                    dimension.m_46597_(augmentedPos, blockState);
                    if (nbtData != null && (newBlockEntity = dimension.m_7702_(augmentedPos)) != null) {
                        newBlockEntity.m_142466_(nbtData);
                    }
                } else {
                    dimension.m_46597_(augmentedPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    private void handleBlockTeleport(Level pLevel, BlockPos currentPos, BlockPos targetPos, int x, int y, int z, ServerLevel dimension) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)pLevel;
            if (serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50752_ || serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50257_ || serverlevel.m_8055_(currentPos).m_60734_() == Blocks.f_50258_) {
                return;
            }
            if (dimension != null) {
                BlockState blockState;
                BlockPos augmentedPos = targetPos.m_7918_(x, y, z);
                BlockEntity blockEntity = pLevel.m_7702_(currentPos);
                CompoundTag nbtData = null;
                if (blockEntity != null) {
                    nbtData = blockEntity.m_187480_();
                    blockEntity.m_142466_(new CompoundTag());
                    if (blockEntity instanceof SizeManipulatorBlockEntity) {
                        SizeManipulatorBlockEntity sizeManipulatorBlockEntity = (SizeManipulatorBlockEntity)blockEntity;
                        sizeManipulatorBlockEntity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_41852_, 0));
                    }
                }
                if ((blockState = pLevel.m_8055_(currentPos)) != null) {
                    BlockEntity newBlockEntity;
                    dimension.m_46597_(augmentedPos, blockState);
                    if (blockState.m_60734_() instanceof ThrottleBlock && ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue()) {
                        ((ThrottleBlock)blockState.m_60734_()).pull(blockState, (Level)dimension, augmentedPos);
                    }
                    if (nbtData != null && (newBlockEntity = dimension.m_7702_(augmentedPos)) != null) {
                        newBlockEntity.m_142466_(nbtData);
                    }
                } else {
                    dimension.m_46597_(augmentedPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    private void handleBlockRemoval(Level pLevel, BlockPos currentPos) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (serverLevel.m_8055_(currentPos).m_60734_() == Blocks.f_50752_ || serverLevel.m_8055_(currentPos).m_60734_() == Blocks.f_50257_ || serverLevel.m_8055_(currentPos).m_60734_() == Blocks.f_50258_) {
                return;
            }
            BlockEntity blockEntity = pLevel.m_7702_(currentPos);
            if (blockEntity != null) {
                blockEntity.m_142466_(new CompoundTag());
                blockEntity.invalidateCaps();
            }
            pLevel.m_7471_(currentPos, false);
            pLevel.m_46747_(currentPos);
        }
    }

    private void handlePlayerTeleportVortex2Vortex(Entity player, BlockPos targetPos, double x, double y, double z) {
        if (!player.m_20159_()) {
            Vec3 augmentedPos = new Vec3((double)targetPos.m_123341_() + x, (double)targetPos.m_123342_() + y, (double)targetPos.m_123343_() + z);
            player.m_6021_(augmentedPos.m_7096_(), augmentedPos.m_7098_(), augmentedPos.m_7094_());
        }
    }

    private void handlePlayerTeleportVortex(Entity player, BlockPos targetPos, double x, double y, double z) {
        ResourceKey<Level> resourcekey;
        ServerLevel serverlevel;
        MinecraftServer minecraftserver;
        ServerLevel dimension;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (dimension = (minecraftserver = (serverlevel = (ServerLevel)level).m_7654_()).m_129880_(resourcekey = ModDimensions.vortexDIM_LEVEL_KEY)) != null && !player.m_20159_()) {
            Vec3 augmentedPos = new Vec3((double)targetPos.m_123341_() + x, (double)targetPos.m_123342_() + y, (double)targetPos.m_123343_() + z);
            player.changeDimension(dimension, (ITeleporter)new ModTeleporter(augmentedPos));
        }
    }

    private void handlePlayerTeleport(Entity player, BlockPos targetPos, double x, double y, double z, ServerLevel dimension) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (dimension != null && !player.m_20159_()) {
                Vec3 augmentedPos = new Vec3((double)targetPos.m_123341_() + x, (double)targetPos.m_123342_() + y, (double)targetPos.m_123343_() + z);
                player.changeDimension(dimension, (ITeleporter)new ModTeleporter(augmentedPos));
            }
        }
    }

    private static class TeleportationDetails {
        private final Entity player;
        private final BlockPos targetPos;
        private final double x;
        private final double y;
        private final double z;

        public TeleportationDetails(Entity player, BlockPos targetPos, double x, double y, double z) {
            this.player = player;
            this.targetPos = targetPos;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

