/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.item.ModItems;
import net.plaaasma.vortexmod.screen.custom.menu.SizeManipulatorMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizeManipulatorBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(1);
    private static final int INPUT_SLOT = 0;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> SizeManipulatorBlockEntity.this.field_size;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    SizeManipulatorBlockEntity.this.field_size = pValue;
                }
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private int field_size = 0;
    private BlockPos alphaPos = null;
    private BlockPos betaPos = null;

    public SizeManipulatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SIZE_MANIPULATOR_BE.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.vortexmod.size_manipulator_name");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SizeManipulatorMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.itemHandler.deserializeNBT(pTag.m_128469_("inventory"));
        CompoundTag vortexModData = pTag.m_128469_("vortexmod");
        this.field_size = vortexModData.m_128451_("field_size");
        int alphaX = vortexModData.m_128451_("alpha_x");
        int alphaY = vortexModData.m_128451_("alpha_y");
        int alphaZ = vortexModData.m_128451_("alpha_z");
        this.alphaPos = new BlockPos(alphaX, alphaY, alphaZ);
        int betaX = vortexModData.m_128451_("beta_x");
        int betaY = vortexModData.m_128451_("beta_y");
        int betaZ = vortexModData.m_128451_("beta_z");
        this.betaPos = new BlockPos(betaX, betaY, betaZ);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        CompoundTag vortexModData = new CompoundTag();
        vortexModData.m_128405_("field_size", this.field_size);
        if (this.alphaPos != null) {
            vortexModData.m_128405_("alpha_x", this.alphaPos.m_123341_());
            vortexModData.m_128405_("alpha_y", this.alphaPos.m_123342_());
            vortexModData.m_128405_("alpha_z", this.alphaPos.m_123343_());
        }
        if (this.betaPos != null) {
            vortexModData.m_128405_("beta_x", this.betaPos.m_123341_());
            vortexModData.m_128405_("beta_y", this.betaPos.m_123342_());
            vortexModData.m_128405_("beta_z", this.betaPos.m_123343_());
        }
        pTag.m_128365_("vortexmod", (Tag)vortexModData);
    }

    public void setAlphaPos(BlockPos alphaPos) {
        this.alphaPos = alphaPos;
    }

    public void setBetaPos(BlockPos betaPos) {
        this.betaPos = betaPos;
    }

    public BlockPos getAlphaPos() {
        return this.alphaPos;
    }

    public BlockPos getBetaPos() {
        return this.betaPos;
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        ItemStack currentStack = this.itemHandler.getStackInSlot(0);
        this.field_size = currentStack.m_150930_((Item)ModItems.SIZE_UPGRADE.get()) ? currentStack.m_41613_() : 0;
        SizeManipulatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
    }
}

