/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TorchflowerCropBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.plaaasma.vortexmod.block.ModBlocks;
import net.plaaasma.vortexmod.block.custom.ThrottleBlock;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.block.entity.SizeManipulatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.entities.ModEntities;
import net.plaaasma.vortexmod.entities.custom.TardisEntity;
import net.plaaasma.vortexmod.item.ModItems;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.sound.ModSounds;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;
import org.jetbrains.annotations.Nullable;

public class VortexInterfaceBlock
extends BaseEntityBlock {
    public VortexInterfaceBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            MinecraftServer minecraftserver = serverLevel.m_7654_();
            ServerLevel overworld = minecraftserver.m_129880_(Level.f_46428_);
            ServerLevel tardisDimension = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
            LocationMapData data = LocationMapData.get(overworld);
            ItemStack holdingItem = pPlayer.m_21120_(pHand);
            if (holdingItem.m_150930_((Item)ModItems.WRENCH.get())) {
                BlockEntity blockEntity = serverLevel.m_7702_(pPos);
                if (blockEntity != null) {
                    ItemStack droppedItem = new ItemStack((ItemLike)pState.m_60734_());
                    blockEntity.m_187476_(droppedItem);
                    serverLevel.m_7471_(pPos, false);
                    double x = (double)pPos.m_123341_() + 0.5;
                    double y = (double)pPos.m_123342_() + 0.5;
                    double z = (double)pPos.m_123343_() + 0.5;
                    ItemEntity droppedEntity = new ItemEntity((Level)serverLevel, x, y, z, droppedItem);
                    serverLevel.m_7967_((Entity)droppedEntity);
                }
                return InteractionResult.CONSUME;
            }
            VortexInterfaceBlockEntity localBlockEntity = (VortexInterfaceBlockEntity)serverLevel.m_7702_(pPos);
            int ownerCode = localBlockEntity.data.m_6413_(2);
            if (ownerCode == 0) {
                localBlockEntity.data.m_8050_(2, pPlayer.m_6302_().hashCode());
                pPlayer.m_5661_((Component)Component.m_237113_((String)("TARDIS owner set to " + pPlayer.m_6302_())).m_130940_(ChatFormatting.AQUA), true);
                return InteractionResult.CONSUME;
            }
            if (holdingItem.m_150930_((Item)ModItems.EUCLIDEAN_UPGRADE.get()) && pLevel != tardisDimension) {
                serverLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.BOTI_UPGRADE_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                Set<String> keyList = data.getDataMap().keySet();
                int greatest_x_coordinate = -1000000;
                int greatest_z_coordinate = -1000000;
                for (String key : keyList) {
                    BlockPos interiorPos = data.getDataMap().get(key);
                    int x_coordinate = interiorPos.m_123341_();
                    int z_coordinate = interiorPos.m_123343_();
                    if (key.equals(Integer.toString(ownerCode))) {
                        greatest_x_coordinate = x_coordinate;
                        greatest_z_coordinate = z_coordinate;
                        break;
                    }
                    if (x_coordinate > greatest_x_coordinate) {
                        greatest_x_coordinate = x_coordinate;
                    }
                    if (z_coordinate <= greatest_z_coordinate) continue;
                    greatest_z_coordinate = z_coordinate;
                }
                localBlockEntity.data.m_8050_(6, pPos.m_123341_());
                localBlockEntity.data.m_8050_(7, pPos.m_123342_());
                localBlockEntity.data.m_8050_(8, pPos.m_123343_());
                BlockPos tardisTarget = new BlockPos(greatest_x_coordinate + 10000, -128, greatest_z_coordinate + 10000);
                int size = 1;
                for (int x = -size; x <= size; ++x) {
                    for (int y = -1; y <= size; ++y) {
                        for (int z = -size; z <= size; ++z) {
                            BlockEntity blockEntity;
                            BlockPos currentPos = pPos.m_7918_(x, y, z);
                            if (currentPos == pPos || !((blockEntity = pLevel.m_7702_(currentPos)) instanceof SizeManipulatorBlockEntity)) continue;
                            SizeManipulatorBlockEntity sizeManipulatorBlockEntity = (SizeManipulatorBlockEntity)blockEntity;
                            size += sizeManipulatorBlockEntity.data.m_6413_(0);
                        }
                    }
                }
                if (size <= 0) {
                    size = 1;
                }
                int y_size = 5;
                if (size < 5) {
                    y_size = size;
                }
                int door_distance = 10 + size;
                BlockPos interfacePos = null;
                ArrayList<BlockPos> toBeRemoved = new ArrayList<BlockPos>();
                for (int x = -size; x <= size; ++x) {
                    for (int y = -1; y <= y_size + (y_size - 1); ++y) {
                        for (int z = -size; z <= size; ++z) {
                            BlockEntity newBlockEntity;
                            BlockPos currentPos = pPos.m_7918_(x, y, z);
                            BlockPos currentTargetPos = tardisTarget.m_7918_(x + door_distance, y, z);
                            BlockEntity blockEntity = serverLevel.m_7702_(currentPos);
                            if (blockEntity != null && blockEntity instanceof VortexInterfaceBlockEntity) {
                                VortexInterfaceBlockEntity vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)blockEntity;
                                interfacePos = currentTargetPos;
                            }
                            BlockState blockState = serverLevel.m_8055_(currentPos);
                            CompoundTag nbtData = null;
                            if (blockEntity != null) {
                                nbtData = blockEntity.m_187480_();
                                if (blockEntity instanceof SizeManipulatorBlockEntity) {
                                    SizeManipulatorBlockEntity sizeManipulatorBlockEntity = (SizeManipulatorBlockEntity)blockEntity;
                                    sizeManipulatorBlockEntity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_41852_, 0));
                                }
                            }
                            tardisDimension.m_46597_(currentTargetPos, blockState);
                            if (nbtData != null && (newBlockEntity = serverLevel.m_7702_(currentPos)) != null) {
                                newBlockEntity.m_142466_(nbtData);
                                newBlockEntity.invalidateCaps();
                            }
                            if (pLevel.m_8055_(currentPos).m_60734_() instanceof DoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof PressurePlateBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ButtonBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof LeverBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedstoneTorchBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TrapDoorBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallGrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof SeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallSeagrassBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TorchflowerCropBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ChorusFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof TallFlowerBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof FlowerPotBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof ThrottleBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof RedStoneWireBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof BedBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof CarpetBlock || pLevel.m_8055_(currentPos).m_60734_() instanceof VineBlock) {
                                serverLevel.m_7471_(currentPos, false);
                                serverLevel.m_46747_(currentPos);
                                continue;
                            }
                            if (serverLevel.m_8055_(currentPos).m_60734_() == Blocks.f_50752_ || serverLevel.m_8055_(currentPos).m_60734_() == Blocks.f_50257_ || serverLevel.m_8055_(currentPos).m_60734_() == Blocks.f_50258_ || currentPos == pPos) continue;
                            toBeRemoved.add(currentPos);
                        }
                    }
                }
                for (BlockPos positionToBeRemoved : toBeRemoved) {
                    BlockEntity blockEntity = serverLevel.m_7702_(positionToBeRemoved);
                    if (blockEntity != null) {
                        blockEntity.m_142466_(new CompoundTag());
                    }
                    serverLevel.m_7471_(positionToBeRemoved, false);
                    serverLevel.m_46747_(positionToBeRemoved);
                }
                for (int x = -1; x < door_distance; ++x) {
                    for (int z = -1; z < 2; ++z) {
                        BlockPos augmentedPos = tardisTarget.m_7918_(x, -1, z);
                        BlockState blockAt = tardisDimension.m_8055_(augmentedPos);
                        if (blockAt.m_60734_() != Blocks.f_50016_) continue;
                        tardisDimension.m_46597_(augmentedPos, Blocks.f_50069_.m_49966_());
                    }
                }
                tardisDimension.m_46597_(tardisTarget, ((Block)ModBlocks.DOOR_BLOCK.get()).m_49966_());
                VortexInterfaceBlockEntity interfaceBlockEntity = (VortexInterfaceBlockEntity)tardisDimension.m_7702_(interfacePos);
                TardisEntity tardisMob = (TardisEntity)((EntityType)ModEntities.TARDIS.get()).m_262496_(serverLevel, pPos, MobSpawnType.NATURAL);
                serverLevel.m_7967_((Entity)tardisMob);
                tardisMob.setOwnerID(ownerCode);
                interfaceBlockEntity.setExtUUID(tardisMob.m_20148_());
                data.getDataMap().put(tardisMob.m_20148_().toString(), tardisTarget);
                ChunkPos chunkPos = tardisDimension.m_46745_(interfacePos).m_7697_();
                ForgeChunkManager.forceChunk((ServerLevel)tardisDimension, (String)"vortexmod", (BlockPos)interfacePos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
                chunkPos = serverLevel.m_46745_(pPos).m_7697_();
                ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"vortexmod", (BlockPos)pPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
                pPlayer.m_21008_(pHand, new ItemStack((ItemLike)ModItems.TARDIS_KEY.get(), 1));
                this.handleLightningStrikes((Level)serverLevel, pPos);
                data.m_77762_();
                serverLevel.m_7471_(pPos, false);
            }
        }
        return InteractionResult.CONSUME;
    }

    private void handleLightningStrikes(Level pLevel, BlockPos targetPosition) {
        List connectionList = pLevel.m_7654_().m_129919_().m_184193_();
        for (Connection pConnection : connectionList) {
            ClientboundAddEntityPacket entityPacket = new ClientboundAddEntityPacket((Entity)new LightningBolt(EntityType.f_20465_, pLevel), 0, targetPosition);
            if (!pConnection.m_129536_() || !pConnection.m_129538_().m_6198_() || !(pConnection.m_129538_() instanceof ServerGamePacketListenerImpl)) continue;
            pConnection.m_129512_((Packet)entityPacket);
        }
    }

    public int m_6378_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        VortexInterfaceBlockEntity localBlockEntity = (VortexInterfaceBlockEntity)pLevel.m_7702_(pPos);
        return localBlockEntity.data.m_6413_(21);
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            ChunkPos chunkPos = serverLevel.m_46745_(pPos).m_7697_();
            ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"vortexmod", (BlockPos)pPos, (int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (boolean)true, (boolean)true);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pMovedByPiston);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new VortexInterfaceBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return VortexInterfaceBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.VORTEX_INTERFACE_BE.get()), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.interface_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

