/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.plaaasma.vortexmod.block.ModBlockStateProperties;
import net.plaaasma.vortexmod.sound.ModSounds;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ThrottleBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty AUTO = ModBlockStateProperties.AUTO;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)5.0, (double)4.0, (double)10.0, (double)11.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)6.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)11.0);
    protected static final VoxelShape UP_AABB_Z = Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)6.0, (double)12.0);
    protected static final VoxelShape UP_AABB_X = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)6.0, (double)11.0);
    protected static final VoxelShape DOWN_AABB_Z = Block.m_49796_((double)5.0, (double)10.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    protected static final VoxelShape DOWN_AABB_X = Block.m_49796_((double)4.0, (double)10.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);

    public ThrottleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)AUTO, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((AttachFace)pState.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                switch (((Direction)pState.m_61143_((Property)f_54117_)).m_122434_()) {
                    case X: {
                        return UP_AABB_X;
                    }
                }
                return UP_AABB_Z;
            }
            case WALL: {
                switch ((Direction)pState.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        switch (((Direction)pState.m_61143_((Property)f_54117_)).m_122434_()) {
            case X: {
                return DOWN_AABB_X;
            }
        }
        return DOWN_AABB_Z;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        for (Direction direction : pContext.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_())) continue;
            return blockstate;
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            if (pPlayer.m_6047_()) {
                pState.m_61122_((Property)AUTO);
            } else {
                BlockState blockstate1 = (BlockState)pState.m_61122_((Property)POWERED);
                if (((Boolean)blockstate1.m_61143_((Property)POWERED)).booleanValue()) {
                    ThrottleBlock.makeParticle(blockstate1, (LevelAccessor)pLevel, pPos, 1.0f);
                }
            }
            return InteractionResult.SUCCESS;
        }
        Random random = new Random();
        if (pPlayer.m_6047_()) {
            BlockState blockstate = this.pull_auto(pState, pLevel, pPos);
            pLevel.m_142346_((Entity)pPlayer, (Boolean)blockstate.m_61143_((Property)AUTO) != false ? GameEvent.f_223702_ : GameEvent.f_223702_, pPos);
            if (((Boolean)blockstate.m_61143_((Property)AUTO)).booleanValue()) {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Auto Landing Enabled"), true);
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Auto Landing Disabled"), true);
            }
        } else {
            BlockState blockstate = this.pull(pState, pLevel, pPos);
            pLevel.m_142346_((Entity)pPlayer, (Boolean)blockstate.m_61143_((Property)POWERED) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, pPos);
            if (((Boolean)blockstate.m_61143_((Property)POWERED)).booleanValue()) {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Throttle Enabled"), true);
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.THROTTLE_SOUND.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(1.0f, 1.2f), 0L);
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Throttle Disabled"), true);
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.THROTTLE_SOUND.get(), SoundSource.BLOCKS, 1.0f, random.nextFloat(0.7f, 0.9f), 0L);
            }
        }
        return InteractionResult.CONSUME;
    }

    public BlockState pull(BlockState pState, Level pLevel, BlockPos pPos) {
        pState = (BlockState)pState.m_61122_((Property)POWERED);
        pLevel.m_7731_(pPos, pState, 3);
        return pState;
    }

    public BlockState pull_auto(BlockState pState, Level pLevel, BlockPos pPos) {
        pState = (BlockState)pState.m_61122_((Property)AUTO);
        pLevel.m_7731_(pPos, pState, 3);
        return pState;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue() && pRandom.m_188501_() < 0.25f) {
            ThrottleBlock.makeParticle(pState, (LevelAccessor)pLevel, pPos, 0.5f);
        }
    }

    private static void makeParticle(BlockState pState, LevelAccessor pLevel, BlockPos pPos, float pAlpha) {
        Direction direction = ((Direction)pState.m_61143_((Property)f_54117_)).m_122424_();
        Direction direction1 = ThrottleBlock.m_53200_((BlockState)pState).m_122424_();
        double d0 = (double)pPos.m_123341_() + 0.5 + 0.1 * (double)direction.m_122429_() + 0.2 * (double)direction1.m_122429_();
        double d1 = (double)pPos.m_123342_() + 0.5 + 0.1 * (double)direction.m_122430_() + 0.2 * (double)direction1.m_122430_();
        double d2 = (double)pPos.m_123343_() + 0.5 + 0.1 * (double)direction.m_122431_() + 0.2 * (double)direction1.m_122431_();
        pLevel.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(80.0f, 167.0f, 167.0f), pAlpha), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.throttle_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_53179_, f_54117_, POWERED, AUTO});
        super.m_7926_(pBuilder);
    }
}

