/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.plaaasma.vortexmod.block.custom.HorizontalBaseEntityBlock;
import net.plaaasma.vortexmod.block.custom.VortexInterfaceBlock;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.block.entity.SizeManipulatorBlockEntity;
import net.plaaasma.vortexmod.item.ModItems;
import net.plaaasma.vortexmod.item.custom.SizeDesignator;
import org.jetbrains.annotations.Nullable;

public class SizeManipulatorBlock
extends HorizontalBaseEntityBlock {
    public SizeManipulatorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof SizeManipulatorBlockEntity) {
            ((SizeManipulatorBlockEntity)blockEntity).drops();
        }
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            serverLevel.m_46747_(pPos);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            SizeManipulatorBlockEntity localBlockEntity = (SizeManipulatorBlockEntity)pLevel.m_7702_(pPos);
            if (pPlayer.m_6047_()) {
                if (localBlockEntity.getAlphaPos() != null && localBlockEntity.getBetaPos() != null) {
                    localBlockEntity.setAlphaPos(null);
                    localBlockEntity.setBetaPos(null);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)"Removed override positions").m_130940_(ChatFormatting.RED), true);
                } else {
                    pPlayer.m_5661_((Component)Component.m_237113_((String)"Override positions are already removed").m_130940_(ChatFormatting.RED), true);
                }
            } else {
                ItemStack heldStack;
                BlockPos interfacePos = null;
                for (int face = 0; face < 6; ++face) {
                    BlockPos testPos = null;
                    BlockState currentBlockState = null;
                    switch (face) {
                        case 0: {
                            testPos = pPos.m_7495_();
                            currentBlockState = pLevel.m_8055_(testPos);
                            if (!(currentBlockState.m_60734_() instanceof VortexInterfaceBlock)) break;
                            interfacePos = testPos;
                            break;
                        }
                        case 1: {
                            testPos = pPos.m_122029_();
                            currentBlockState = pLevel.m_8055_(testPos);
                            if (!(currentBlockState.m_60734_() instanceof VortexInterfaceBlock)) break;
                            interfacePos = testPos;
                            break;
                        }
                        case 2: {
                            testPos = pPos.m_122024_();
                            currentBlockState = pLevel.m_8055_(testPos);
                            if (!(currentBlockState.m_60734_() instanceof VortexInterfaceBlock)) break;
                            interfacePos = testPos;
                            break;
                        }
                        case 3: {
                            testPos = pPos.m_122012_();
                            currentBlockState = pLevel.m_8055_(testPos);
                            if (!(currentBlockState.m_60734_() instanceof VortexInterfaceBlock)) break;
                            interfacePos = testPos;
                            break;
                        }
                        case 4: {
                            testPos = pPos.m_122019_();
                            currentBlockState = pLevel.m_8055_(testPos);
                            if (!(currentBlockState.m_60734_() instanceof VortexInterfaceBlock)) break;
                            interfacePos = testPos;
                            break;
                        }
                        case 5: {
                            testPos = pPos.m_7494_();
                            currentBlockState = pLevel.m_8055_(testPos);
                            if (!(currentBlockState.m_60734_() instanceof VortexInterfaceBlock)) break;
                            interfacePos = testPos;
                        }
                    }
                    if (interfacePos != null) break;
                }
                if ((heldStack = pPlayer.m_21120_(pHand)).m_150930_((Item)ModItems.SIZE_DESIGNATOR.get())) {
                    SizeDesignator sizeDesignator = (SizeDesignator)heldStack.m_41720_();
                    if (sizeDesignator.alpha_pos != null && sizeDesignator.beta_pos != null) {
                        int zLength;
                        int yLength;
                        int xLength = Math.abs(sizeDesignator.alpha_pos.m_123341_() - sizeDesignator.beta_pos.m_123341_());
                        int area = 2 * (xLength * (yLength = Math.abs(sizeDesignator.alpha_pos.m_123342_() - sizeDesignator.beta_pos.m_123342_()))) + 2 * (yLength * (zLength = Math.abs(sizeDesignator.alpha_pos.m_123343_() - sizeDesignator.beta_pos.m_123343_()))) + 2 * (xLength * zLength);
                        if (area < localBlockEntity.data.m_6413_(0) * 256) {
                            AABB overrideAABB = new AABB(sizeDesignator.alpha_pos, sizeDesignator.beta_pos);
                            if (overrideAABB.m_82393_((double)interfacePos.m_123341_(), (double)interfacePos.m_123342_() + 0.5, (double)interfacePos.m_123343_())) {
                                localBlockEntity.setAlphaPos(sizeDesignator.alpha_pos.m_121996_((Vec3i)interfacePos));
                                localBlockEntity.setBetaPos(sizeDesignator.beta_pos.m_121996_((Vec3i)interfacePos));
                                pPlayer.m_5661_((Component)Component.m_237113_((String)("Set override positions to " + sizeDesignator.alpha_pos.m_123344_() + " : " + sizeDesignator.beta_pos.m_123344_())).m_130940_(ChatFormatting.AQUA), true);
                            } else {
                                pPlayer.m_5661_((Component)Component.m_237113_((String)"The interface is not within the bounds.").m_130940_(ChatFormatting.RED), true);
                            }
                        } else {
                            pPlayer.m_5661_((Component)Component.m_237113_((String)("You don't have enough size upgrades for this, you need " + (area / 256 + 1))), true);
                        }
                    } else {
                        pPlayer.m_5661_((Component)Component.m_237113_((String)"You have not set both corner positions.").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    BlockEntity entity = pLevel.m_7702_(pPos);
                    if (entity instanceof SizeManipulatorBlockEntity) {
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)((SizeManipulatorBlockEntity)entity), (BlockPos)pPos);
                    } else {
                        throw new IllegalStateException("Our container provider is missing!");
                    }
                }
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new SizeManipulatorBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return SizeManipulatorBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlockEntities.SIZE_MANIPULATOR_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.size_manipulator_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
        super.m_7926_(pBuilder);
    }
}

