/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.plaaasma.vortexmod.block.custom.HorizontalBaseEntityBlock;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.block.entity.ScannerBlockEntity;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.entities.custom.TardisEntity;
import net.plaaasma.vortexmod.sound.ModSounds;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;
import org.jetbrains.annotations.Nullable;

public class ScannerBlock
extends HorizontalBaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);

    public ScannerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public SoundType m_49962_(BlockState pState) {
        return super.m_49962_(pState);
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.SCANNER_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            MinecraftServer minecraftserver = serverLevel.m_7654_();
            ServerLevel overworldDimension = minecraftserver.m_129880_(Level.f_46428_);
            Iterable serverLevels = minecraftserver.m_129785_();
            ServerLevel vortexDimension = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
            ServerLevel tardisDimension = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
            Random random = new Random();
            Vec3 targetExit = new Vec3(0.0, 0.0, 0.0);
            BlockPos blockTargetExit = new BlockPos(0, 0, 0);
            ServerLevel decidedDimension = overworldDimension;
            boolean setVars = false;
            if (serverLevel.m_46472_() == tardisDimension.m_46472_()) {
                for (int x = -16; x <= 16 && !setVars; ++x) {
                    for (int y = -16; y <= 16 && !setVars; ++y) {
                        for (int z = -16; z <= 16 && !setVars; ++z) {
                            BlockPos currentPos = pPos.m_7918_(x, y, z);
                            BlockEntity blockEntity = pLevel.m_7702_(currentPos);
                            if (!(blockEntity instanceof VortexInterfaceBlockEntity)) continue;
                            VortexInterfaceBlockEntity vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)blockEntity;
                            ServerLevel targetDimension = overworldDimension;
                            for (ServerLevel cLevel : serverLevels) {
                                if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != vortexInterfaceBlockEntity.data.m_6413_(9)) continue;
                                targetDimension = cLevel;
                            }
                            BlockPos blockExitPos = new BlockPos(vortexInterfaceBlockEntity.data.m_6413_(6), vortexInterfaceBlockEntity.data.m_6413_(7), vortexInterfaceBlockEntity.data.m_6413_(8));
                            TardisEntity tardisEntity = (TardisEntity)targetDimension.m_8791_(vortexInterfaceBlockEntity.getExtUUID());
                            if (tardisEntity != null) {
                                if (!tardisEntity.isInFlight() && !tardisEntity.isRemat()) {
                                    int yaw = (int)tardisEntity.m_146908_();
                                    double distance = 1.4;
                                    double yawRadians = Math.toRadians(yaw);
                                    double newX = (double)blockExitPos.m_123341_() + distance * Math.sin(yawRadians);
                                    double newZ = (double)blockExitPos.m_123343_() - distance * Math.cos(yawRadians);
                                    targetExit = new Vec3(newX, (double)blockExitPos.m_123342_(), newZ);
                                    blockTargetExit = new BlockPos((int)newX, blockExitPos.m_123342_(), (int)newZ);
                                    decidedDimension = targetDimension;
                                } else {
                                    Vec3 randomVec;
                                    targetExit = randomVec = new Vec3((double)(random.nextInt(1000000) - 500000), -100.0, (double)(random.nextInt(1000000) - 500000));
                                    blockTargetExit = new BlockPos((int)randomVec.f_82479_, -100, (int)randomVec.f_82481_);
                                    decidedDimension = vortexDimension;
                                }
                            } else {
                                decidedDimension = vortexDimension;
                                targetExit = new Vec3((double)(random.nextInt(1000000) - 500000), -100.0, (double)(random.nextInt(1000000) - 500000));
                            }
                            setVars = true;
                        }
                    }
                }
                String status = "Safe to exit, outside block: ";
                ChatFormatting statusFormat = ChatFormatting.GREEN;
                if (decidedDimension.m_8055_(blockTargetExit.m_7495_()).m_60734_() == Blocks.f_50016_ || decidedDimension.m_8055_(blockTargetExit.m_7495_()).m_60734_() == Blocks.f_49991_ || decidedDimension.m_8055_(blockTargetExit.m_7495_()).m_60734_() == Blocks.f_49990_ || decidedDimension.m_8055_(blockTargetExit).m_60734_() != Blocks.f_50016_ || decidedDimension.m_8055_(blockTargetExit.m_7494_()).m_60734_() != Blocks.f_50016_ || decidedDimension == vortexDimension) {
                    status = "Not safe to exit, outside block: ";
                    statusFormat = ChatFormatting.RED;
                }
                String blockString = decidedDimension.m_8055_(blockTargetExit.m_7495_()).m_60734_().m_49954_().getString() + "\n";
                String dimensionString = decidedDimension.m_46472_().m_135782_().m_135815_() + "\n";
                String coordinateString = targetExit.f_82479_ + " " + targetExit.f_82480_ + " " + targetExit.f_82481_;
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Scan Results:\n").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)status).m_130940_(statusFormat).m_7220_((Component)Component.m_237113_((String)blockString).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)dimensionString).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)coordinateString).m_130940_(ChatFormatting.GOLD))))), false);
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Scanner is not in the TARDIS dimension.").m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            serverLevel.m_46747_(pPos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ScannerBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return ScannerBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlockEntities.SCANNER_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.scanner_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
        super.m_7926_(pBuilder);
    }
}

