/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.plaaasma.vortexmod.block.custom.HorizontalBaseEntityBlock;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.block.entity.MonitorBlockEntity;
import net.plaaasma.vortexmod.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class MonitorBlock
extends HorizontalBaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public MonitorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_((Property)f_54117_) == Direction.SOUTH) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)13.0, (double)5.0);
        }
        if (pState.m_61143_((Property)f_54117_) == Direction.WEST) {
            return Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0);
        }
        if (pState.m_61143_((Property)f_54117_) == Direction.NORTH) {
            return Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)13.0, (double)15.0);
        }
        return Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)5.0, (double)13.0, (double)16.0);
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.MONITOR_TOGGLE_SOUND.get(), SoundSource.BLOCKS, 0.5f, 1.0f, 0L);
        if (pLevel.f_46443_) {
            pState.m_61122_((Property)POWERED);
            return InteractionResult.SUCCESS;
        }
        BlockState blockstate = this.pull(pState, pLevel, pPos);
        pLevel.m_142346_((Entity)pPlayer, (Boolean)blockstate.m_61143_((Property)POWERED) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, pPos);
        return InteractionResult.CONSUME;
    }

    public BlockState pull(BlockState pState, Level pLevel, BlockPos pPos) {
        pState = (BlockState)pState.m_61122_((Property)POWERED);
        pLevel.m_7731_(pPos, pState, 3);
        return pState;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MonitorBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return MonitorBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlockEntities.MONITOR_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.monitor_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, POWERED});
        super.m_7926_(pBuilder);
    }
}

