/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.plaaasma.vortexmod.block.custom.HorizontalBaseEntityBlock;
import net.plaaasma.vortexmod.block.entity.KeypadBlockEntity;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.mapdata.DimensionMapData;
import net.plaaasma.vortexmod.mapdata.LocationMapData;
import net.plaaasma.vortexmod.network.ClientboundDimListPacket;
import net.plaaasma.vortexmod.network.ClientboundTargetMapPacket;
import net.plaaasma.vortexmod.network.PacketHandler;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;
import org.jetbrains.annotations.Nullable;

public class KeypadBlock
extends HorizontalBaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public KeypadBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_().m_122424_());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        KeypadBlockEntity entity = (KeypadBlockEntity)pLevel.m_7702_(pPos);
        if (!pLevel.m_5776_()) {
            MinecraftServer minecraftserver = pLevel.m_7654_();
            ServerLevel tardis_dim = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
            ServerLevel vortex = minecraftserver.m_129880_(ModDimensions.vortexDIM_LEVEL_KEY);
            LocationMapData coord_data = LocationMapData.get(vortex);
            DimensionMapData dim_data = DimensionMapData.get(tardis_dim);
            Iterable serverLevels = minecraftserver.m_129785_();
            for (Object serverLevel : serverLevels) {
                entity.serverLevels.add(serverLevel.m_46472_().m_135782_().m_135815_());
            }
            Set<String> coordKeys = coord_data.getDataMap().keySet();
            for (String coordKey : coordKeys) {
                BlockPos pointPos = coord_data.getDataMap().get(coordKey);
                entity.coordData.put(coordKey, pointPos);
                String pointDimension = dim_data.getDataMap().get(coordKey);
                entity.dimData.put(coordKey, pointDimension);
            }
            HashMap<String, String> levelMap = new HashMap<String, String>();
            for (String levelString : entity.serverLevels) {
                levelMap.put(levelString, levelString);
            }
            PacketHandler.sendToAllClients(new ClientboundTargetMapPacket(pLevel.m_46472_().m_135782_().m_135815_(), pPos, entity.coordData, entity.dimData));
            PacketHandler.sendToAllClients(new ClientboundDimListPacket(pLevel.m_46472_().m_135782_().m_135815_(), pPos, levelMap));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)entity, (BlockPos)pPos);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            serverLevel.m_46747_(pPos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new KeypadBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return KeypadBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlockEntities.TARDIS_KEYPAD_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.keypad_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
        super.m_7926_(pBuilder);
    }
}

