/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;
import net.plaaasma.vortexmod.block.entity.VortexInterfaceBlockEntity;
import net.plaaasma.vortexmod.entities.custom.TardisEntity;
import net.plaaasma.vortexmod.item.ModItems;
import net.plaaasma.vortexmod.worldgen.dimension.ModDimensions;
import net.plaaasma.vortexmod.worldgen.portal.ModTeleporter;
import org.jetbrains.annotations.Nullable;

public class DoorBlock
extends Block {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);

    public DoorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            MinecraftServer minecraftserver = serverLevel.m_7654_();
            ServerLevel overworldDimension = minecraftserver.m_129880_(Level.f_46428_);
            Iterable serverLevels = minecraftserver.m_129785_();
            ServerLevel tardisDimension = minecraftserver.m_129880_(ModDimensions.tardisDIM_LEVEL_KEY);
            ItemStack heldStack = pPlayer.m_21120_(pHand);
            if (serverLevel == tardisDimension) {
                for (int x = -100; x <= 100; ++x) {
                    for (int y = -100; y <= 100; ++y) {
                        for (int z = -100; z <= 100; ++z) {
                            BlockPos currentPos = pPos.m_7918_(x, y, z);
                            BlockEntity blockEntity = pLevel.m_7702_(currentPos);
                            if (!(blockEntity instanceof VortexInterfaceBlockEntity)) continue;
                            VortexInterfaceBlockEntity vortexInterfaceBlockEntity = (VortexInterfaceBlockEntity)blockEntity;
                            ServerLevel targetDimension = overworldDimension;
                            for (ServerLevel cLevel : serverLevels) {
                                if (cLevel.m_46472_().m_135782_().m_135815_().hashCode() != vortexInterfaceBlockEntity.data.m_6413_(9)) continue;
                                targetDimension = cLevel;
                            }
                            BlockPos blockExitPos = new BlockPos(vortexInterfaceBlockEntity.data.m_6413_(6), vortexInterfaceBlockEntity.data.m_6413_(7), vortexInterfaceBlockEntity.data.m_6413_(8));
                            TardisEntity tardisEntity = (TardisEntity)targetDimension.m_8791_(vortexInterfaceBlockEntity.getExtUUID());
                            if (tardisEntity != null) {
                                if (heldStack.m_150930_((Item)ModItems.TARDIS_KEY.get())) {
                                    int ownerCode = tardisEntity.getOwnerID();
                                    if (ownerCode == pPlayer.m_6302_().hashCode()) {
                                        if (!tardisEntity.isLocked()) {
                                            tardisEntity.setLocked(true);
                                            pPlayer.m_5661_((Component)Component.m_237113_((String)"Locking TARDIS").m_130940_(ChatFormatting.GREEN), true);
                                        } else {
                                            tardisEntity.setLocked(false);
                                            pPlayer.m_5661_((Component)Component.m_237113_((String)"Unlocking TARDIS").m_130940_(ChatFormatting.AQUA), true);
                                        }
                                    } else {
                                        pPlayer.m_5661_((Component)Component.m_237113_((String)"This TARDIS is not yours.").m_130940_(ChatFormatting.RED), true);
                                    }
                                } else if (!tardisEntity.isRemat() && !tardisEntity.isInFlight() && !tardisEntity.isDemat() && tardisEntity.getAlpha() > 0.0f) {
                                    int yaw = (int)tardisEntity.m_146908_();
                                    double distance = 1.4;
                                    double yawRadians = Math.toRadians(yaw);
                                    double newX = (double)blockExitPos.m_123341_() + distance * Math.sin(yawRadians);
                                    double newZ = (double)blockExitPos.m_123343_() - distance * Math.cos(yawRadians);
                                    Vec3 exitPosition = new Vec3(newX, (double)blockExitPos.m_123342_(), newZ);
                                    pPlayer.m_146922_((float)yaw + 180.0f);
                                    pPlayer.changeDimension(targetDimension, (ITeleporter)new ModTeleporter(exitPosition));
                                } else {
                                    pPlayer.m_5661_((Component)Component.m_237113_((String)"You cannot exit while in flight.").m_130940_(ChatFormatting.RED), true);
                                }
                            }
                            return InteractionResult.CONSUME;
                        }
                    }
                }
            } else {
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Door is not in the TARDIS dimension.").m_130940_(ChatFormatting.RED), true);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.door_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }
}

