/*
 * Decompiled with CFR 0.152.
 */
package net.plaaasma.vortexmod.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.plaaasma.vortexmod.block.custom.HorizontalBaseEntityBlock;
import net.plaaasma.vortexmod.block.entity.CoordinateDesignatorBlockEntity;
import net.plaaasma.vortexmod.block.entity.ModBlockEntities;
import net.plaaasma.vortexmod.sound.ModSounds;
import org.jetbrains.annotations.Nullable;

public class CoordinateDesignatorBlock
extends HorizontalBaseEntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);

    public CoordinateDesignatorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.EAST));
    }

    public double distanceBetween(Vec3 p1, Vec3 p2) {
        return Math.sqrt(Math.pow(p2.f_82479_ - p1.f_82479_, 2.0)) + Math.pow(p2.f_82480_ - p1.f_82480_, 2.0) + Math.pow(p2.f_82481_ - p1.f_82481_, 2.0);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Override
    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CoordinateDesignatorBlockEntity) {
            CoordinateDesignatorBlockEntity coordinateDesignatorBlockEntity = (CoordinateDesignatorBlockEntity)blockEntity;
            Vec3 positionClicked = pHit.m_82450_();
            Vec3 x_button_location = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
            Vec3 y_button_location = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
            Vec3 z_button_location = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
            Vec3 toggle_button_location = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
            Vec3 inc_button_location = new Vec3((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_());
            if (coordinateDesignatorBlockEntity.m_58900_().m_61143_((Property)f_54117_) == Direction.NORTH) {
                x_button_location = new Vec3((double)pPos.m_123341_() + 0.2515682981366041, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.7634949789690628);
                y_button_location = new Vec3((double)pPos.m_123341_() + 0.5014798645557761, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.7546238460661203);
                z_button_location = new Vec3((double)pPos.m_123341_() + 0.7411341801241704, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.7659566757527658);
                toggle_button_location = new Vec3((double)pPos.m_123341_() + 0.6789832278996357, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.41077513544820476);
                inc_button_location = new Vec3((double)pPos.m_123341_() + 0.32674897232463707, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.39896998563617103);
            } else if (coordinateDesignatorBlockEntity.m_58900_().m_61143_((Property)f_54117_) == Direction.EAST) {
                x_button_location = new Vec3((double)pPos.m_123341_() + 0.18954457971267402, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.2304064080817625);
                y_button_location = new Vec3((double)pPos.m_123341_() + 0.20980824215803295, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.49430502974428236);
                z_button_location = new Vec3((double)pPos.m_123341_() + 0.2044773130910471, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.7369853557320312);
                toggle_button_location = new Vec3((double)pPos.m_123341_() + 0.6042652493757004, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.6799177837478965);
                inc_button_location = new Vec3((double)pPos.m_123341_() + 0.5931212975465883, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.32246931892237285);
            } else if (coordinateDesignatorBlockEntity.m_58900_().m_61143_((Property)f_54117_) == Direction.SOUTH) {
                x_button_location = new Vec3((double)pPos.m_123341_() + 0.7731693559326231, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.21637912222649902);
                y_button_location = new Vec3((double)pPos.m_123341_() + 0.4986674932297319, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.22904629225376993);
                z_button_location = new Vec3((double)pPos.m_123341_() + 0.26191518583800644, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.2323134943144396);
                toggle_button_location = new Vec3((double)pPos.m_123341_() + 0.3233099189859985, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.5626540141267355);
                inc_button_location = new Vec3((double)pPos.m_123341_() + 0.6632105267438817, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.5669088499530801);
            } else if (coordinateDesignatorBlockEntity.m_58900_().m_61143_((Property)f_54117_) == Direction.WEST) {
                x_button_location = new Vec3((double)pPos.m_123341_() + 0.7750879296800122, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.7490106313489377);
                y_button_location = new Vec3((double)pPos.m_123341_() + 0.7504194345092401, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.4977753795683384);
                z_button_location = new Vec3((double)pPos.m_123341_() + 0.7682009112322703, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.2667000818764791);
                toggle_button_location = new Vec3((double)pPos.m_123341_() + 0.41202698305482954, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.3184047123590119);
                inc_button_location = new Vec3((double)pPos.m_123341_() + 0.40604781895711994, (double)pPos.m_123342_() + 0.1875, (double)pPos.m_123343_() + 0.6672646179522701);
            }
            Vec3[] components = new Vec3[]{x_button_location, y_button_location, z_button_location, toggle_button_location, inc_button_location};
            Vec3 closestComponent = null;
            double minDistance = Double.MAX_VALUE;
            for (Vec3 component : components) {
                double distance = this.distanceBetween(positionClicked, component);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                closestComponent = component;
            }
            boolean is_negative = coordinateDesignatorBlockEntity.data.m_6413_(3) == 1;
            int increment = coordinateDesignatorBlockEntity.data.m_6413_(4);
            if (closestComponent == x_button_location) {
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DESIGNATOR_SWITCH_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                if (is_negative) {
                    coordinateDesignatorBlockEntity.data.m_8050_(0, coordinateDesignatorBlockEntity.data.m_6413_(0) - increment);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)("Target X coordinate is now " + coordinateDesignatorBlockEntity.data.m_6413_(0))), true);
                } else {
                    coordinateDesignatorBlockEntity.data.m_8050_(0, coordinateDesignatorBlockEntity.data.m_6413_(0) + increment);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)("Target X coordinate is now " + coordinateDesignatorBlockEntity.data.m_6413_(0))), true);
                }
            } else if (closestComponent == y_button_location) {
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DESIGNATOR_SWITCH_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                if (is_negative) {
                    coordinateDesignatorBlockEntity.data.m_8050_(1, coordinateDesignatorBlockEntity.data.m_6413_(1) - increment);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)("Target Y coordinate is now " + coordinateDesignatorBlockEntity.data.m_6413_(1))), true);
                } else {
                    coordinateDesignatorBlockEntity.data.m_8050_(1, coordinateDesignatorBlockEntity.data.m_6413_(1) + increment);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)("Target Y coordinate is now " + coordinateDesignatorBlockEntity.data.m_6413_(1))), true);
                }
            } else if (closestComponent == z_button_location) {
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DESIGNATOR_SWITCH_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                if (is_negative) {
                    coordinateDesignatorBlockEntity.data.m_8050_(2, coordinateDesignatorBlockEntity.data.m_6413_(2) - increment);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)("Target Z coordinate is now " + coordinateDesignatorBlockEntity.data.m_6413_(2))), true);
                } else {
                    coordinateDesignatorBlockEntity.data.m_8050_(2, coordinateDesignatorBlockEntity.data.m_6413_(2) + increment);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)("Target Z coordinate is now " + coordinateDesignatorBlockEntity.data.m_6413_(2))), true);
                }
            } else if (closestComponent == toggle_button_location) {
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DESIGNATOR_BUTTON_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                if (is_negative) {
                    coordinateDesignatorBlockEntity.data.m_8050_(3, 0);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)"Now increasing coordinate values."), true);
                } else {
                    coordinateDesignatorBlockEntity.data.m_8050_(3, 1);
                    pPlayer.m_5661_((Component)Component.m_237113_((String)"Now decreasing coordinate values."), true);
                }
            } else if (closestComponent == inc_button_location) {
                pLevel.m_214150_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (SoundEvent)ModSounds.DESIGNATOR_BUTTON_SOUND.get(), SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                increment = increment >= 10000 ? 1 : (increment *= 10);
                coordinateDesignatorBlockEntity.data.m_8050_(4, increment);
                pPlayer.m_5661_((Component)Component.m_237113_((String)("Increment is now set to: " + increment)), true);
            }
        }
        return InteractionResult.m_19078_((boolean)pLevel.m_5776_());
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            serverLevel.m_46747_(pPos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CoordinateDesignatorBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        return CoordinateDesignatorBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)ModBlockEntities.COORDINATE_DESIGNATOR_BE.get(), (pLevel1, pPos, pState1, pBlockEntity) -> pBlockEntity.tick(pLevel1, pPos, pState1));
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)Component.m_237115_((String)"tooltip.vortexmod.coordinate_block.tooltip"));
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_});
        super.m_7926_(pBuilder);
    }
}

