/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compat.modernui.MuiGuiScaleHook;
import me.jellysquid.mods.sodium.client.compatibility.workarounds.Workarounds;
import me.jellysquid.mods.sodium.client.gl.arena.staging.MappedStagingBuffer;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.binding.compat.VanillaBooleanOptionBinding;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlValueFormatter;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.SliderControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.MinecraftOptionsStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.ParticleStatus;
import net.minecraft.network.chat.Component;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;

public class SodiumGameOptionPages {
    private static final SodiumOptionsStorage sodiumOpts = new SodiumOptionsStorage();
    private static final MinecraftOptionsStorage vanillaOpts = new MinecraftOptionsStorage();

    public static OptionPage general() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.renderDistance")).setTooltip((Component)Component.m_237115_((String)"sodium.options.view_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 2, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> options.m_231984_().m_231514_(value), options -> (Integer)options.m_231984_().m_231551_()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.simulationDistance")).setTooltip((Component)Component.m_237115_((String)"sodium.options.simulation_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 5, 32, 1, ControlValueFormatter.translateVariable("options.chunks"))).setBinding((options, value) -> options.m_232001_().m_231514_(value), options -> (Integer)options.m_232001_().m_231551_()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.gamma")).setTooltip((Component)Component.m_237115_((String)"sodium.options.brightness.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 100, 1, ControlValueFormatter.brightness())).setBinding((opts, value) -> opts.m_231927_().m_231514_((Object)((double)value.intValue() * 0.01)), opts -> (int)((Double)opts.m_231927_().m_231551_() / 0.01)).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.guiScale")).setTooltip((Component)Component.m_237115_((String)"sodium.options.gui_scale.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, MuiGuiScaleHook.getMaxGuiScale(), 1, ControlValueFormatter.guiScale())).setBinding((opts, value) -> {
            opts.m_231928_().m_231514_(value);
            Minecraft client = Minecraft.m_91087_();
            client.m_5741_();
        }, opts -> (Integer)opts.m_231928_().m_231551_()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.fullscreen")).setTooltip((Component)Component.m_237115_((String)"sodium.options.fullscreen.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.m_231829_().m_231514_(value);
            Minecraft client = Minecraft.m_91087_();
            Window window = client.m_91268_();
            if (window != null && window.m_85440_() != ((Boolean)opts.m_231829_().m_231551_()).booleanValue()) {
                window.m_85438_();
                opts.m_231829_().m_231514_((Object)window.m_85440_());
            }
        }, opts -> (Boolean)opts.m_231829_().m_231551_()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.vsync")).setTooltip((Component)Component.m_237115_((String)"sodium.options.v_sync.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((OptionInstance<Boolean>)Minecraft.m_91087_().f_91066_.m_231817_())).setImpact(OptionImpact.VARIES).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.framerateLimit")).setTooltip((Component)Component.m_237115_((String)"sodium.options.fps_limit.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 10, 260, 10, ControlValueFormatter.fpsLimit())).setBinding((opts, value) -> {
            opts.m_232035_().m_231514_(value);
            Minecraft.m_91087_().m_91268_().m_85380_(value.intValue());
        }, opts -> (Integer)opts.m_232035_().m_231551_()).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.viewBobbing")).setTooltip((Component)Component.m_237115_((String)"sodium.options.view_bobbing.tooltip")).setControl(TickBoxControl::new).setBinding(new VanillaBooleanOptionBinding((OptionInstance<Boolean>)Minecraft.m_91087_().f_91066_.m_231830_())).build()).add(OptionImpl.createBuilder(AttackIndicatorStatus.class, vanillaOpts).setName((Component)Component.m_237115_((String)"options.attackIndicator")).setTooltip((Component)Component.m_237115_((String)"sodium.options.attack_indicator.tooltip")).setControl(opts -> new CyclingControl<AttackIndicatorStatus>((Option<AttackIndicatorStatus>)opts, AttackIndicatorStatus.class, new Component[]{Component.m_237115_((String)"options.off"), Component.m_237115_((String)"options.attack.crosshair"), Component.m_237115_((String)"options.attack.hotbar")})).setBinding((opts, value) -> opts.m_232120_().m_231514_(value), opts -> (AttackIndicatorStatus)opts.m_232120_().m_231551_()).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.autosaveIndicator")).setTooltip((Component)Component.m_237115_((String)"sodium.options.autosave_indicator.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.m_231834_().m_231514_(value), opts -> (Boolean)opts.m_231834_().m_231551_()).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"stat.generalButton"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage quality() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(GraphicsStatus.class, vanillaOpts).setName((Component)Component.m_237115_((String)"options.graphics")).setTooltip((Component)Component.m_237115_((String)"sodium.options.graphics_quality.tooltip")).setControl(option -> new CyclingControl<GraphicsStatus>((Option<GraphicsStatus>)option, GraphicsStatus.class, new Component[]{Component.m_237115_((String)"options.graphics.fast"), Component.m_237115_((String)"options.graphics.fancy"), Component.m_237115_((String)"options.graphics.fabulous")})).setBinding((opts, value) -> opts.m_232060_().m_231514_(value), opts -> (GraphicsStatus)opts.m_232060_().m_231551_()).setImpact(OptionImpact.HIGH).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(CloudStatus.class, vanillaOpts).setName((Component)Component.m_237115_((String)"options.renderClouds")).setTooltip((Component)Component.m_237115_((String)"sodium.options.clouds_quality.tooltip")).setControl(option -> new CyclingControl<CloudStatus>((Option<CloudStatus>)option, CloudStatus.class, new Component[]{Component.m_237115_((String)"options.off"), Component.m_237115_((String)"options.graphics.fast"), Component.m_237115_((String)"options.graphics.fancy")})).setBinding((opts, value) -> {
            RenderTarget framebuffer;
            opts.m_232050_().m_231514_(value);
            if (Minecraft.m_91085_() && (framebuffer = Minecraft.m_91087_().f_91060_.m_109832_()) != null) {
                framebuffer.m_83954_(Minecraft.f_91002_);
            }
        }, opts -> (CloudStatus)opts.m_232050_().m_231551_()).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((Component)Component.m_237115_((String)"soundCategory.weather")).setTooltip((Component)Component.m_237115_((String)"sodium.options.weather_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.weatherQuality = value;
        }, opts -> opts.quality.weatherQuality).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(SodiumGameOptions.GraphicsQuality.class, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.leaves_quality.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.leaves_quality.tooltip")).setControl(option -> new CyclingControl<SodiumGameOptions.GraphicsQuality>((Option<SodiumGameOptions.GraphicsQuality>)option, SodiumGameOptions.GraphicsQuality.class)).setBinding((opts, value) -> {
            opts.quality.leavesQuality = value;
        }, opts -> opts.quality.leavesQuality).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(ParticleStatus.class, vanillaOpts).setName((Component)Component.m_237115_((String)"options.particles")).setTooltip((Component)Component.m_237115_((String)"sodium.options.particle_quality.tooltip")).setControl(option -> new CyclingControl<ParticleStatus>((Option<ParticleStatus>)option, ParticleStatus.class, new Component[]{Component.m_237115_((String)"options.particles.all"), Component.m_237115_((String)"options.particles.decreased"), Component.m_237115_((String)"options.particles.minimal")})).setBinding((opts, value) -> opts.m_231929_().m_231514_(value), opts -> (ParticleStatus)opts.m_231929_().m_231551_()).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.ao")).setTooltip((Component)Component.m_237115_((String)"sodium.options.smooth_lighting.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.m_232070_().m_231514_(value), opts -> (Boolean)opts.m_232070_().m_231551_()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.biomeBlendRadius")).setTooltip((Component)Component.m_237115_((String)"sodium.options.biome_blend.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 1, 7, 1, ControlValueFormatter.biomeBlend())).setBinding((opts, value) -> opts.m_232121_().m_231514_(value), opts -> (Integer)opts.m_232121_().m_231551_()).setImpact(OptionImpact.LOW).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.entityDistanceScaling")).setTooltip((Component)Component.m_237115_((String)"sodium.options.entity_distance.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 50, 500, 25, ControlValueFormatter.percentage())).setBinding((opts, value) -> opts.m_232018_().m_231514_((Object)((double)value.intValue() / 100.0)), opts -> Math.round(((Double)opts.m_232018_().m_231551_()).floatValue() * 100.0f)).setImpact(OptionImpact.MEDIUM).build()).add(OptionImpl.createBuilder(Boolean.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.entityShadows")).setTooltip((Component)Component.m_237115_((String)"sodium.options.entity_shadows.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> opts.m_231818_().m_231514_(value), opts -> (Boolean)opts.m_231818_().m_231551_()).setImpact(OptionImpact.LOW).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.vignette.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.vignette.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.quality.enableVignette = value;
        }, opts -> opts.quality.enableVignette).setImpact(OptionImpact.LOW).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, vanillaOpts).setName((Component)Component.m_237115_((String)"options.mipmapLevels")).setTooltip((Component)Component.m_237115_((String)"sodium.options.mipmap_levels.tooltip")).setControl(option -> new SliderControl((Option<Integer>)option, 0, 4, 1, ControlValueFormatter.multiplier())).setBinding((opts, value) -> opts.m_232119_().m_231514_(value), opts -> (Integer)opts.m_232119_().m_231551_()).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_ASSET_RELOAD).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium.options.pages.quality"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    public static OptionPage performance() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.chunk_update_threads.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.chunk_update_threads.tooltip")).setControl(o -> new SliderControl((Option<Integer>)o, 0, Runtime.getRuntime().availableProcessors(), 1, ControlValueFormatter.quantityOrDisabled("threads", "Default"))).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.chunkBuilderThreads = value;
        }, opts -> opts.performance.chunkBuilderThreads).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.always_defer_chunk_updates.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.always_defer_chunk_updates.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.alwaysDeferChunkUpdates = value;
        }, opts -> opts.performance.alwaysDeferChunkUpdates).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.use_block_face_culling.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.use_block_face_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useBlockFaceCulling = value;
        }, opts -> opts.performance.useBlockFaceCulling).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.use_compact_vertex_format.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.use_compact_vertex_format.tooltip")).setControl(TickBoxControl::new).setEnabled(!SodiumClientMod.oculusLoaded).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useCompactVertexFormat = value;
        }, opts -> opts.performance.useCompactVertexFormat).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.use_fog_occlusion.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.use_fog_occlusion.tooltip")).setControl(TickBoxControl::new).setBinding((opts, value) -> {
            opts.performance.useFogOcclusion = value;
        }, opts -> opts.performance.useFogOcclusion).setImpact(OptionImpact.MEDIUM).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.use_entity_culling.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.use_entity_culling.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setBinding((opts, value) -> {
            opts.performance.useEntityCulling = value;
        }, opts -> opts.performance.useEntityCulling).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.animate_only_visible_textures.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.animate_only_visible_textures.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.HIGH).setBinding((opts, value) -> {
            opts.performance.animateOnlyVisibleTextures = value;
        }, opts -> opts.performance.animateOnlyVisibleTextures).setFlags(OptionFlag.REQUIRES_RENDERER_UPDATE).build()).add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.use_no_error_context.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.use_no_error_context.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.LOW).setBinding((opts, value) -> {
            opts.performance.useNoErrorGLContext = value;
        }, opts -> opts.performance.useNoErrorGLContext).setEnabled(SodiumGameOptionPages.supportsNoErrorContext()).setFlags(OptionFlag.REQUIRES_GAME_RESTART).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium.options.pages.performance"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }

    private static boolean supportsNoErrorContext() {
        GLCapabilities capabilities = GL.getCapabilities();
        return (capabilities.OpenGL46 || capabilities.GL_KHR_no_error) && !Workarounds.isWorkaroundEnabled(Workarounds.Reference.NO_ERROR_CONTEXT_UNSUPPORTED);
    }

    public static OptionPage advanced() {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.use_persistent_mapping.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.use_persistent_mapping.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.MEDIUM).setEnabled(MappedStagingBuffer.isSupported(RenderDevice.INSTANCE)).setBinding((opts, value) -> {
            opts.advanced.useAdvancedStagingBuffers = value;
        }, opts -> opts.advanced.useAdvancedStagingBuffers).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Integer.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.cpu_render_ahead_limit.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.cpu_render_ahead_limit.tooltip")).setControl(opt -> new SliderControl((Option<Integer>)opt, 0, 9, 1, ControlValueFormatter.translateVariable("sodium.options.cpu_render_ahead_limit.value"))).setBinding((opts, value) -> {
            opts.advanced.cpuRenderAheadLimit = value;
        }, opts -> opts.advanced.cpuRenderAheadLimit).build()).build());
        groups.add(OptionGroup.createBuilder().add(OptionImpl.createBuilder(Boolean.TYPE, sodiumOpts).setName((Component)Component.m_237115_((String)"sodium.options.translucent_face_sorting.name")).setTooltip((Component)Component.m_237115_((String)"sodium.options.translucent_face_sorting.tooltip")).setControl(TickBoxControl::new).setImpact(OptionImpact.VARIES).setBinding((opts, value) -> {
            opts.performance.useTranslucentFaceSorting = value;
        }, opts -> opts.performance.useTranslucentFaceSorting).setFlags(OptionFlag.REQUIRES_RENDERER_RELOAD).build()).build());
        return new OptionPage((Component)Component.m_237115_((String)"sodium.options.pages.advanced"), (ImmutableList<OptionGroup>)ImmutableList.copyOf(groups));
    }
}

