/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketGenderInfo;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class PacketSync
extends PacketGenderInfo {
    public PacketSync(GenderPlayer plr) {
        super(plr);
    }

    public PacketSync(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public static void handle(PacketSync packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91074_ == null || !packet.uuid.equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                GenderPlayer plr = WildfireGender.getOrAddPlayerById(packet.uuid);
                packet.updatePlayerFromPacket(plr);
                plr.syncStatus = GenderPlayer.SyncStatus.SYNCED;
                plr.lockSettings = true;
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void sendToOthers(ServerPlayer player, GenderPlayer genderPlayer) {
        MinecraftServer server = player.m_20194_();
        if (genderPlayer != null && server != null) {
            PacketSync syncPacket = new PacketSync(genderPlayer);
            for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
                if (player.m_20148_().equals(serverPlayer.m_20148_())) continue;
                WildfireGender.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)syncPacket);
            }
        }
    }

    public static void sendTo(ServerPlayer player) {
        PacketDistributor.PacketTarget target = PacketDistributor.PLAYER.with(() -> player);
        for (Map.Entry<UUID, GenderPlayer> entry : WildfireGender.CLOTHING_PLAYERS.entrySet()) {
            UUID uuid = entry.getKey();
            if (player.m_20148_().equals(uuid)) continue;
            WildfireGender.NETWORK.send(target, (Object)new PacketSync(entry.getValue()));
        }
    }
}

