/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonWriter;
import com.wildfire.main.config.ConfigKey;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.loading.FMLPaths;

public class Configuration {
    private static final TypeAdapter<JsonObject> ADAPTER = new Gson().getAdapter(JsonObject.class);
    private final File CFG_FILE;
    public JsonObject SAVE_VALUES = new JsonObject();

    public Configuration(String saveLoc, String cfgName) {
        Path saveDir = FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get().resolve(saveLoc));
        this.CFG_FILE = saveDir.resolve(cfgName + ".json").toFile();
    }

    public void finish() {
        if (this.CFG_FILE.exists()) {
            this.load();
            this.updateConfig();
        }
    }

    public <TYPE> void set(ConfigKey<TYPE> key, TYPE value) {
        key.save(this.SAVE_VALUES, value);
    }

    public <TYPE> void setDefault(ConfigKey<TYPE> key) {
        if (!this.SAVE_VALUES.has(key.key)) {
            this.set(key, key.defaultValue);
        }
    }

    public <TYPE> TYPE get(ConfigKey<TYPE> key) {
        return key.read(this.SAVE_VALUES);
    }

    public void removeParameter(ConfigKey<?> key) {
        this.removeParameter(key.key);
    }

    public void removeParameter(String key) {
        this.SAVE_VALUES.remove(key);
    }

    public void updateConfig() {
        JsonObject obj;
        try (FileReader configurationFile = new FileReader(this.CFG_FILE);){
            obj = GsonHelper.m_13859_((Reader)configurationFile);
            for (Map.Entry entry : this.SAVE_VALUES.entrySet()) {
                obj.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        catch (Exception ignored) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.CFG_FILE);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            ADAPTER.write(jsonWriter, (Object)obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.CFG_FILE);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            ADAPTER.write(jsonWriter, (Object)this.SAVE_VALUES);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void load() {
        try (FileReader configurationFile = new FileReader(this.CFG_FILE);){
            JsonObject obj = GsonHelper.m_13859_((Reader)configurationFile);
            for (Map.Entry entry : obj.entrySet()) {
                String key = (String)entry.getKey();
                this.SAVE_VALUES.add(key, (JsonElement)entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

