/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.networking.PacketGenderInfo;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.main.networking.PacketSync;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod(value="wildfire_gender")
public class WildfireGender {
    public static final String VERSION = "2.8";
    public static final String MODID = "wildfire_gender";
    public static boolean modEnabled = true;
    public static final boolean SYNCING_ENABLED = false;
    private static final String PROTOCOL_VERSION = "2";
    public static SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("wildfire_gender", "main_channel")).clientAcceptedVersions(v -> v.equals(NetworkRegistry.ABSENT) || v.equals(NetworkRegistry.ACCEPTVANILLA) || v.equals(PROTOCOL_VERSION)).serverAcceptedVersions(v -> v.equals(NetworkRegistry.ACCEPTVANILLA) || v.equals(PROTOCOL_VERSION)).networkProtocolVersion(() -> "2").simpleChannel();
    public static Map<UUID, GenderPlayer> CLOTHING_PLAYERS = new HashMap<UUID, GenderPlayer>();

    public WildfireGender() {
        Path configDir = FMLPaths.GAMEDIR.get().resolve(FMLPaths.CONFIGDIR.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoginEvent);
    }

    @Nullable
    public static GenderPlayer getPlayerById(UUID id) {
        return CLOTHING_PLAYERS.get(id);
    }

    public static GenderPlayer getOrAddPlayerById(UUID id) {
        return CLOTHING_PLAYERS.computeIfAbsent(id, GenderPlayer::new);
    }

    public void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(1, PacketSync.class, PacketGenderInfo::encode, PacketSync::new, PacketSync::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(2, PacketSendGenderInfo.class, PacketGenderInfo::encode, PacketSendGenderInfo::new, PacketSendGenderInfo::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    public void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!player.m_9236_().m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketSync.sendTo(sp);
        }
    }

    public static void loadGenderInfoAsync(UUID uuid, boolean markForSync) {
        Thread thread = new Thread(() -> WildfireGender.loadGenderInfo(uuid, markForSync));
        thread.setName("WFGM_GetPlayer-" + uuid);
        thread.start();
    }

    public static void refreshAllGenders() {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
    }

    public static GenderPlayer loadGenderInfo(UUID uuid, boolean markForSync) {
        return GenderPlayer.loadCachedPlayer(uuid, markForSync);
    }
}

