/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wildfire.api.IGenderArmor;
import com.wildfire.gui.screen.WildfirePlayerListScreen;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.WildfireHelper;
import com.wildfire.main.WildfireSounds;
import com.wildfire.main.networking.PacketSendGenderInfo;
import com.wildfire.render.GenderLayer;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Holder;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.network.NetworkHooks;

public class WildfireEventHandler {
    public static final KeyMapping toggleEditGUI = new KeyMapping("key.wildfire_gender.gender_menu", 71, "category.wildfire_gender.generic");
    private int toastTick = 0;
    private boolean showedToast = false;
    int timer = 0;
    private final Set<SoundEvent> playerHurtSounds = Set.of(SoundEvents.f_12323_, SoundEvents.f_12324_, SoundEvents.f_144205_, SoundEvents.f_12273_, SoundEvents.f_12274_);

    @SubscribeEvent
    public void onGUI(TickEvent.ClientTickEvent evt) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            WildfireGender.CLOTHING_PLAYERS.clear();
            this.toastTick = 0;
        } else if (this.toastTick > 100 && !this.showedToast) {
            Minecraft.m_91087_().m_91300_().m_94922_(new Toast(){

                public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent component, long p_94898_) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    graphics.m_280218_(f_94893_, 0, 0, 0, 0, this.m_7828_(), this.m_94899_());
                    Font font = component.m_94929_().f_91062_;
                    graphics.m_280614_(font, (Component)Component.m_237115_((String)"category.wildfire_gender.generic"), 0, 7, -16777216, false);
                    graphics.m_280614_(font, (Component)Component.m_237110_((String)"toast.wildfire_gender.get_started", (Object[])new Object[]{toggleEditGUI.m_90863_()}), 0, 18, -1, false);
                    return Toast.Visibility.SHOW;
                }
            });
            this.showedToast = true;
        }
        boolean isVanillaServer = true;
        try {
            ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
            isVanillaServer = connection != null && NetworkHooks.isVanillaConnection((Connection)connection.m_104910_());
        }
        catch (Exception connection) {
            // empty catch block
        }
        if (!isVanillaServer) {
            ++this.timer;
            if (this.timer >= 5) {
                try {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (player == null) {
                        return;
                    }
                    GenderPlayer aPlr = WildfireGender.getPlayerById(player.m_20148_());
                    if (aPlr == null || !aPlr.needsSync) {
                        return;
                    }
                    PacketSendGenderInfo.send(aPlr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timer = 0;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.side.isClient()) {
            GenderPlayer aPlr = WildfireGender.getPlayerById(evt.player.m_20148_());
            if (aPlr == null) {
                return;
            }
            IGenderArmor armor = WildfireHelper.getArmorConfig(evt.player.m_6844_(EquipmentSlot.CHEST));
            aPlr.getLeftBreastPhysics().update(evt.player, armor);
            aPlr.getRightBreastPhysics().update(evt.player, armor);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key evt) {
        if (toggleEditGUI.m_90857_() && WildfireGender.modEnabled) {
            WildfireGender.refreshAllGenders();
            Minecraft.m_91087_().m_91152_((Screen)new WildfirePlayerListScreen());
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent evt) {
        AbstractClientPlayer plr;
        UUID uuid;
        GenderPlayer aPlr;
        Entity entity;
        if (evt.getLevel().f_46443_ && (entity = evt.getEntity()) instanceof AbstractClientPlayer && (aPlr = WildfireGender.getPlayerById(uuid = (plr = (AbstractClientPlayer)entity).m_20148_())) == null) {
            aPlr = new GenderPlayer(uuid);
            WildfireGender.CLOTHING_PLAYERS.put(uuid, aPlr);
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            WildfireGender.loadGenderInfoAsync(uuid, player != null && uuid.equals(player.m_20148_()));
            WildfireGender.refreshAllGenders();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlaySound(PlayLevelSoundEvent.AtEntity event) {
        Entity entity;
        SoundEvent soundEvent;
        Holder soundHolder = event.getSound();
        if (soundHolder != null && this.playerHurtSounds.contains(soundEvent = (SoundEvent)soundHolder.get()) && (entity = event.getEntity()) instanceof Player) {
            Player p = (Player)entity;
            if (p.m_9236_().f_46443_) {
                event.setCanceled(true);
                if (p.f_20916_ == p.f_20917_ && p.f_20916_ > 0) {
                    GenderPlayer plr = WildfireGender.getPlayerById(p.m_20148_());
                    if (plr != null && plr.hasHurtSounds() && plr.getGender().hasFemaleHurtSounds()) {
                        soundEvent = Math.random() > 0.5 ? WildfireSounds.FEMALE_HURT1 : WildfireSounds.FEMALE_HURT2;
                    }
                } else {
                    LocalPlayer player = Minecraft.m_91087_().f_91074_;
                    if (player != null && p.m_20148_().equals(player.m_20148_())) {
                        return;
                    }
                }
                p.m_9236_().m_7785_(p.m_20185_(), p.m_20186_(), p.m_20189_(), soundEvent, event.getSource(), event.getNewVolume(), event.getNewPitch(), false);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="wildfire_gender")
    private static class ClientModEventBusListeners {
        private ClientModEventBusListeners() {
        }

        @SubscribeEvent
        public static void entityLayers(EntityRenderersEvent.AddLayers event) {
            for (String skinName : event.getSkins()) {
                LivingEntityRenderer renderer = event.getSkin(skinName);
                if (renderer == null) continue;
                renderer.m_115326_((RenderLayer)new GenderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer, Minecraft.m_91087_().m_91289_().m_110907_().m_110881_()));
            }
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
            MinecraftForge.EVENT_BUS.register((Object)new WildfireEventHandler());
        }

        @SubscribeEvent
        public static void registerKeybindings(RegisterKeyMappingsEvent event) {
            event.register(toggleEditGUI);
        }
    }
}

