/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;

public class EmiGrindstoneDisenchantingBookRecipe
implements EmiRecipe {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("minecraft", "textures/gui/container/grindstone.png");
    private final Enchantment enchantment;
    private final int level;
    private final ResourceLocation id;

    public EmiGrindstoneDisenchantingBookRecipe(Enchantment enchantment, int level, ResourceLocation id) {
        this.enchantment = enchantment;
        this.level = level;
        this.id = id;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.GRINDING;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return List.of(this.getBook());
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemLike)Items.f_42517_));
    }

    @Override
    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public int getDisplayWidth() {
        return 116;
    }

    @Override
    public int getDisplayHeight() {
        return 56;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, 116, 56, 30, 15);
        widgets.addText(this.getExp(), 114, 39, -1, true).horizontalAlign(TextWidget.Alignment.END);
        widgets.addSlot(this.getBook(), 18, 3).drawBack(false);
        widgets.addSlot(EmiStack.of((ItemLike)Items.f_42517_), 98, 18).drawBack(false).recipeContext(this);
    }

    private EmiStack getBook() {
        ItemStack enchantedTool = new ItemStack((ItemLike)Items.f_42690_);
        enchantedTool.m_41663_(this.enchantment, this.level);
        ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
        CompoundTag tag = new CompoundTag();
        ListTag StoredEnchantments = new ListTag();
        CompoundTag enchant = new CompoundTag();
        String id = enchantedTool.m_41783_().m_128437_("Enchantments", 10).m_128728_(0).m_128461_("id");
        enchant.m_128359_("id", id);
        enchant.m_128376_("lvl", (short)this.level);
        StoredEnchantments.add((Object)enchant);
        tag.m_128365_("StoredEnchantments", (Tag)StoredEnchantments);
        book.m_41751_(tag);
        return EmiStack.of(book);
    }

    private FormattedCharSequence getExp() {
        int minPower = this.enchantment.m_6183_(this.level);
        int minXP = (int)Math.ceil((double)minPower / 2.0);
        int maxXP = 2 * minXP - 1;
        return EmiPort.ordered((Component)EmiPort.translatable("emi.grinding.experience", minXP, maxXP));
    }
}

