/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.mixin.jei;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import mezz.jei.api.IModPlugin;
import mezz.jei.library.load.PluginCaller;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Pseudo
@Mixin(value={PluginCaller.class})
public class PluginCallerMixin {
    @Unique
    private static final Set<ResourceLocation> SKIPPED = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation("jei", "minecraft"), new ResourceLocation("jei", "gui"), new ResourceLocation("jei", "fabric_gui"), new ResourceLocation("jei", "forge_gui")});

    @Redirect(at=@At(value="INVOKE", target="java/util/function/Consumer.accept(Ljava/lang/Object;)V"), method={"callOnPlugins"}, remap=false)
    private static void callOnPlugins(Consumer<IModPlugin> target, Object value, String title, List<IModPlugin> plugins, Consumer<IModPlugin> func) {
        IModPlugin plugin = (IModPlugin)value;
        if (SKIPPED.contains(plugin.getPluginUid())) {
            switch (title) {
                case "Registering categories": {
                    break;
                }
                case "Registering ingredients": {
                    break;
                }
                case "Registering vanilla category extensions": {
                    break;
                }
                case "Sending Runtime": {
                    break;
                }
                case "Sending Runtime Unavailable": {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        target.accept(plugin);
    }
}

