/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.jemi.impl;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.jemi.JemiUtil;
import dev.emi.emi.jemi.impl.JemiRecipeSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class JemiIngredientAcceptor
implements IIngredientAcceptor<JemiIngredientAcceptor> {
    public static final Pattern FLUID_END = Pattern.compile("(^|\\s)([\\d,]+)\\s*mB$");
    public final RecipeIngredientRole role;
    public final List<EmiStack> stacks = Lists.newArrayList();

    public JemiIngredientAcceptor(RecipeIngredientRole role) {
        this.role = role;
    }

    public void coerceStacks(IRecipeSlotTooltipCallback tooltipCallback, Map<IIngredientType<?>, JemiRecipeSlot.IngredientRenderer<?>> renderers) {
        if (tooltipCallback == null && renderers == null) {
            return;
        }
        for (EmiStack stack : this.stacks) {
            ITypedIngredient typed = JemiUtil.getTyped(stack).orElse(null);
            if (typed == null || !(stack instanceof JemiStack) && !(stack.getKey() instanceof Fluid)) continue;
            ArrayList base = Lists.newArrayList();
            if (renderers != null && renderers.containsKey(typed.getType())) {
                base.addAll(renderers.get(typed.getType()).renderer().getTooltip(typed.getIngredient(), (TooltipFlag)TooltipFlag.Default.f_256752_));
            }
            if (base == null || base.isEmpty()) {
                if (tooltipCallback == null) continue;
                base.add(stack.getName());
                base.add(EmiPort.literal(""));
            }
            if (tooltipCallback != null) {
                JemiRecipeSlot jsr = new JemiRecipeSlot(this.role, stack);
                tooltipCallback.onTooltip((IRecipeSlotView)jsr, (List)base);
            }
            for (int i = 0; i < 2 && i < base.size(); ++i) {
                long amount;
                Matcher m;
                Component t = (Component)base.get(i);
                if (t == null || !(m = FLUID_END.matcher(t.getString())).find() || (amount = Long.parseLong(m.group(2).replace(",", ""))) == stack.getAmount()) continue;
                stack.setAmount(amount);
            }
        }
    }

    public EmiIngredient build() {
        return EmiIngredient.of(this.stacks);
    }

    private void addStack(EmiStack stack) {
        if (!stack.isEmpty()) {
            this.stacks.add(stack);
        }
    }

    public <I> JemiIngredientAcceptor addIngredients(IIngredientType<I> ingredientType, List<@Nullable I> ingredients) {
        for (I i : ingredients) {
            this.addIngredient((IIngredientType)ingredientType, (Object)i);
        }
        return this;
    }

    public <I> JemiIngredientAcceptor addIngredient(IIngredientType<I> ingredientType, I ingredient) {
        this.addStack(JemiUtil.getStack(ingredientType, ingredient));
        return this;
    }

    public JemiIngredientAcceptor addIngredientsUnsafe(List<?> ingredients) {
        for (Object o : ingredients) {
            this.addStack(JemiUtil.getStack(o));
        }
        return this;
    }

    public JemiIngredientAcceptor addFluidStack(Fluid fluid, long amount) {
        this.addStack(EmiStack.of(fluid, amount));
        return this;
    }

    public JemiIngredientAcceptor addFluidStack(Fluid fluid, long amount, CompoundTag tag) {
        this.addStack(EmiStack.of(fluid, tag, amount));
        return this;
    }
}

