/*
 * Decompiled with CFR 0.152.
 */
package com.imjustdoom.villagerinabucket.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class VillagerBucket
extends MobBucketItem {
    private final Fluid content;

    public VillagerBucket(EntityType<?> entityType, Fluid fluid, SoundEvent soundEvent, Item.Properties properties) {
        super(entityType, fluid, soundEvent, properties);
        this.content = fluid;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = VillagerBucket.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.f_76191_ ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        if (level.m_7966_(player, blockPos)) {
            this.m_142131_(player, level, itemStack, blockPos);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockPos, itemStack);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)VillagerBucket.m_40699_((ItemStack)itemStack, (Player)player), (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null) {
            ChatFormatting[] chatFormattings = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY};
            CompoundTag data = compoundTag.m_128469_("VillagerData");
            if (data.m_128441_("level")) {
                list.add((Component)Component.m_237115_((String)("Level: " + data.m_128451_("level"))).m_130944_(chatFormattings));
            }
            if (data.m_128441_("type")) {
                String region = I18n.m_118938_((String)("biome.minecraft." + data.m_128461_("type").split(":")[1]), (Object[])new Object[0]);
                list.add((Component)Component.m_237115_((String)("Region: " + region)).m_130944_(chatFormattings));
            }
            if (data.m_128441_("profession")) {
                String profession = I18n.m_118938_((String)("entity.minecraft.villager." + data.m_128461_("profession").split(":")[1]), (Object[])new Object[0]);
                list.add((Component)Component.m_237115_((String)("Profession: " + profession)).m_130944_(chatFormattings));
            }
            if (compoundTag.m_128441_("Age") && compoundTag.m_128451_("Age") < 0) {
                list.add((Component)Component.m_237113_((String)"Baby").m_130944_(chatFormattings));
            }
        }
    }
}

