/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class VersionUtils {
    private static final List<Predicate<String>> VERSION_PREDICATES = new ArrayList<Predicate<String>>();
    public static final ArtifactVersion MINECRAFT_VERSION;
    public static final int MAJOR;
    public static final int MINOR;
    public static final int PATCH;

    public static boolean shouldApplyCompatibilityMixin(String mixinClassName) {
        if (mixinClassName.contains(".compat")) {
            for (Predicate<String> predicate : VERSION_PREDICATES) {
                if (!predicate.test(mixinClassName)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        int[][] ranges = new int[][]{{1, 14, 4}, {1, 15, 2}, {1, 16, 5}, {1, 17, 1}, {1, 18, 2}, {1, 19, 4}, {1, 20, 5}, {1, 21, 0}};
        String prefix = ".compat%s%s";
        for (int[] range : ranges) {
            int major = range[0];
            int minor = range[1];
            String predicatePrefix = String.format(".compat%s%s", major, minor);
            String predicateMinor = predicatePrefix + ".";
            String predicateMinorPlus = predicatePrefix + "plus.";
            String predicateMinorMinus = predicatePrefix + "minus.";
            String predicateMinorZero = predicatePrefix + "0.";
            String predicateMinorZeroMinus = predicatePrefix + "0minus.";
            VERSION_PREDICATES.add(n -> n.contains(predicateMinor) && MINOR != minor);
            VERSION_PREDICATES.add(n -> n.contains(predicateMinorPlus) && MINOR < minor);
            VERSION_PREDICATES.add(n -> n.contains(predicateMinorMinus) && MINOR > minor);
            VERSION_PREDICATES.add(n -> n.contains(predicateMinorZero) && (MINOR != minor || PATCH != 0));
            VERSION_PREDICATES.add(n -> n.contains(predicateMinorZeroMinus) && (MINOR > minor || MINOR == minor && PATCH > 0));
            int maxPatch = range[2];
            int i = 1;
            while (i <= maxPatch) {
                int patch = i++;
                String predicatePatch = predicatePrefix + patch + ".";
                String predicatePatchPlus = predicatePrefix + patch + "plus.";
                String predicatePatchMinus = predicatePrefix + patch + "minus.";
                VERSION_PREDICATES.add(n -> n.contains(predicatePatch) && (MINOR != minor || PATCH != patch));
                VERSION_PREDICATES.add(n -> n.contains(predicatePatchPlus) && (MINOR < minor || MINOR == minor && PATCH < patch));
                VERSION_PREDICATES.add(n -> n.contains(predicatePatchMinus) && (MINOR > minor || MINOR == minor && PATCH > patch));
            }
        }
        MINECRAFT_VERSION = new DefaultArtifactVersion(MCPVersion.getMCVersion());
        MAJOR = MINECRAFT_VERSION.getMajorVersion();
        MINOR = MINECRAFT_VERSION.getMinorVersion();
        PATCH = MINECRAFT_VERSION.getIncrementalVersion();
    }
}

