/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.mixin;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.SimplySwords;
import net.sweenus.simplyswords.compat.eldritch_end.EldritchEndCompatMethods;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"isDead"}, cancellable=true)
    public void simplyswords$tick(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Level world = player.m_9236_();
            ItemStack stack = player.m_21205_();
            if (player.m_21223_() <= 0.0f && !player.m_36335_().m_41519_(stack.m_41720_()) && (stack.m_150930_((Item)ItemsRegistry.WAXWEAVER.get()) || stack.m_150930_((Item)ItemsRegistry.WICKPIERCER.get()))) {
                int skillCooldown = (int)Config.getFloat("waxweaveCooldown", "UniqueEffects", ConfigDefaultValues.waxweaveCooldown);
                player.m_21153_(player.m_21233_());
                HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19606_, 100, 2, 3);
                player.m_36335_().m_41524_(stack.m_41720_(), skillCooldown);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), player.m_5720_(), 0.7f, 1.0f);
                world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.SPELL_MISC_02.get(), player.m_5720_(), 0.8f, 1.0f);
                cir.setReturnValue((Object)false);
            }
        }
    }

    @ModifyVariable(method={"modifyAppliedDamage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float simplyswords$modifyDamageAmount(float amount, DamageSource source) {
        LivingEntity livingEntity = (LivingEntity)this;
        MobEffectInstance voidcloakEffect = livingEntity.m_21124_((MobEffect)EffectRegistry.VOIDCLOAK.get());
        if (voidcloakEffect != null) {
            int amplifier = voidcloakEffect.m_19564_();
            float reductionFactor = 1.0f - (float)(amplifier + 1) * 0.1f;
            amount *= reductionFactor;
            HelperMethods.decrementStatusEffect(livingEntity, (MobEffect)EffectRegistry.VOIDCLOAK.get());
        }
        return amount;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void simplyswords$tick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.m_9236_().m_5776_() && SimplySwords.passVersionCheck("eldritch_end", SimplySwords.minimumEldritchEndVersion) && BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation("simplyswords:voidhunger")) != null) {
            EldritchEndCompatMethods.generateVoidcloakStacks(livingEntity);
        }
    }
}

