/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class TempestSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public TempestSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            int vortexMaxStacks = (int)Config.getFloat("vortexMaxStacks", "UniqueEffects", ConfigDefaultValues.vortexMaxStacks);
            ServerLevel serverWorld = (ServerLevel)attacker.m_9236_();
            HelperMethods.playHitSounds(attacker, target);
            ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
            sounds.add((SoundEvent)SoundRegistry.SPELL_FIRE.get());
            sounds.add((SoundEvent)SoundRegistry.ELEMENTAL_SWORD_WATER_ATTACK_03.get());
            sounds.add((SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get());
            sounds.add((SoundEvent)SoundRegistry.ELEMENTAL_BOW_WATER_SHOOT_IMPACT_02.get());
            ArrayList<SimpleParticleType> particles = new ArrayList<SimpleParticleType>();
            particles.add(ParticleTypes.f_123762_);
            particles.add(ParticleTypes.f_123796_);
            particles.add(ParticleTypes.f_123762_);
            particles.add(ParticleTypes.f_123796_);
            ArrayList<MobEffect> status = new ArrayList<MobEffect>();
            status.add((MobEffect)EffectRegistry.FIRE_VORTEX.get());
            status.add((MobEffect)EffectRegistry.FROST_VORTEX.get());
            status.add((MobEffect)EffectRegistry.FIRE_VORTEX.get());
            status.add((MobEffect)EffectRegistry.FROST_VORTEX.get());
            int random = attacker.m_217043_().m_188503_(3);
            SoundEvent soundSelect = (SoundEvent)sounds.get(random);
            ParticleOptions particleSelect = (ParticleOptions)particles.get(random);
            MobEffect statusSelect = (MobEffect)status.get(random);
            int particleCount = 10;
            HelperMethods.spawnWaistHeightParticles(serverWorld, particleSelect, (Entity)attacker, (Entity)target, particleCount);
            serverWorld.m_5594_(null, attacker.m_20183_(), soundSelect, attacker.m_5720_(), 0.2f, 1.3f);
            SimplySwordsStatusEffectInstance effect = HelperMethods.incrementSimplySwordsStatusEffect(target, statusSelect, 500, 1, vortexMaxStacks);
            effect.setSourceEntity(attacker);
            effect.setAdditionalData((int)this.m_43299_() / 3);
            target.m_7292_((MobEffectInstance)effect);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_() && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            int vortexMaxSize = (int)Config.getFloat("vortexMaxSize", "UniqueEffects", ConfigDefaultValues.vortexMaxSize);
            int vortexDuration = (int)Config.getFloat("vortexDuration", "UniqueEffects", ConfigDefaultValues.vortexDuration);
            int vortexSpellScaling = (int)Config.getFloat("vortexSpellScaling", "UniqueEffects", ConfigDefaultValues.vortexSpellScaling);
            int skillCooldown = 200;
            AABB box = HelperMethods.createBox((Entity)user, 15);
            boolean soundHasPlayed = false;
            for (Entity entity : serverWorld.m_6249_((Entity)user, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user) || !le.m_21023_((MobEffect)EffectRegistry.FIRE_VORTEX.get()) || !le.m_21023_((MobEffect)EffectRegistry.FROST_VORTEX.get())) continue;
                MobEffectInstance frostVortex = le.m_21124_((MobEffect)EffectRegistry.FROST_VORTEX.get());
                MobEffectInstance fireVortex = le.m_21124_((MobEffect)EffectRegistry.FIRE_VORTEX.get());
                int totalAmplifier = 0;
                if (fireVortex != null && frostVortex != null) {
                    totalAmplifier = fireVortex.m_19564_() + frostVortex.m_19564_();
                }
                int particleCount = 10;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.f_123796_, (Entity)le, (Entity)user, particleCount);
                if (!soundHasPlayed) {
                    serverWorld.m_5594_(null, le.m_20183_(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_22.get(), le.m_5720_(), 0.4f, 1.3f);
                    soundHasPlayed = true;
                }
                SimplySwordsStatusEffectInstance status = HelperMethods.incrementSimplySwordsStatusEffect((LivingEntity)user, (MobEffect)EffectRegistry.ELEMENTAL_VORTEX.get(), vortexDuration, totalAmplifier, vortexMaxSize);
                status.setAdditionalData(Math.max(1, totalAmplifier));
                status.setSourceEntity((LivingEntity)user);
                le.m_21195_((MobEffect)EffectRegistry.FIRE_VORTEX.get());
                le.m_21195_((MobEffect)EffectRegistry.FROST_VORTEX.get());
                user.m_36335_().m_41524_((Item)this, skillCooldown);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123795_, ParticleTypes.f_123774_, ParticleTypes.f_123772_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip10").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.tempestsworditem.tooltip11").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

