/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FireSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public FireSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            ServerLevel world = (ServerLevel)attacker.m_9236_();
            int fhitchance = (int)Config.getFloat("brimstoneChance", "UniqueEffects", ConfigDefaultValues.brimstoneChance);
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.m_217043_().m_188503_(100) <= fhitchance && attacker instanceof Player) {
                int choose_sound = (int)(Math.random() * 3.0);
                BlockPos position = target.m_20183_();
                for (int i = 0; i < 5 * choose_sound; ++i) {
                    HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123756_, position.m_123341_(), (double)position.m_123342_() + 0.5, position.m_123343_(), choose_sound, 0.5 + (double)choose_sound, choose_sound);
                    HelperMethods.spawnParticle((Level)world, (ParticleOptions)ParticleTypes.f_123762_, position.m_123341_(), (double)position.m_123342_() + 0.5, position.m_123343_(), 0.0, 0.0, 0.0);
                }
                world.m_254849_((Entity)attacker, target.m_20185_(), target.m_20186_(), target.m_20189_(), (float)choose_sound, Level.ExplosionInteraction.NONE);
                target.m_20254_(3);
                if (choose_sound <= 1) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), target.m_5720_(), 0.5f, 1.2f);
                }
                if (choose_sound == 2) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), target.m_5720_(), 0.7f, 1.1f);
                }
                if (choose_sound == 3) {
                    world.m_6269_(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), target.m_5720_(), 0.9f, 1.0f);
                }
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123801_, ParticleTypes.f_123801_, ParticleTypes.f_123762_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style TEXT = HelperMethods.getStyle("text");
        Style ABILITY = HelperMethods.getStyle("ability");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.firesworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.firesworditem.tooltip2").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

