/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import elocindev.necronomicon.api.text.TextAPI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class DreadtideSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;

    public DreadtideSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        if (!user.m_9236_().m_5776_() && world instanceof ServerLevel) {
            MobEffectInstance voidcloakEffect;
            LivingEntity ee;
            ServerLevel serverWorld = (ServerLevel)world;
            int voidcallerDuration = (int)Config.getFloat("voidcallerDuration", "UniqueEffects", ConfigDefaultValues.voidcallerDuration);
            float voidcallerDamageModifier = Config.getFloat("voidcallerDamageModifier", "UniqueEffects", ConfigDefaultValues.voidcallerDamageModifier);
            int skillCooldown = 20;
            AABB box = HelperMethods.createBox((Entity)user, 10);
            Entity closestEntity = world.m_6249_((Entity)user, box, EntitySelector.f_20403_).stream().min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)user))).orElse(null);
            if (closestEntity != null && closestEntity instanceof LivingEntity && HelperMethods.checkFriendlyFire(ee = (LivingEntity)closestEntity, (LivingEntity)user) && (voidcloakEffect = user.m_21124_((MobEffect)EffectRegistry.VOIDCLOAK.get())) != null) {
                SoundEvent soundSelect = (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_04.get();
                ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_04.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_12.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_15.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_VOICE_20.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_02.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_02.get());
                sounds.add((SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_02.get());
                if (sounds.get(voidcloakEffect.m_19564_()) != null) {
                    soundSelect = (SoundEvent)sounds.get(Math.min(5, voidcloakEffect.m_19564_()));
                }
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles(serverWorld, (ParticleOptions)ParticleTypes.f_123762_, (Entity)user, (Entity)ee, particleCount);
                world.m_5594_(null, user.m_20183_(), soundSelect, user.m_5720_(), 0.3f, 1.3f);
                SimplySwordsStatusEffectInstance voidAssaultEffect = new SimplySwordsStatusEffectInstance((MobEffect)EffectRegistry.VOIDASSAULT.get(), voidcallerDuration, voidcloakEffect.m_19564_(), false, false, true);
                voidAssaultEffect.setSourceEntity((LivingEntity)user);
                voidAssaultEffect.setAdditionalData((int)(this.m_43299_() * voidcallerDamageModifier));
                ee.m_7292_((MobEffectInstance)voidAssaultEffect);
                user.m_21195_((MobEffect)EffectRegistry.VOIDCLOAK.get());
                user.m_36335_().m_41524_((Item)this, skillCooldown);
            }
        }
        return super.m_7203_(world, user, hand);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, ParticleTypes.f_123757_, ParticleTypes.f_123757_, ParticleTypes.f_123757_, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        MutableComponent name = Component.m_237115_((String)stack.m_41778_());
        Style bold = name.m_7383_().m_131136_(Boolean.valueOf(true));
        return TextAPI.Styles.getGradient((Component)Component.m_237115_((String)this.m_5671_(stack)).m_6270_(bold), (int)1, (int)6043781, (int)12088090, (float)1.0f);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style CORRUPTED_LIGHT = HelperMethods.getStyle("corrupted_light");
        Style CORRUPTED_ABILITY = HelperMethods.getStyle("corrupted_ability");
        Style TEXT = HelperMethods.getStyle("corrupted_text");
        MutableComponent ability_icon = Component.m_237119_().m_130946_("\ua996 ");
        MutableComponent type = TextAPI.Styles.getGradient((Component)Component.m_237115_((String)"item.eldritch_end.xalarath.type"), (int)1, (int)6043781, (int)9326287, (float)1.0f);
        tooltip.add((Component)Component.m_237113_((String)"\ua999 ").m_7220_((Component)type.m_130948_(type.m_7383_().m_131162_(Boolean.valueOf(true)))));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip1").m_6270_(CORRUPTED_ABILITY));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)ability_icon.m_7220_((Component)Component.m_237115_((String)"item.simplyswords.onrightclick").m_6270_(CORRUPTED_LIGHT)));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip10").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip11").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237113_((String)"\ua999 ").m_7220_((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip12").m_6270_(HelperMethods.getStyle("corrupted"))));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.dreadtidesworditem.tooltip13").m_6270_(HelperMethods.getStyle("corrupted")));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

