/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.effect.OrbitingEffect;
import net.sweenus.simplyswords.effect.instance.SimplySwordsStatusEffectInstance;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class FrostVortexEffect
extends OrbitingEffect {
    public LivingEntity sourceEntity;
    public int additionalData;

    public FrostVortexEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
        this.setParticleType((ParticleOptions)ParticleTypes.f_175821_);
    }

    public void setSourcePlayer(LivingEntity livingEntity) {
        this.sourceEntity = livingEntity;
    }

    public void setAdditionalData(int data) {
        this.additionalData = data;
    }

    @Override
    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)livingEntity.m_9236_();
            float abilityDamage = 0.0f;
            MobEffectInstance mobEffectInstance = livingEntity.m_21124_((MobEffect)EffectRegistry.FROST_VORTEX.get());
            if (mobEffectInstance instanceof SimplySwordsStatusEffectInstance) {
                SimplySwordsStatusEffectInstance statusEffect = (SimplySwordsStatusEffectInstance)mobEffectInstance;
                this.sourceEntity = statusEffect.getSourceEntity();
                this.additionalData = statusEffect.getAdditionalData();
            }
            if (livingEntity.f_19797_ % Math.max(1, 15 - amplifier) == 0 && this.additionalData != 0) {
                DamageSource damageSource = livingEntity.m_269291_().m_269425_();
                livingEntity.f_19802_ = 0;
                if (this.sourceEntity != null) {
                    damageSource = livingEntity.m_269291_().m_269104_((Entity)livingEntity, (Entity)this.sourceEntity);
                    float spellScalingModifier = Config.getFloat("vortexSpellScaling", "UniqueEffects", ConfigDefaultValues.vortexSpellScaling);
                    if (HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "frost") > 1.0f) {
                        abilityDamage = HelperMethods.commonSpellAttributeScaling(spellScalingModifier, (Entity)this.sourceEntity, "frost");
                    }
                }
                livingEntity.m_6469_(damageSource, (float)this.additionalData + (float)amplifier / 4.0f + abilityDamage);
            }
            if (livingEntity.f_19797_ % 40 == 0) {
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_().m_82520_(0.0, (double)(livingEntity.m_20206_() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.f_123796_, 1.0, 6);
                HelperMethods.spawnOrbitParticles(serverWorld, livingEntity.m_20182_().m_82520_(0.0, (double)(livingEntity.m_20206_() / 2.0f), 0.0), (ParticleOptions)ParticleTypes.f_123804_, 1.0, 6);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Override
    public boolean m_6584_(int pDuration, int pAmplifier) {
        return super.m_6584_(pDuration, pAmplifier);
    }
}

