/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.api;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.RunicMethods;

public class SimplySwordsAPI {
    public static BattleStandardEntity spawnBattleStandard(Player user, int decayRate, String standardType, int height, int distance, String positiveEffect, String positiveEffectSecondary, int positiveEffectAmplifier, String negativeEffect, String negativeEffectSecondary, int negativeEffectAmplifier, boolean dealsDamage, boolean doesHealing) {
        BlockState state;
        ServerLevel world;
        BlockState currentState;
        if (!user.m_9236_().m_5776_() && (currentState = (world = (ServerLevel)user.m_9236_()).m_8055_(user.m_20183_().m_6630_(height).m_5484_(user.m_6374_(), distance))) == (state = Blocks.f_50016_.m_49966_())) {
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_01.get(), user.m_5720_(), 0.4f, 0.8f);
            BattleStandardEntity banner = (BattleStandardEntity)((EntityType)EntityRegistry.BATTLESTANDARD.get()).m_262496_(world, user.m_20183_().m_6630_(height).m_5484_(user.m_6374_(), distance), MobSpawnType.MOB_SUMMONED);
            if (banner != null) {
                banner.m_20334_(0.0, -1.0, 0.0);
                banner.ownerEntity = user;
                banner.decayRate = decayRate;
                banner.standardType = standardType;
                banner.doesHealing = doesHealing;
                banner.dealsDamage = dealsDamage;
                banner.negativeEffect = negativeEffect;
                banner.negativeEffectSecondary = negativeEffectSecondary;
                banner.positiveEffect = positiveEffect;
                banner.positiveEffectSecondary = positiveEffectSecondary;
                banner.positiveEffectAmplifier = positiveEffectAmplifier;
                banner.negativeEffectAmplifier = negativeEffectAmplifier;
                banner.m_6593_((Component)Component.m_237110_((String)"entity.simplyswords.battlestandard.name", (Object[])new Object[]{user.m_7755_()}));
                return banner;
            }
        }
        return null;
    }

    public static void postHitGemSocketLogic(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            switch (stack.m_41784_().m_128461_("runic_power")) {
                case "freeze": {
                    RunicMethods.postHitRunicFreeze(target, attacker);
                    break;
                }
                case "wildfire": {
                    RunicMethods.postHitRunicWildfire(target, attacker);
                    break;
                }
                case "slow": {
                    RunicMethods.postHitRunicSlow(target, attacker);
                    break;
                }
                case "greater_slow": {
                    RunicMethods.postHitRunicGreaterSlow(target, attacker);
                    break;
                }
                case "swiftness": {
                    RunicMethods.postHitRunicSwiftness(attacker);
                    break;
                }
                case "greater_swiftness": {
                    RunicMethods.postHitRunicGreaterSwiftness(attacker);
                    break;
                }
                case "float": {
                    RunicMethods.postHitRunicFloat(target, attacker);
                    break;
                }
                case "greater_float": {
                    RunicMethods.postHitRunicGreaterFloat(target, attacker);
                    break;
                }
                case "zephyr": {
                    RunicMethods.postHitRunicZephyr(attacker);
                    break;
                }
                case "greater_zephyr": {
                    RunicMethods.postHitRunicGreaterZephyr(attacker);
                    break;
                }
                case "shielding": {
                    RunicMethods.postHitRunicShielding(attacker);
                    break;
                }
                case "greater_shielding": {
                    RunicMethods.postHitRunicGreaterShielding(attacker);
                    break;
                }
                case "stoneskin": {
                    RunicMethods.postHitRunicStoneskin(attacker);
                    break;
                }
                case "greater_stoneskin": {
                    RunicMethods.postHitRunicGreaterStoneskin(attacker);
                    break;
                }
                case "trailblaze": {
                    RunicMethods.postHitRunicTrailblaze(attacker);
                    break;
                }
                case "greater_trailblaze": {
                    RunicMethods.postHitRunicGreaterTrailblaze(attacker);
                    break;
                }
                case "weaken": {
                    RunicMethods.postHitRunicWeaken(target, attacker);
                    break;
                }
                case "greater_weaken": {
                    RunicMethods.postHitRunicGreaterWeaken(target, attacker);
                    break;
                }
                case "imbued": {
                    RunicMethods.postHitRunicImbued(stack, target, attacker);
                    break;
                }
                case "greater_imbued": {
                    RunicMethods.postHitRunicGreaterImbued(stack, target, attacker);
                    break;
                }
                case "pincushion": {
                    RunicMethods.postHitRunicPinCushion(target, attacker);
                    break;
                }
                case "greater_pincushion": {
                    RunicMethods.postHitRunicGreaterPinCushion(target, attacker);
                }
            }
            switch (stack.m_41784_().m_128461_("nether_power")) {
                case "echo": {
                    RunicMethods.postHitNetherEcho(stack, target, attacker);
                    break;
                }
                case "berserk": {
                    RunicMethods.postHitNetherBerserk(stack, target, attacker);
                    break;
                }
                case "radiance": {
                    RunicMethods.postHitNetherRadiance(target, attacker);
                    break;
                }
                case "onslaught": {
                    RunicMethods.postHitNetherOnslaught(target, attacker);
                    break;
                }
                case "nullification": {
                    RunicMethods.postHitNetherNullification(attacker);
                }
            }
        }
    }

    public static void appendTooltipGemSocketLogic(ItemStack itemStack, List<Component> tooltip) {
        Style RUNIC = HelperMethods.getStyle("runic");
        Style NETHERFUSED = HelperMethods.getStyle("legendary");
        Style TEXT = HelperMethods.getStyle("text");
        CompoundTag nbt = itemStack.m_41784_();
        if (!nbt.m_128461_("runic_power").equals("no_socket") || !nbt.m_128461_("nether_power").equals("no_socket")) {
            tooltip.add((Component)Component.m_237113_((String)""));
        }
        if (Screen.m_96639_()) {
            if (nbt.m_128461_("runic_power").contains("greater")) {
                tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.greater_runic_power").m_6270_(RUNIC));
            }
            switch (nbt.m_128461_("runic_power")) {
                case "socket_empty": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.empty_runic_slot").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case "freeze": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.freeze").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.freezesworditem.tooltip2").m_6270_(TEXT));
                    break;
                }
                case "wildfire": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.wildfire").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wildfiresworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.wildfiresworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "slow": 
                case "greater_slow": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.slow").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.slownesssworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.slownesssworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "swiftness": 
                case "greater_swiftness": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.swiftness").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.speedsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.speedsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "float": 
                case "greater_float": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.float").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.levitationsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.levitationsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "zephyr": 
                case "greater_zephyr": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.zephyr").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.zephyrsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.zephyrsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "shielding": 
                case "greater_shielding": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.shielding").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.shieldingsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.shieldingsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "stoneskin": 
                case "greater_stoneskin": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.stoneskin").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stoneskinsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.stoneskinsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "frost_ward": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.frost_ward").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.frostwardsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.frostwardsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "trailblaze": 
                case "greater_trailblaze": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.trailblaze").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.trailblazesworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.trailblazesworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "active_defence": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.active_defence").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.activedefencesworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.activedefencesworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "weaken": 
                case "greater_weaken": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.weaken").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.weakensworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.weakensworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "unstable": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.unstable").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unstablesworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.unstablesworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "imbued": 
                case "greater_imbued": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.imbued").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.imbuedsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.imbuedsworditem.tooltip3").m_6270_(TEXT));
                    break;
                }
                case "pincushion": 
                case "greater_pincushion": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.runefused_power.pincushion").m_6270_(RUNIC));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.pincushionsworditem.tooltip2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.pincushionsworditem.tooltip3").m_6270_(TEXT));
                }
            }
            if (!nbt.m_128461_("runic_power").equals("no_socket") && !nbt.m_128461_("nether_power").equals("no_socket")) {
                tooltip.add((Component)Component.m_237113_((String)""));
            }
            switch (nbt.m_128461_("nether_power")) {
                case "socket_empty": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.empty_nether_slot").m_130940_(ChatFormatting.GRAY));
                    break;
                }
                case "echo": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.echo").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.echo.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.echo.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.echo.description3").m_6270_(TEXT));
                    break;
                }
                case "berserk": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.berserk.description3").m_6270_(TEXT));
                    break;
                }
                case "radiance": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.radiance").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.radiance.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.radiance.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.radiance.description3").m_6270_(TEXT));
                    break;
                }
                case "onslaught": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught.description3").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught.description4").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught.description5").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.onslaught.description6").m_6270_(TEXT));
                    break;
                }
                case "nullification": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description3").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description4").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.nullification.description5").m_6270_(TEXT));
                    break;
                }
                case "precise": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.precise").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.precise.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.precise.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.precise.description3").m_6270_(TEXT));
                    break;
                }
                case "mighty": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.mighty").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.mighty.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.mighty.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.mighty.description3").m_6270_(TEXT));
                    break;
                }
                case "stealthy": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.stealthy").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.stealthy.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.stealthy.description2").m_6270_(TEXT));
                    break;
                }
                case "renewed": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.renewed").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.renewed.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.renewed.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.renewed.description3").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.renewed.description4").m_6270_(TEXT));
                    break;
                }
                case "accelerant": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.accelerant").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.accelerant.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.accelerant.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.accelerant.description3").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.accelerant.description4").m_6270_(TEXT));
                    break;
                }
                case "leaping": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.leaping").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.leaping.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.leaping.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.leaping.description3").m_6270_(TEXT));
                    break;
                }
                case "spellshield": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellshield").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellshield.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellshield.description2").m_6270_(TEXT));
                    break;
                }
                case "spellforged": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellforged").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellforged.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellforged.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellforged.description3").m_6270_(TEXT));
                    break;
                }
                case "soulshock": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.soulshock").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.soulshock.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.soulshock.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.soulshock.description3").m_6270_(TEXT));
                    break;
                }
                case "spell_standard": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellstandard").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellstandard.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellstandard.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.spellstandard.description3").m_6270_(TEXT));
                    break;
                }
                case "war_standard": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.warstandard").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.warstandard.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.warstandard.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.warstandard.description3").m_6270_(TEXT));
                    break;
                }
                case "deception": {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.deception").m_6270_(NETHERFUSED));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.deception.description").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.deception.description2").m_6270_(TEXT));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.uniquesworditem.netherfused_power.deception.description3").m_6270_(TEXT));
                }
            }
        } else if (!nbt.m_128461_("runic_power").equals("no_socket") || !nbt.m_128461_("nether_power").equals("no_socket")) {
            tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.common.showtooltip").m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void onClickedGemSocketLogic(ItemStack stack, ItemStack otherStack, Player player) {
        if (Config.getBoolean("enableUniqueGemSockets", "General", ConfigDefaultValues.enableUniqueGemSockets)) {
            String powerType = null;
            if (otherStack.m_150930_((Item)ItemsRegistry.RUNEFUSED_GEM.get()) && stack.m_41784_().m_128461_("runic_power").equals("socket_empty") && !otherStack.m_41784_().m_128461_("runic_power").isEmpty()) {
                powerType = "runic_power";
            } else if (otherStack.m_150930_((Item)ItemsRegistry.NETHERFUSED_GEM.get()) && stack.m_41784_().m_128461_("nether_power").equals("socket_empty") && !otherStack.m_41784_().m_128461_("nether_power").isEmpty()) {
                powerType = "nether_power";
            }
            if (powerType != null) {
                String powerSelection = otherStack.m_41784_().m_128461_(powerType);
                stack.m_41784_().m_128359_(powerType, powerSelection);
                player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_11671_, player.m_5720_(), 1.0f, 1.0f);
                otherStack.m_41774_(1);
            }
        }
    }

    public static void inventoryTickGemSocketLogic(ItemStack stack, Level world, Entity entity, int runeSocketChance, int netherSocketChance) {
        LivingEntity user;
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128461_("runic_power").isEmpty() && nbt.m_128461_("nether_power").isEmpty()) {
            float socketChance = (float)(Math.random() * 100.0);
            float socketChance2 = (float)(Math.random() * 100.0);
            if (socketChance > (float)runeSocketChance) {
                nbt.m_128359_("runic_power", "socket_empty");
            } else {
                nbt.m_128359_("runic_power", "no_socket");
            }
            if (socketChance2 > (float)netherSocketChance) {
                nbt.m_128359_("nether_power", "socket_empty");
            } else {
                nbt.m_128359_("nether_power", "no_socket");
            }
        }
        if (!world.f_46443_ && entity instanceof LivingEntity && ((user = (LivingEntity)entity).m_6844_(EquipmentSlot.MAINHAND) == stack || user.m_6844_(EquipmentSlot.OFFHAND) == stack)) {
            switch (stack.m_41784_().m_128461_("runic_power")) {
                case "unstable": {
                    RunicMethods.inventoryTickRunicUnstable(user);
                    break;
                }
                case "active_defence": {
                    RunicMethods.inventoryTickRunicActiveDefence(world, user);
                    break;
                }
                case "frost_ward": {
                    RunicMethods.inventoryTickRunicFrostWard(world, user);
                }
            }
        }
    }
}

