/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords;

import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.io.File;
import java.io.IOException;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sweenus.simplyswords.SimplySwordsExpectPlatform;
import net.sweenus.simplyswords.client.renderer.BattleStandardDarkRenderer;
import net.sweenus.simplyswords.client.renderer.BattleStandardRenderer;
import net.sweenus.simplyswords.client.renderer.model.BattleStandardDarkModel;
import net.sweenus.simplyswords.client.renderer.model.BattleStandardModel;
import net.sweenus.simplyswords.compat.EldritchEndCompat;
import net.sweenus.simplyswords.compat.eldritch_end.EldritchEndCompatRegistry;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigWrapper;
import net.sweenus.simplyswords.config.GemEffectsConfig;
import net.sweenus.simplyswords.config.GeneralConfig;
import net.sweenus.simplyswords.config.LootConfig;
import net.sweenus.simplyswords.config.RunicEffectsConfig;
import net.sweenus.simplyswords.config.SimplySwordsConfig;
import net.sweenus.simplyswords.config.StatusEffectsConfig;
import net.sweenus.simplyswords.config.UniqueEffectsConfig;
import net.sweenus.simplyswords.config.WeaponAttributesConfig;
import net.sweenus.simplyswords.entity.BattleStandardDarkEntity;
import net.sweenus.simplyswords.entity.BattleStandardEntity;
import net.sweenus.simplyswords.entity.SimplySwordsBeeEntity;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.EntityRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.FileCopier;
import net.sweenus.simplyswords.util.ModLootTableModifiers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimplySwords {
    public static final String MOD_ID = "simplyswords";
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"simplyswords", (ResourceKey)Registries.f_279569_);
    public static final RegistrySupplier<CreativeModeTab> SIMPLYSWORDS = TABS.register("simplyswords", () -> CreativeTabRegistry.create((Component)Component.m_237115_((String)"itemGroup.simplyswords.simplyswords"), () -> new ItemStack((ItemLike)ItemsRegistry.RUNIC_TABLET.get())));
    public static final Logger LOGGER = LogManager.getLogger((String)"simplyswords");
    public static boolean isConfigOutdated;
    public static GeneralConfig generalConfig;
    public static LootConfig lootConfig;
    public static GemEffectsConfig gemEffectsConfig;
    public static RunicEffectsConfig runicEffectsConfig;
    public static StatusEffectsConfig statusEffectsConfig;
    public static UniqueEffectsConfig uniqueEffectsConfig;
    public static WeaponAttributesConfig weaponAttributesConfig;
    public static String minimumEldritchEndVersion;

    public static void init() {
        SimplySwordsConfig.init();
        AutoConfig.register(ConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        generalConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).general;
        lootConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).loot;
        gemEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).gem_effects;
        runicEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).runic_effects;
        statusEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).status_effects;
        uniqueEffectsConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).unique_effects;
        weaponAttributesConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).weapon_attributes;
        String version = SimplySwordsExpectPlatform.getVersion();
        String defaultConfig = String.format("{\n  \"regen_simplyswords_config_file\": false,\n  \"config_version\": %s\n}", version.substring(0, 4));
        File configFile = Config.createFile("config/simplyswords_extra/backupconfig.json", defaultConfig, false);
        JsonObject json = Config.getJsonObject(Config.readFile(configFile));
        isConfigOutdated = !json.has("config_version") || !version.startsWith(json.get("config_version").getAsString());
        SimplySwordsConfig.generateConfigs(json == null || !json.has("regen_simplyswords_config_file") || json.get("regen_simplyswords_config_file").getAsBoolean());
        SimplySwordsConfig.loadConfig();
        TABS.register();
        ItemsRegistry.ITEM.register();
        SoundRegistry.SOUND.register();
        EffectRegistry.EFFECT.register();
        EntityRegistry.ENTITIES.register();
        EntityAttributeRegistry.register(EntityRegistry.BATTLESTANDARD, BattleStandardEntity::createBattleStandardAttributes);
        EntityAttributeRegistry.register(EntityRegistry.BATTLESTANDARDDARK, BattleStandardDarkEntity::createBattleStandardDarkAttributes);
        EntityAttributeRegistry.register(EntityRegistry.SIMPLYBEEENTITY, SimplySwordsBeeEntity::createSimplyBeeAttributes);
        ModLootTableModifiers.init();
        if (SimplySwords.passVersionCheck("eldritch_end", minimumEldritchEndVersion)) {
            EldritchEndCompat.registerModItems();
            EldritchEndCompatRegistry.EFFECT.register();
        }
        try {
            FileCopier.copyFileToConfigDirectory();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(SimplySwordsExpectPlatform.getConfigDirectory().toAbsolutePath().normalize().toString());
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> Client::initializeClient);
    }

    public static boolean passVersionCheck(String modId, String requiredVersion) {
        return Platform.isModLoaded((String)modId) && Platform.getMod((String)modId).getVersion().compareTo(requiredVersion) >= 0;
    }

    static {
        minimumEldritchEndVersion = "0.2.40";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static final ModelLayerLocation BATTLESTANDARD_MODEL = new ModelLayerLocation(new ResourceLocation("battlestandard", "cube"), "main");
        public static final ModelLayerLocation BATTLESTANDARD_DARK_MODEL = new ModelLayerLocation(new ResourceLocation("battlestandarddark", "cube"), "main");

        @OnlyIn(value=Dist.CLIENT)
        public static void initializeClient() {
            EntityRendererRegistry.register(EntityRegistry.BATTLESTANDARD, BattleStandardRenderer::new);
            EntityModelLayerRegistry.register((ModelLayerLocation)BATTLESTANDARD_MODEL, BattleStandardModel::getTexturedModelData);
            EntityRendererRegistry.register(EntityRegistry.BATTLESTANDARDDARK, BattleStandardDarkRenderer::new);
            EntityModelLayerRegistry.register((ModelLayerLocation)BATTLESTANDARD_DARK_MODEL, BattleStandardDarkModel::getTexturedModelData);
            EntityRendererRegistry.register(EntityRegistry.SIMPLYBEEENTITY, BeeRenderer::new);
        }
    }
}

