/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.registry;

import com.railwayteam.railways.ModSetup;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.base.data.BuilderTransformers;
import com.railwayteam.railways.content.conductor.vent.CopycatVentModel;
import com.railwayteam.railways.content.conductor.vent.VentBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleFlagBlock;
import com.railwayteam.railways.content.conductor.whistle.ConductorWhistleItem;
import com.railwayteam.railways.content.coupling.TrackCouplerDisplaySource;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlock;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockItem;
import com.railwayteam.railways.content.custom_bogeys.DoubleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.LargePlatformDoubleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.SingleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.TripleAxleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.invisible.InvisibleBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.InvisibleMonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.monobogey.MonoBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.narrow_gauge.NarrowGaugeBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.wide_gauge.WideGaugeBogeyBlock;
import com.railwayteam.railways.content.custom_bogeys.wide_gauge.WideGaugeComicallyLargeBogeyBlock;
import com.railwayteam.railways.content.custom_tracks.CustomTrackBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.casing.CasingCollisionBlock;
import com.railwayteam.railways.content.custom_tracks.monorail.MonorailBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.narrow_gauge.NarrowGaugeTrackBlockStateGenerator;
import com.railwayteam.railways.content.custom_tracks.wide_gauge.WideGaugeTrackBlockStateGenerator;
import com.railwayteam.railways.content.distant_signals.SemaphoreDisplayTarget;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.content.semaphore.SemaphoreItem;
import com.railwayteam.railways.content.smokestack.AxisSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.DieselSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.OilburnerSmokeStackBlock;
import com.railwayteam.railways.content.smokestack.SmokeStackBlock;
import com.railwayteam.railways.content.smokestack.SmokeStackMovementBehaviour;
import com.railwayteam.railways.content.switches.SwitchDisplaySource;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchBlockItem;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRShapes;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.ShapeWrapper;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllMovementBehaviours;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementBehaviour;
import com.simibubi.create.content.redstone.displayLink.AllDisplayBehaviours;
import com.simibubi.create.content.redstone.displayLink.DisplayBehaviour;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockItem;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackModel;
import com.simibubi.create.foundation.block.ItemUseOverrides;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CRBlocks {
    private static final CreateRegistrate REGISTRATE = Railways.registrate();
    public static final BlockEntry<SemaphoreBlock> SEMAPHORE = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("semaphore", SemaphoreBlock::new).initialProperties(SharedProperties::softMetal).transform(BuilderTransformers.semaphore())).properties(p -> p.m_284180_(MapColor.f_283818_)).properties(p -> p.m_60918_(SoundType.f_56725_)).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SemaphoreDisplayTarget(), (String[])new String[0]))).item(SemaphoreItem::new).transform(ModelGen.customItemModel())).transform(TagGen.axeOnly())).addLayer(() -> RenderType::m_110466_).register();
    public static final BlockEntry<TrackCouplerBlock> TRACK_COUPLER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_coupler", TrackCouplerBlock::create).initialProperties(SharedProperties::softMetal).properties(p -> p.m_284180_(MapColor.f_283819_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(BuilderTransformers.trackCoupler())).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new TrackCouplerDisplaySource(), (String[])new String[]{"track_coupler_info"}))).lang("Train Coupler").item(TrackCouplerBlockItem.ofType(CREdgePointTypes.COUPLER)).transform(ModelGen.customItemModel((String[])new String[]{"_", "block_both"}))).register();
    public static final BlockEntry<TrackSwitchBlock> ANDESITE_SWITCH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_switch_andesite", TrackSwitchBlock::manual).initialProperties(SharedProperties::softMetal).transform(BuilderTransformers.trackSwitch(true))).properties(p -> p.m_284180_(MapColor.f_283819_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SwitchDisplaySource(), (String[])new String[0]))).onRegister(ItemUseOverrides::addBlock)).lang("Andesite Track Switch").item(TrackSwitchBlockItem.ofType(CREdgePointTypes.SWITCH)).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<TrackSwitchBlock> BRASS_SWITCH = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_switch_brass", TrackSwitchBlock::automatic).initialProperties(SharedProperties::softMetal).transform(BuilderTransformers.trackSwitch(false))).properties(p -> p.m_284180_(MapColor.f_283774_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56725_)).transform(TagGen.pickaxeOnly())).onRegister(AllDisplayBehaviours.assignDataBehaviour((DisplayBehaviour)new SwitchDisplaySource(), (String[])new String[0]))).onRegister(ItemUseOverrides::addBlock)).lang("Brass Track Switch").item(TrackSwitchBlockItem.ofType(CREdgePointTypes.SWITCH)).transform(ModelGen.customItemModel())).register();
    public static final BlockEntry<CasingCollisionBlock> CASING_COLLISION = ((BlockBuilder)REGISTRATE.block("casing_collision", CasingCollisionBlock::create).properties(p -> p.m_284180_(MapColor.f_283906_).m_60955_().m_280170_()).transform(BuilderTransformers.casingCollision())).lang("Track Casing Collision Block").register();
    public static final BlockEntry<TrackBlock> ACACIA_TRACK;
    public static final BlockEntry<TrackBlock> BIRCH_TRACK;
    public static final BlockEntry<TrackBlock> CRIMSON_TRACK;
    public static final BlockEntry<TrackBlock> DARK_OAK_TRACK;
    public static final BlockEntry<TrackBlock> JUNGLE_TRACK;
    public static final BlockEntry<TrackBlock> OAK_TRACK;
    public static final BlockEntry<TrackBlock> SPRUCE_TRACK;
    public static final BlockEntry<TrackBlock> WARPED_TRACK;
    public static final BlockEntry<TrackBlock> BLACKSTONE_TRACK;
    public static final BlockEntry<TrackBlock> ENDER_TRACK;
    public static final BlockEntry<TrackBlock> TIELESS_TRACK;
    public static final BlockEntry<TrackBlock> PHANTOM_TRACK;
    public static final BlockEntry<TrackBlock> MANGROVE_TRACK;
    public static final Map<TrackMaterial, NonNullSupplier<TrackBlock>> WIDE_GAUGE_TRACKS;
    public static final Map<TrackMaterial, NonNullSupplier<TrackBlock>> NARROW_GAUGE_TRACKS;
    public static final BlockEntry<TrackBlock> MONORAIL_TRACK;
    public static final BlockEntry<MonoBogeyBlock> MONO_BOGEY;
    public static final BlockEntry<InvisibleBogeyBlock> INVISIBLE_BOGEY;
    public static final BlockEntry<InvisibleMonoBogeyBlock> INVISIBLE_MONO_BOGEY;
    public static final BlockEntry<SingleAxleBogeyBlock> SINGLEAXLE_BOGEY;
    public static final BlockEntry<DoubleAxleBogeyBlock> DOUBLEAXLE_BOGEY;
    public static final BlockEntry<LargePlatformDoubleAxleBogeyBlock> LARGE_PLATFORM_DOUBLEAXLE_BOGEY;
    public static final BlockEntry<TripleAxleBogeyBlock> TRIPLEAXLE_BOGEY;
    public static final BlockEntry<WideGaugeBogeyBlock> WIDE_DOUBLEAXLE_BOGEY;
    public static final BlockEntry<WideGaugeBogeyBlock> WIDE_SCOTCH_BOGEY;
    public static final BlockEntry<WideGaugeComicallyLargeBogeyBlock> WIDE_COMICALLY_LARGE_BOGEY;
    public static final BlockEntry<NarrowGaugeBogeyBlock> NARROW_SMALL_BOGEY;
    public static final BlockEntry<NarrowGaugeBogeyBlock> NARROW_SCOTCH_BOGEY;
    public static final BlockEntry<NarrowGaugeBogeyBlock> NARROW_DOUBLE_SCOTCH_BOGEY;
    public static final BlockEntry<ConductorWhistleFlagBlock> CONDUCTOR_WHISTLE_FLAG;
    public static final BlockEntry<SmokeStackBlock> CABOOSESTYLE_STACK;
    public static final BlockEntry<SmokeStackBlock> LONG_STACK;
    public static final BlockEntry<SmokeStackBlock> COALBURNER_STACK;
    public static final BlockEntry<SmokeStackBlock> OILBURNER_STACK;
    public static final BlockEntry<SmokeStackBlock> STREAMLINED_STACK;
    public static final BlockEntry<SmokeStackBlock> WOODBURNER_STACK;
    public static final BlockEntry<DieselSmokeStackBlock> DIESEL_STACK;
    public static final BlockEntry<VentBlock> CONDUCTOR_VENT;

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material) {
        return CRBlocks.makeTrack(material, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((CustomTrackBlockStateGenerator)CustomTrackBlockStateGenerator.create()).generate(arg_0, arg_1)));
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen) {
        return CRBlocks.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}));
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister) {
        return CRBlocks.makeTrack(material, blockstateGen, onRegister, p -> p);
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        return CRBlocks.makeTrack(material, blockstateGen, (NonNullConsumer<? super TrackBlock>)((NonNullConsumer)t -> {}), collectProperties);
    }

    private static BlockEntry<TrackBlock> makeTrack(TrackMaterial material, NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider> blockstateGen, NonNullConsumer<? super TrackBlock> onRegister, Function<BlockBehaviour.Properties, BlockBehaviour.Properties> collectProperties) {
        ArrayList<TagKey> trackTags = new ArrayList<TagKey>();
        trackTags.add(AllTags.AllBlockTags.TRACKS.tag);
        if (material.trackType != CRTrackMaterials.CRTrackType.MONORAIL) {
            trackTags.add(AllTags.AllBlockTags.GIRDABLE_TRACKS.tag);
        }
        ArrayList<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        if (material == CRTrackMaterials.PHANTOM || material == CRTrackMaterials.getWide(CRTrackMaterials.PHANTOM) || material == CRTrackMaterials.getNarrow(CRTrackMaterials.PHANTOM)) {
            itemTags.add(CRTags.AllItemTags.PHANTOM_TRACK_REVEALING.tag);
        }
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("track_" + material.resourceName(), arg_0 -> ((TrackMaterial)material).createBlock(arg_0)).initialProperties(SharedProperties::stone).properties(p -> ((BlockBehaviour.Properties)collectProperties.apply((BlockBehaviour.Properties)p)).m_284180_(MapColor.f_283906_).m_60978_(0.8f).m_60918_(SoundType.f_56743_).m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).blockstate(blockstateGen).tag(new TagKey[]{CommonTags.RELOCATION_NOT_SUPPORTED.forge, CommonTags.RELOCATION_NOT_SUPPORTED.fabric}).tag(trackTags.toArray(new TagKey[0])).lang(material.langName + " Train Track").onRegister(onRegister)).onRegister(CreateRegistrate.blockModel(() -> TrackModel::new))).onRegister(CRTrackMaterials::addToBlockEntityType)).item(TrackBlockItem::new).model((c, p) -> p.generated((NonNullSupplier)c, new ResourceLocation[]{Railways.asResource("item/track/" + c.getName())})).tag(itemTags.toArray(new TagKey[0])).build()).register();
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, VoxelShape shape, boolean emitStationarySmoke) {
        return CRBlocks.makeSmokeStack(variant, type, description, false, ShapeWrapper.wrapped(shape), true, emitStationarySmoke);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, VoxelShape shape, boolean spawnExtraSmoke, boolean emitStationarySmoke) {
        return CRBlocks.makeSmokeStack(variant, type, description, false, ShapeWrapper.wrapped(shape), spawnExtraSmoke, emitStationarySmoke);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, boolean rotates, ShapeWrapper shape, boolean spawnExtraSmoke, boolean emitStationarySmoke) {
        ResourceLocation modelLoc = Railways.asResource("block/smokestack/block_" + variant);
        return CRBlocks.makeSmokeStack(variant, type, description, rotates, shape, spawnExtraSmoke, emitStationarySmoke, BuilderTransformers.defaultSmokeStack(modelLoc, rotates), rotates ? AxisSmokeStackBlock::new : SmokeStackBlock::new);
    }

    private static BlockEntry<SmokeStackBlock> makeSmokeStack(String variant, SmokeStackBlock.SmokeStackType type, String description, boolean rotates, ShapeWrapper shape, boolean spawnExtraSmoke, boolean emitStationarySmoke, NonNullBiConsumer<DataGenContext<Block, SmokeStackBlock>, RegistrateBlockstateProvider> blockStateProvider, SmokeStackFunction<SmokeStackBlock> blockFunction) {
        ResourceLocation modelLoc = Railways.asResource("block/smokestack/block_" + variant);
        SmokeStackMovementBehaviour movementBehaviour = new SmokeStackMovementBehaviour(spawnExtraSmoke);
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("smokestack_" + variant, p -> blockFunction.create((BlockBehaviour.Properties)p, type, shape, emitStationarySmoke)).initialProperties(SharedProperties::softMetal).blockstate(blockStateProvider).properties(p -> p.m_284180_(MapColor.f_283818_)).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)movementBehaviour))).lang(description).item().model((c, p) -> p.withExistingParent("item/" + c.getName(), modelLoc)).build()).register();
    }

    public static void register() {
    }

    static {
        ModSetup.useTracksTab();
        ACACIA_TRACK = CRBlocks.makeTrack(CRTrackMaterials.ACACIA);
        BIRCH_TRACK = CRBlocks.makeTrack(CRTrackMaterials.BIRCH);
        CRIMSON_TRACK = CRBlocks.makeTrack(CRTrackMaterials.CRIMSON);
        DARK_OAK_TRACK = CRBlocks.makeTrack(CRTrackMaterials.DARK_OAK);
        JUNGLE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.JUNGLE);
        OAK_TRACK = CRBlocks.makeTrack(CRTrackMaterials.OAK);
        SPRUCE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.SPRUCE);
        WARPED_TRACK = CRBlocks.makeTrack(CRTrackMaterials.WARPED);
        BLACKSTONE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.BLACKSTONE);
        ENDER_TRACK = CRBlocks.makeTrack(CRTrackMaterials.ENDER);
        TIELESS_TRACK = CRBlocks.makeTrack(CRTrackMaterials.TIELESS);
        PHANTOM_TRACK = CRBlocks.makeTrack(CRTrackMaterials.PHANTOM);
        MANGROVE_TRACK = CRBlocks.makeTrack(CRTrackMaterials.MANGROVE);
        WIDE_GAUGE_TRACKS = new HashMap<TrackMaterial, NonNullSupplier<TrackBlock>>();
        NARROW_GAUGE_TRACKS = new HashMap<TrackMaterial, NonNullSupplier<TrackBlock>>();
        for (TrackMaterial wideMaterial : CRTrackMaterials.WIDE_GAUGE.values()) {
            WIDE_GAUGE_TRACKS.put(wideMaterial, (NonNullSupplier<TrackBlock>)CRBlocks.makeTrack(wideMaterial, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((WideGaugeTrackBlockStateGenerator)WideGaugeTrackBlockStateGenerator.create()).generate(arg_0, arg_1))));
        }
        for (TrackMaterial narrowMaterial : CRTrackMaterials.NARROW_GAUGE.values()) {
            NARROW_GAUGE_TRACKS.put(narrowMaterial, (NonNullSupplier<TrackBlock>)CRBlocks.makeTrack(narrowMaterial, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((NarrowGaugeTrackBlockStateGenerator)NarrowGaugeTrackBlockStateGenerator.create()).generate(arg_0, arg_1))));
        }
        MONORAIL_TRACK = CRBlocks.makeTrack(CRTrackMaterials.MONORAIL, (NonNullBiConsumer<DataGenContext<Block, TrackBlock>, RegistrateBlockstateProvider>)((NonNullBiConsumer)(arg_0, arg_1) -> ((MonorailBlockStateGenerator)MonorailBlockStateGenerator.create()).generate(arg_0, arg_1)), BlockBehaviour.Properties::m_60977_);
        ModSetup.useBaseTab();
        MONO_BOGEY = ((BlockBuilder)REGISTRATE.block("mono_bogey", MonoBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.monobogey())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).lang("Monorail Bogey").register();
        INVISIBLE_BOGEY = ((BlockBuilder)REGISTRATE.block("invisible_bogey", InvisibleBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.invisibleBogey())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).lang("Invisible Bogey").register();
        INVISIBLE_MONO_BOGEY = ((BlockBuilder)REGISTRATE.block("invisible_mono_bogey", InvisibleMonoBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.invisibleMonoBogey())).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).lang("Invisible Mono Bogey").register();
        SINGLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("singleaxle_bogey", SingleAxleBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.standardBogey())).lang("Single Axle Bogey").register();
        DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("doubleaxle_bogey", DoubleAxleBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.standardBogey())).lang("Double Axle Bogey").register();
        LARGE_PLATFORM_DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("large_platform_doubleaxle_bogey", LargePlatformDoubleAxleBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.standardBogey())).lang("Large Platform Double Axle Bogey").register();
        TRIPLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("tripleaxle_bogey", TripleAxleBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.standardBogey())).lang("Triple Axle Bogey").register();
        WIDE_DOUBLEAXLE_BOGEY = ((BlockBuilder)REGISTRATE.block("wide_doubleaxle_bogey", WideGaugeBogeyBlock.create(false)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.wideBogey())).lang("Wide Gauge Double Axle Bogey").register();
        WIDE_SCOTCH_BOGEY = ((BlockBuilder)REGISTRATE.block("wide_scotch_bogey", WideGaugeBogeyBlock.create(true)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.wideBogey())).lang("Wide Gauge Scotch Yoke Bogey").register();
        WIDE_COMICALLY_LARGE_BOGEY = ((BlockBuilder)REGISTRATE.block("wide_comically_large_bogey", WideGaugeComicallyLargeBogeyBlock::new).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.wideBogey())).lang("Wide Gauge Comically Large Bogey").register();
        NARROW_SMALL_BOGEY = ((BlockBuilder)REGISTRATE.block("narrow_small_bogey", NarrowGaugeBogeyBlock.create(NarrowGaugeBogeyBlock.NarrowGaugeStandardStyle.SMALL)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.narrowBogey())).lang("Narrow Gauge Small Bogey").register();
        NARROW_SCOTCH_BOGEY = ((BlockBuilder)REGISTRATE.block("narrow_scotch_bogey", NarrowGaugeBogeyBlock.create(NarrowGaugeBogeyBlock.NarrowGaugeStandardStyle.SCOTCH_YOKE)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.narrowBogey())).lang("Narrow Gauge Scotch Yoke Bogey").register();
        NARROW_DOUBLE_SCOTCH_BOGEY = ((BlockBuilder)REGISTRATE.block("narrow_double_scotch_bogey", NarrowGaugeBogeyBlock.create(NarrowGaugeBogeyBlock.NarrowGaugeStandardStyle.DOUBLE_SCOTCH_YOKE)).properties(p -> p.m_284180_(MapColor.f_283819_)).transform(BuilderTransformers.narrowBogey())).lang("Narrow Gauge Double Scotch Yoke Bogey").register();
        CONDUCTOR_WHISTLE_FLAG = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("conductor_whistle", ConductorWhistleFlagBlock::new).initialProperties(SharedProperties::wooden).properties(p -> p.m_284180_(MapColor.f_283748_)).properties(p -> p.m_60955_()).properties(p -> p.m_60918_(SoundType.f_56736_)).properties(p -> p.m_60966_()).properties(p -> p.m_222994_()).properties(p -> p.m_60910_()).transform(BuilderTransformers.conductorWhistleFlag())).lang("Conductor Whistle").item(ConductorWhistleItem::new).transform(ModelGen.customItemModel())).register();
        CABOOSESTYLE_STACK = CRBlocks.makeSmokeStack("caboosestyle", new SmokeStackBlock.SmokeStackType(0.5, 0.625, 0.5), "Caboose Smokestack", true, ShapeWrapper.wrapped(CRShapes.CABOOSE_STACK), false, true);
        LONG_STACK = CRBlocks.makeSmokeStack("long", new SmokeStackBlock.SmokeStackType(0.5, 0.625, 0.5), "Long Smokestack", true, ShapeWrapper.wrapped(CRShapes.LONG_STACK), true, true);
        COALBURNER_STACK = CRBlocks.makeSmokeStack("coalburner", new SmokeStackBlock.SmokeStackType(0.5, 1.0, 0.5), "Coalburner Smokestack", CRShapes.COAL_STACK, true);
        OILBURNER_STACK = CRBlocks.makeSmokeStack("oilburner", new SmokeStackBlock.SmokeStackType(new Vec3(0.5, 0.4, 0.5), new Vec3(0.2, 0.2, 0.2)), "Oilburner Smokestack", false, ShapeWrapper.wrapped(CRShapes.OIL_STACK), true, true, BuilderTransformers.oilburnerSmokeStack(), OilburnerSmokeStackBlock::new);
        STREAMLINED_STACK = CRBlocks.makeSmokeStack("streamlined", new SmokeStackBlock.SmokeStackType(new Vec3(0.5, 0.2, 0.5), new Vec3(0.25, 0.2, 0.25)), "Streamlined Smokestack", CRShapes.STREAMLINED_STACK, true);
        WOODBURNER_STACK = CRBlocks.makeSmokeStack("woodburner", new SmokeStackBlock.SmokeStackType(0.5, 0.75, 0.5), "Woodburner Smokestack", CRShapes.WOOD_STACK, true);
        DIESEL_STACK = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("smokestack_diesel", p -> new DieselSmokeStackBlock((BlockBehaviour.Properties)p, new SmokeStackBlock.SmokeStackType(0.5, 0.25, 0.5), ShapeWrapper.wrapped(CRShapes.DIESEL_STACK), false)).initialProperties(SharedProperties::softMetal).transform(BuilderTransformers.dieselSmokeStack())).properties(p -> p.m_284180_(MapColor.f_283818_)).properties(p -> p.m_60918_(SoundType.f_56725_)).properties(p -> p.m_60955_()).addLayer(() -> RenderType::m_110457_).transform(TagGen.pickaxeOnly())).onRegister(AllMovementBehaviours.movementBehaviour((MovementBehaviour)new SmokeStackMovementBehaviour(true, false, false)))).lang("Radiator Fan").item().model((c, p) -> p.withExistingParent("item/" + c.getName(), Railways.asResource("block/smokestack/block_diesel"))).build()).register();
        CONDUCTOR_VENT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("conductor_vent", VentBlock::create).transform((NonNullFunction)com.simibubi.create.foundation.data.BuilderTransformers.copycat())).transform(BuilderTransformers.conductorVent())).properties(p -> p.m_60960_((state, level, pos) -> false)).onRegister(CreateRegistrate.blockModel(() -> CopycatVentModel::create))).lang("Vent Block").recipe((c, p) -> p.stonecutting(DataIngredient.items((ItemLike)((Block)AllBlocks.INDUSTRIAL_IRON_BLOCK.get()), (ItemLike[])new Block[0]), RecipeCategory.TRANSPORTATION, (Supplier)c, 2)).item().transform(ModelGen.customItemModel((String[])new String[]{"copycat_vent"}))).register();
    }

    @FunctionalInterface
    private static interface SmokeStackFunction<T extends SmokeStackBlock> {
        public T create(BlockBehaviour.Properties var1, SmokeStackBlock.SmokeStackType var2, ShapeWrapper var3, boolean var4);
    }
}

