/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.events;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.schedule.RedstoneLinkInstruction;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRExtraRegistration;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.util.packet.PacketSender;
import com.railwayteam.railways.util.packet.TrainMarkerDataUpdatePacket;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.trains.entity.Train;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class CommonEvents {
    public static final Set<UUID> journeymapUsers = new HashSet<UUID>();

    public static void onWorldTickStart(Level level) {
        if (level.f_46443_) {
            return;
        }
        RedstoneLinkInstruction.tick(level);
        long ticks = level.m_46467_();
        for (Train train : Create.RAILWAYS.trains.values()) {
            CarriageContraptionEntity trainEntity;
            long offsetTicks = ticks + (long)train.id.hashCode();
            if (offsetTicks % (long)((Integer)CRConfigs.server().journeymap.farTrainSyncTicks.get()).intValue() == 0L) {
                CRPackets.PACKETS.sendTo(PlayerSelection.allWith(p -> journeymapUsers.contains(p.m_20148_())), (S2CPacket)new TrainMarkerDataUpdatePacket(train));
            }
            if (offsetTicks % (long)((Integer)CRConfigs.server().journeymap.nearTrainSyncTicks.get()).intValue() != 0L || train.carriages.isEmpty() || (trainEntity = ((Carriage)train.carriages.get(0)).anyAvailableEntity()) == null) continue;
            CRPackets.PACKETS.sendTo(PlayerSelection.trackingWith((Entity)trainEntity, p -> journeymapUsers.contains(p.m_20148_())), (S2CPacket)new TrainMarkerDataUpdatePacket(train));
        }
    }

    public static void onPlayerJoin(ServerPlayer player) {
        PacketSender.notifyServerVersion(player);
    }

    public static void backupDisplayRegister() {
        CRExtraRegistration.register();
    }
}

