/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.railwayteam.railways.content.smokestack.SmokeParticle;
import com.railwayteam.railways.registry.CRParticleTypes;
import com.simibubi.create.foundation.particle.ICustomParticleDataWithSprite;
import java.util.Locale;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class SmokeParticleData
implements ParticleOptions,
ICustomParticleDataWithSprite<SmokeParticleData> {
    public static final Codec<SmokeParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("stationary").forGetter(p -> p.stationary), (App)Codec.FLOAT.fieldOf("red").forGetter(p -> Float.valueOf(p.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(p -> Float.valueOf(p.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(p -> Float.valueOf(p.blue))).apply((Applicative)i, SmokeParticleData::new));
    public static final ParticleOptions.Deserializer<SmokeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SmokeParticleData>(){

        public SmokeParticleData fromCommand(ParticleType<SmokeParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            boolean stationary = reader.readBoolean();
            reader.expect(' ');
            float red = reader.readFloat();
            reader.expect(' ');
            float green = reader.readFloat();
            reader.expect(' ');
            float blue = reader.readFloat();
            return new SmokeParticleData(stationary, red, green, blue);
        }

        public SmokeParticleData fromNetwork(ParticleType<SmokeParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new SmokeParticleData(buffer.readBoolean(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    boolean stationary;
    float red;
    float green;
    float blue;

    public SmokeParticleData() {
        this(false);
    }

    public SmokeParticleData(float red, float green, float blue) {
        this(false, red, green, blue);
    }

    public SmokeParticleData(boolean stationary) {
        this(stationary, stationary ? 0.3f : 0.1f);
    }

    public SmokeParticleData(boolean stationary, float brightness) {
        this(stationary, brightness, brightness, brightness);
    }

    public SmokeParticleData(boolean stationary, float red, float green, float blue) {
        this.stationary = stationary;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public ParticleType<?> m_6012_() {
        return CRParticleTypes.SMOKE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.stationary);
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %b %f %f %f", CRParticleTypes.SMOKE.parameter(), this.stationary, Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }

    public ParticleOptions.Deserializer<SmokeParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<SmokeParticleData> getCodec(ParticleType<SmokeParticleData> type) {
        return CODEC;
    }

    public ParticleEngine.SpriteParticleRegistration<SmokeParticleData> getMetaFactory() {
        return SmokeParticle.Factory::new;
    }
}

