/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.ConductorElytraLayer;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.ConductorEntityModel;
import com.railwayteam.railways.content.conductor.ConductorFlagLayer;
import com.railwayteam.railways.content.conductor.ConductorRemoteLayer;
import com.railwayteam.railways.content.conductor.ConductorSecondaryHeadLayer;
import com.railwayteam.railways.content.conductor.ConductorToolboxLayer;
import com.railwayteam.railways.mixin.client.AccessorLivingEntityRenderer;
import com.railwayteam.railways.registry.CRBlockPartials;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConductorRenderer
extends MobRenderer<ConductorEntity, ConductorEntityModel<ConductorEntity>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("railways", "textures/entity/conductor.png");

    public ConductorRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new ConductorEntityModel(ctx.m_174023_(ConductorEntityModel.LAYER_LOCATION)), 0.2f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new ConductorEntityModel(ctx.m_174023_(ModelLayers.f_171208_)), new ConductorEntityModel(ctx.m_174023_(ModelLayers.f_171261_)), ctx.m_266367_()));
        this.m_115326_(new ConductorSecondaryHeadLayer(this, ctx.m_174027_(), ctx.m_234598_()));
        this.m_115326_(new ConductorToolboxLayer(this));
        this.m_115326_(new ConductorFlagLayer(this));
        this.m_115326_(new ConductorRemoteLayer(this));
        this.m_115326_((RenderLayer)new ConductorElytraLayer(this, ctx.m_174027_()));
    }

    private ResourceLocation ensurePng(ResourceLocation loc) {
        if (loc.m_135815_().endsWith(".png")) {
            return loc;
        }
        return new ResourceLocation(loc.m_135827_(), loc.m_135815_() + ".png");
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull ConductorEntity conductor) {
        ItemStack headItem = conductor.m_6844_(EquipmentSlot.HEAD);
        String name = headItem.m_41786_().getString();
        if (name.startsWith("[sus]")) {
            name = name.substring(5);
        }
        if (!headItem.m_41619_() && headItem.m_41720_() instanceof ConductorCapItem && CRBlockPartials.CUSTOM_CONDUCTOR_SKINS.containsKey(name)) {
            return this.ensurePng(CRBlockPartials.CUSTOM_CONDUCTOR_SKINS.get(name));
        }
        if (conductor.m_7770_() != null && CRBlockPartials.CUSTOM_CONDUCTOR_SKINS_FOR_NAME.containsKey(conductor.m_7770_().getString())) {
            return this.ensurePng(CRBlockPartials.CUSTOM_CONDUCTOR_SKINS_FOR_NAME.get(conductor.m_7770_().getString()));
        }
        return TEXTURE;
    }

    public void render(ConductorEntity entity, float f1, float f2, PoseStack stack, MultiBufferSource source, int i1) {
        super.m_7392_((Mob)entity, f1, f2, stack, source, i1);
    }

    protected void setupRotations(ConductorEntity entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        EntityRenderer renderer;
        if (entityLiving.visualBaseEntity != null && (renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)entityLiving.visualBaseEntity)) instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            ((AccessorLivingEntityRenderer)livingRenderer).callSetupRotations(entityLiving.visualBaseEntity, matrixStack, ageInTicks, rotationYaw, partialTicks);
            return;
        }
        super.m_7523_((LivingEntity)entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks);
    }
}

