/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data;

import com.railwayteam.railways.base.data.forge.CRTagGenImpl;
import com.railwayteam.railways.multiloader.CommonTags;
import com.railwayteam.railways.registry.CRTags;
import com.tterrag.registrate.providers.RegistrateItemTagsProvider;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class CRTagGen {
    private static final Map<TagKey<Block>, List<ResourceLocation>> OPTIONAL_TAGS = new HashMap<TagKey<Block>, List<ResourceLocation>>();

    @SafeVarargs
    public static void addOptionalTag(ResourceLocation id, TagKey<Block> ... tags) {
        for (TagKey<Block> tag : tags) {
            OPTIONAL_TAGS.computeIfAbsent(tag, e -> new ArrayList()).add(id);
        }
    }

    public static void generateBlockTags(RegistrateTagsProvider<Block> tags) {
        for (TagKey<Block> tag : OPTIONAL_TAGS.keySet()) {
            TagsProvider.TagAppender<Block> appender = CRTagGen.tagAppender(tags, tag);
            for (ResourceLocation loc : OPTIONAL_TAGS.get(tag)) {
                appender.m_176839_(loc);
            }
        }
    }

    public static void generateItemTags(RegistrateItemTagsProvider tags) {
        CommonTags.DYES.values().forEach(tag -> tag.generateCommon(tags));
        CommonTags.IRON_NUGGETS.generateCommon((RegistrateTagsProvider<Item>)tags);
        CommonTags.ZINC_NUGGETS.generateCommon((RegistrateTagsProvider<Item>)tags);
        CommonTags.BRASS_NUGGETS.generateCommon((RegistrateTagsProvider<Item>)tags);
        CommonTags.COPPER_INGOTS.generateCommon((RegistrateTagsProvider<Item>)tags);
        CommonTags.IRON_INGOTS.generateCommon((RegistrateTagsProvider<Item>)tags);
        CommonTags.STRING.generateCommon((RegistrateTagsProvider<Item>)tags).generateBoth((RegistrateTagsProvider<Item>)tags, tag -> tag.m_255204_(Items.f_42401_.m_204114_().m_205785_()));
        CommonTags.IRON_PLATES.generateCommon((RegistrateTagsProvider<Item>)tags);
        CommonTags.BRASS_PLATES.generateCommon((RegistrateTagsProvider<Item>)tags);
        for (CRTags.AllItemTags tag2 : CRTags.AllItemTags.values()) {
            if (!tag2.alwaysDatagen) continue;
            CRTagGen.tagAppender(tags, tag2);
        }
    }

    public static TagsProvider.TagAppender<Item> tagAppender(RegistrateItemTagsProvider prov, CRTags.AllItemTags tag) {
        return CRTagGen.tagAppender(prov, tag.tag);
    }

    public static TagsProvider.TagAppender<Block> tagAppender(RegistrateTagsProvider<Block> prov, CRTags.AllBlockTags tag) {
        return CRTagGen.tagAppender(prov, tag.tag);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> TagsProvider.TagAppender<T> tagAppender(RegistrateTagsProvider<T> prov, TagKey<T> tag) {
        void var1_1;
        return CRTagGenImpl.tagAppender(prov, var1_1);
    }
}

