/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityPreDamaged;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Range;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class MisanthropyEnchantment
extends Handler {
    float damage = 2.5f;

    public static CustomEnchantment create() {
        return new CustomEnchantment(){

            public boolean canEnchantUsingEnchantingTable(ItemStack itemStack) {
                return super.canEnchantUsingEnchantingTable(itemStack) && itemStack.m_41720_() instanceof SwordItem;
            }
        }.rarity(Enchantment.Rarity.UNCOMMON).category(MajruszsEnchantments.IS_MELEE_MINECRAFT).slots((List)EquipmentSlots.MAINHAND).maxLevel(5).minLevelCost(level -> level * 8 - 3).maxLevelCost(level -> level * 8 + 17).compatibility(enchantment -> !(enchantment instanceof DamageEnchantment));
    }

    public MisanthropyEnchantment() {
        super(MajruszsEnchantments.MISANTHROPY, MisanthropyEnchantment.class, false);
        OnEntityPreDamaged.listen(this::increaseDamage).addCondition(Condition.isLogicalServer()).addCondition(data -> data.attacker != null).addCondition(data -> EntityHelper.isHuman((Entity)data.target)).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.attacker));
        this.config.define("damage_bonus_per_level", Reader.number(), s -> Float.valueOf(this.damage), (s, v) -> {
            this.damage = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(100.0f)).clamp((Number)v)).floatValue();
        });
    }

    private void increaseDamage(OnEntityPreDamaged data) {
        data.damage += (float)EnchantmentHelper.getLevel((Supplier)this.enchantment, (LivingEntity)data.attacker) * this.damage;
        data.spawnMagicParticles = true;
    }
}

