/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDied;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.CustomEnchantment;
import com.majruszlibrary.item.EnchantmentHelper;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.item.ItemHelper;
import com.majruszsenchantments.MajruszsEnchantments;
import com.majruszsenchantments.common.Handler;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

@AutoInstance
public class ImmortalityEnchantment
extends Handler {
    public static CustomEnchantment create() {
        return new CustomEnchantment().rarity(Enchantment.Rarity.RARE).category(MajruszsEnchantments.IS_SHIELD).slots((List)EquipmentSlots.HANDS).minLevelCost(level -> 20).maxLevelCost(level -> 50);
    }

    public ImmortalityEnchantment() {
        super(MajruszsEnchantments.IMMORTALITY, ImmortalityEnchantment.class, false);
        OnEntityDied.listen(this::cheatDeath).addCondition(Condition.isLogicalServer()).addCondition(data -> EnchantmentHelper.has((Supplier)this.enchantment, (LivingEntity)data.target));
    }

    private void cheatDeath(OnEntityDied data) {
        EnchantmentHelper.remove((Supplier)this.enchantment, (ItemStack)ItemHelper.getHandItem((LivingEntity)data.target, itemStack -> EnchantmentHelper.has((Supplier)this.enchantment, (ItemStack)itemStack)));
        EntityHelper.cheatDeath((LivingEntity)data.target);
        data.cancelDeath();
    }
}

